/*
 *	tget - terminal get input and function key simulation for vir
 *	2/28/83
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"

extern char mget();
extern char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */
extern int	recsize;	/* current expanded record size */
extern int	new_size;	/* new record (compressed) size */
extern int	icnt;	/* size of command line (= recsize) */
extern int	ttyorig[3],ttybraw[3],ttyraw[3],ttynorm[3];
extern char eor, inrdy, *ok, *cls, *fmto, *nrec, *cnrec;
extern int cls_l, fmto_l, ok_l, errno, nrec_l, cnrecl;
extern char *rdln;
extern int termtype, rdln_l;
extern int lnmode, dlymode, ntry;
extern int fmtstate, ltype;
extern struct fmt_inf fmtinf[MAXFMT];
extern struct fdef fld[MAXFLD];

/*  DIAGNOSTIC */
extern int debflg;

extern int	nrd, maxrd, maxrec;
extern char	rbuf[80];	/* spare line buffer */
extern char	dfile[50];	/* current in use file name */
extern int	scrst;

#ifdef DUMBKEY
/*  FUNCTION MEMORY - for dumb function key support on et2, dgx, and v400 terminals */
#define	FUNCSIZE	300
#define	NUMFUNC	10
extern int simfunc;
extern char simhigh, simlow;
extern char *keyfile;
char	funcmem[FUNCSIZE];	/* programmable function memory */
int	funcst[NUMFUNC];	/* pointers to start of functions */
int	funclen[NUMFUNC];	/* function lengths */
int	funcmax	0;
/* date setting code */
long	atime;
char *chtime, date[8];
extern char *ctime();
char *mname[] {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
char *mnum[] {
	"01", "02", "03", "04", "05", "06",
	"07", "08", "09", "10", "11", "12"
	};
#endif

/*******************************  compress  ***********************************/

/* compress - squeeze out field separators */
compress(cmode)
int cmode;
{
register int i, j;
register char c;
int f, fs, i1, i2;
	j=0;
#ifdef B150
	if (stripper && fmtstate && (cmode == 2)) {
		ncpy(ibuf, tbuf, recsize);
		i = 1;	/* skip leading tab or stx */
		i1 = fmtinf[ltype].st_fld;
		i2 = fmtinf[ltype].end_fld;
		for (f=i1; i<i2; f++) {
			fs = fld[f].f_size;
			while (fs) {
				c = ibuf[i++] & 0177;
				if (c == eor) goto done;
				if (c == '\t') break;
				if (( c < 040) || (c == 0177)) continue;
				tbuf[j++] = c;
				fs--;
				if (i >= recsize) goto done;
			}
			if (!fs) i++;	/* skip field separator */
			while (fs--) tbuf[j++]= ' ';
		}
	}  else  {
#endif B150
		for (i=0; i<recsize; i++) {
			c = tbuf[i];
			if ((c < 040) || (c == 0177)) continue;
			tbuf[j++] = c;
		}
#ifdef B150
	}
#endif B150
done:
	recsize = j;
	for (i=j-1; i> 0; i--) {
		if (tbuf[i] == ' ') {
			recsize--;
			continue;
		}
		break;
	}
	tbuf[recsize] = '\0';
}

/*******************************  getin  ***********************************/

/* imode - 0= command, 1=scanning, 2=entering (append) or updating */
getin(imode)
int	imode;
{
register int i, j;
register char	ch, xch;

	if (termtype == 0) goto pterm;
	if (scrst == 0)
		if (termtype == 4) {
			if (fmtstate == 0)
				write(1,cnrec,cnrecl);
			else
				write(1,nrec,nrec_l);
		} else {
			write(1,nrec,nrec_l);
			sleep(1);
		}
	stty(0, ttyraw);	/* raw mode */
wtinit:
	j = 0;
wtlp:
	nrd = read(0, rbuf, 80);
	if (nrd < 1) goto wtlp;
	for (i=0; i<nrd; i++) {
		ch = rbuf[i] & 0177;
		if (ch == inrdy) goto sig_in;
		if ((ch < 040) || (ch == 0177)) continue;
		tbuf[j++] = ch;
	}
	goto wtlp;
sig_in:
#ifdef DUMBKEY
	if (simfunc) {  /* check for function key request */
		xch = tbuf[0];
		if ((xch >= 'A') && (xch <= 'Z')) xch = xch - 'A' + simhigh;
		/* fold shifted f1-f4 on et2 to same as f5-f8 on other terminals */
		if ((xch > simlow) && (xch <= 'z')) {
			funcdo(xch);
			goto wtinit;
		}
	}
#endif
	tbuf[j++] = '\0';
	icnt = recsize = j;
#ifdef B150
	if (slomode) sleep(1);
#endif
	switch (lnmode) {
		case 2:	/* line presented with request to transmit - teleray and concept */
			if (imode < 2) goto pag_in; /* command only */
			ch = tbuf[0];
			if ((ch == '@') || (ch == '!') || (ch == '&') || (ch == '#')) goto pag_in;
			getpage(0);
			goto pag_in;
		case 1: /* line transmit request available - et2 and b150 */
			if (imode < 2) getpage(1);  /* line */
				else
				getpage(0);	/* full page */
			goto pag_in;
		default:
			/* only page transmit available */
			getpage(0);
			goto pag_in;
	}
pterm:
	recsize = read(0, tbuf, 150);
pag_in:
	stty(0,ttynorm);
	compress(imode);
	icnt = recsize;
	ch = tbuf[0];
	scrst = 0;
	switch (ch) {
		case '!':  return(1);
		case '@':  return(2);
		case '&':  return(3);
		case '#':  return(4);
		default:  return(0);
	}
}

/*******************************  getpage  ***********************************/

/* terminal is ready to transmit*/

getpage(pmode)
int pmode;
{
register int curcnt, i;
register char c;
int	oldcnt;
	ntry = 0;
	if (pmode) {
		write(1,rdln, rdln_l);
		goto inst2;
	}
	stty(0, ttybraw);	/* block raw */
inst:
	lock(1);
	nice(HIPRI);
	write(1, ok, ok_l);
inst2:
	curcnt = 0;
inlp:
	nrd = read(0, &tbuf[curcnt], 512);
	if (nrd <1) {
		/* error - help */
		quitsig(31);
	}
	if (nrd > maxrd) maxrd = nrd;
	oldcnt = curcnt;
	curcnt += nrd;
	for (i=oldcnt; i< curcnt; i++) {
		c = tbuf[i] & 0177;
		if (c == eor)  goto gotrec;
		if (c == 0) goto lost;
	}
	goto inlp;
lost:	/* lost input due to ttyhog limit - trigger retransmit */
	if (ntry++ > 3) quitsig(37);
	lock(0);
	nice(LOPRI);
	sleep(1);
	stty(0, ttybraw);
	goto inst;
gotrec:
	if (!pmode) {
		lock(0);
		nice(LOPRI);
	}
	tbuf[curcnt] = '\0';
	icnt = recsize = curcnt;
	if (recsize > maxrec) maxrec = recsize;
	stty(0, ttyraw);
}


#ifdef DUMBKEY
/******************************  funcdo  ************************************/
/* funcdo - imitate a real function key */

funcdo(ch)
char ch;
{
int fnum, savrs;
	fnum = (ch - 'a') -1;
	if (funclen[fnum] == 0) goto donit;
	savrs = recsize;
	stty(0,ttynorm);
	recsize = funclen[fnum];
	puff(&funcmem[funcst[fnum]]);
	recsize = savrs;
donit:
	stty(0,ttyraw);
}

/*********************************  funcset  *************************************/
/* funcset - read in keyfile and set up for pseudo programmable function keys */

funcset()
{
register int num;
register char c;
register int i;
struct fbuf fibuf;
int fid, ccnt, nulcnt;
char sp[3];
	if ((fid = open(keyfile, 0)) < 0) return(0);
	seek(fid,16,0);	/* skip a.out header */
	mfinit(&fibuf, fid);
	for (ccnt=0; ccnt<NUMFUNC; ccnt++) funclen[ccnt] = 0;
/* set up current date in f8 */
	time(&atime);
	chtime = ctime(&atime);
	for (i=0; i<12; i++) {
		if (strncmp(&chtime[4], mname[i], 3) == 0) {
			strncpy(date, mnum[i], 2);
			break;
		}
	}
	strncpy(&date[2], &chtime[8], 2);
	strncpy(&date[4], &chtime[22], 2);
	for (i=0; i<6; i++) {
		if (date[i] == ' ') date[i] = '0';
	}
	strncpy(funcmem,date,6);
	funcmax = 6;
	funclen[6] = 6;
	funcst[6] = 0;
init:
	ccnt = 0;
	nulcnt = 0;
lp:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if ( c == '\0') goto lp;
	sp[ccnt++] = c;
	if (ccnt < 2) goto lp;
	sp[2] = '\0';
	num = atoi(sp);
	num -= 2;
	funcst[num] = funcmax;
	funclen[num] = 0;
lp2:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if (c == '\0') goto lp2;
	goto lp3b;
lp3:
	c = mget(&fibuf);
	if (fibuf.nrd < 1) goto done;
	if (c == '\0') {
		nulcnt++;
		if (nulcnt >=3) goto onedone;
		goto lp3;
	}
lp3b:
	funcmem[funcmax++] = c;
	funclen[num]++;
	goto lp3;
onedone:
	goto init;
done:
	close(fid);
	return(1);
}
#endif
