/*
 * DU-11 Synchronous interface driver
 * Modified for full duplex operation, with a half duplex protocol
 * suitable for the Univac 1100 NTR protocol
 * Modified for buffers outside kernel space 3/3/82
 * by David E. Miran 
 * version of 4/5/82
 */

#include "../hd/param.h"
#include "../hd/user.h"
#include "../hd/conf.h"
#include "../hd/seg.h"

/* device registers */
struct {
	int	rxcsr, rxdbuf;
	int	txcsr, txdbuf;
};

struct du {
	char	*du_ip;
	char	*du_op;
	int	du_nxlst;  /* set to 1 if next char is last input (LRC) */
	int	du_nleft;
	char	du_ibuf[256];
	char	du_obuf[128];
};

unsigned	du_addr  0160100;
struct	du	du_spc;
char	*dumem;		/* pointer to buffer */
int	du_mesg;	/* set if an input message is available */
char	du_nxt;		/* next character to transmit */
int	du_any;		/* set if there is a char in du_nxt */
int	du_state	0;  /* set if du is open */

#define	DONE	0200
#define	IE	0100	/* interrupt enable */
#define	SIE	040	/* data set interrupt enable */
#define CTS	020000	/* clear to send */
#define	CARRIER	010000
#define	RCVACT	04000	/* receiver active - i.e. syncs have been recognized */
#define	DSR	01000	/* data set ready */
#define STRIP	0400	/* strip sync codes */
#define SCH	020	/* sync search */
#define RTS	04	/* request to send */
#define	DTR	02	/* data terminal ready */
#define MR	0400	/* tx master reset */
#define SEND	020	/* activate transmitter */
#define	HALF	010

#define	READ	0
#define	WRITE	1
#define PWRIT	2

#define	DUPRI	25

duopen(dev)
{
	register struct du *dp;
	register *lp;

	if (du_state) {		/* only one open at a time */
		u.u_error = ENXIO;
		return;
	}
	dumem = &du_spc;
	dp = dumem;
	lp = du_addr;
	lp->txcsr = MR;
	lp->rxdbuf = 036226;  /* 8 bit, no parity (compute in prog), internal sync (on 0226) */
	if ((lp->rxcsr&DSR) == 0) {
		u.u_error = EIO;
		return(1);
		}
	lp->rxcsr = 0;
	dp->du_ip = dp->du_ibuf;
	dp->du_op = dp->du_obuf;
	du_mesg = du_any = dp->du_nleft = dp->du_nxlst = 0;
	du_state = 1;
}

duclose(dev)
{
	register *lp;

	lp = du_addr;
	lp->rxcsr = 0;
	lp->txcsr = 0;
	du_state = 0;
}

duread(dev)
{
	register char *bp;
	register struct du *dp;
	register char *n;

	if (du_mesg == 0)
		sleep(dumem, DUPRI);
	dp = dumem;
	bp = dp->du_ibuf;
	n = dp->du_ip;
	while  (bp != n) {
		if (passc(*bp++)<0)
			break;
		}
	dp->du_ip = dp->du_ibuf;
	du_mesg = 0;
}

duwrite(dev)
{
	register struct du *dp;
	register char *bp;
	register *lp;
	int n;

	if (u.u_count==0 )
		return;
	dp = dumem;
	lp = du_addr;
	dp->du_op = bp = dp->du_obuf;
	lp->rxcsr = SIE|RTS|DTR|STRIP|IE|SCH;
	n = 0;
	while (u.u_count!=0) {
		*bp++ = cpass();
		n++;
		if (bp==dp->du_obuf+128) {
			u.u_error = E2BIG;
			return(1);
		}
	}
	dp->du_nleft = n-1;
	du_nxt = *dp->du_op++;
	du_any = 1;
	while((lp->rxcsr&CTS)==0)
		sleep(dumem,DUPRI);
	lp->txcsr = IE|SIE|SEND;
	dustart(dev);
}

dustart(dev)
{
	register struct du *dp;
	register *lp;

	lp = du_addr;
	if (du_any) {
		lp->txdbuf = du_nxt;
		dp = dumem;
		if (dp->du_nleft > 0) {
			du_nxt = *dp->du_op++;
			dp->du_nleft--;
		}  else
			du_any = 0;
	} else {
		lp->txcsr = 0;  /* turn off transmit when mesg done */
	}
}


durint(dev)
{
	register struct du *dp;
	register c;
	register *lp;

	lp = du_addr;
	if(lp->rxcsr&DONE) {
		c = lp->rxdbuf;
		dp = dumem;
		if (dp->du_ip == dp->du_ibuf+256) {
			dp->du_ip = dp->du_ibuf;
			*dp->du_ip++ = 0377;  /* input data overran buffer */
		}
		*dp->du_ip++ = c;
		if (dp->du_nxlst == 1) {
			lp->rxcsr = 0;  /* turn off receive */
			du_mesg = 1;
			dp->du_nxlst = 0;
			wakeup(dumem);
			return;
			}
		if (c == 03)
			dp->du_nxlst = 1;
			/* This was EOM, so LRC is next and that ends message */
	}
}

duxint(dev)
{
	register *lp;

	lp = du_addr;
	if (lp->txcsr & DONE)
		dustart(dev);
}
