/*
 * thist [file]
 * generate a terminal history report from /usr/adm/wtmp or from file if given.
 * report the total amount of time each terminal was signed on since the
 * current wtmp file was started.  Also, report the amount of time that there
 * were exactly n terminals signed on, with n from 0 to NTERM.
 * by David E. Miran
 * April 22, 1982
 */

#include	<myio.h>
#include	<stdio.h>
#define	NTERM	49

char	tname[] "abcdefghijklmnopqrstuvwxyz123456789ABCDEFGHIJKLMNOP";
long	cum[NTERM];	/* time per line */
long	ncum[NTERM];	/* time with n lines active */
long	timon[NTERM];	/* time signed on */
int	stat[NTERM];	/* status - 0=off, 1=on */
long	lastch, diff, hours, mins, secs;
float	dhour;
long recnum 0;
long cumall 0;
long ncumall 0;
int	ncur;		/* current number of terminals active */
char	*file;
int	wfid;
struct	fbuf	f1;
struct	{
	char	name[8];
	char	tty;
	char	fil1;
	long	wtime;
	char	fil2[6];
	}	wrec;

main(argc, argv)
int argc;
char **argv;
{
register int i, j;
register char c;

	if (argc == 1)
		file = "/usr/adm/wtmp";
	else
		file = argv[1];
	if ((wfid = open(file, 0)) < 0) {
		printf("%s: cannot open file %s\n", *argv, file);
		exit(1);
	}
	mfinit(&f1, wfid);
	ncur = 0;
	for (i=0; i<NTERM; i++) {
		cum[i] = ncum[i] = timon[i] = 0;
		stat[i] = 0;
	}
	while (mgetrec(&wrec, 20, &f1)) {
		recnum++;
		i = lookup(wrec.tty);
		if (i == -1)
			for (j = 0; j<NTERM; j++) signoff(j);
		if (i < 0) {
			lastch = wrec.wtime;
			ncur = 0;
			for (j=0; j<NTERM; j++) {
				stat[j] = 0;
				timon[j] = 0;
			}
			continue;
		}
		if ((wrec.name[0] == '\0') || (wrec.name[0] == ' '))
			signoff(i);
		else
			signon(i);
	}
	for (j = 0; j<NTERM; j++) signoff(j);
	printf("line  total time\n");
	for (i=0; i<NTERM; i++) {
		if (cum[i] == 0) continue;
		ftime(cum[i]);
		printf("  %c  %5D:%02D:%02D    %8.2f\n",tname[i],hours,mins,secs,dhour);
	}
	ftime(cumall);
	printf("total %8.2f\n",dhour);
	printf("number of lines  total time active\n");
	for (i=0; i<NTERM; i++) {
		if (ncum[i] == 0) continue;
		ftime(ncum[i]);
		printf("%15d  %5D:%02D:%02D    %8.2f\n",i,hours,mins,secs,dhour);
	}
	ftime(ncumall);
	printf("total %8.2f\n",dhour);
}

lookup(c)
char c;
{
register int i;
	if (c == '|') return(-1);
	for (i=0; i<NTERM; i++)
		if (c == tname[i]) return(i);
	return(-2);
}

signoff(i)
register int i;
{
	if (stat[i] == 0) return;
	diff = wrec.wtime - timon[i];
	if (diff < 0)   {
/*
		printf("negative(timon) diff at rec %D\n", recnum);
*/
		goto diff2;
	}
	cum[i] += diff;
	cumall += diff;
diff2:
	diff = wrec.wtime - lastch;
	if (lastch == 0) diff=0;
/*
	if (diff < 0) printf("negative(lastch) diff at rec %D\n",recnum);
*/
	ncum[ncur] += diff;
	if (ncur > 0) ncumall += (diff * ncur);
	lastch = wrec.wtime;
	timon[i] = 0;
	stat[i] = 0;
	if (ncur>0) ncur--;
}

signon(i)
register int i;
{
	if (stat[i] == 1)  {
		printf("second signon for line %c at rec %D\n",wrec.tty,recnum);
		return;
	}
	diff = wrec.wtime - lastch;
	if (lastch == 0) diff=0;
/*
	if (diff < 0) printf("negative(signon) diff at rec %D\n",recnum);
*/
	ncum[ncur] += diff;
	if (ncur > 0) ncumall += (diff * ncur);
	ncur++;
	lastch = wrec.wtime;
	timon[i] = lastch;
	stat[i] = 1;
}

ftime(t)
long t;
{
long tmp;
	secs = t%60;
	tmp = (t - secs)/60;
	mins = tmp%60;
	hours = tmp/60;
	dhour = t;
	dhour = dhour/3600.;
}
