/*
 *	shutdown

 *	bring system down to single user state gracefully
 *	first signal init to shut down lines, and then
 *	read the process tables and kill all processes other
 *	than 0 and 1 (init).
 *
 *	lookup logic based on csl version of ps.c
 *
 *	by David E. Miran 9/20/82
 *
 */

#include "proc.h"

struct syment {
	char name[8];
	int type;
	char *value;
} ;

struct	syment	*nl0;
struct	syment	*nl1;

struct proc xproc[100];
int nproc;
struct proc *pr;
int
	mem
	,swmem
	;
char
	*coref
	,*symref	"/etc/pssym"
	;

extern struct	syment	*lookup();

main(argc, argv)
char **argv;
{
	register struct proc *rpr;
	int n, b;
	register int i;
	int c;
	int ijk;

	coref = "/dev/mem";
	if ((mem = open(coref, 0)) < 0) {
		printf("No mem\n");
		exit(1);
	}
	syminit();
	kill(1,1);  /* tell init to shut down everything */
	sleep(5);   /* and give it 5 seconds to finish */
	nl0 = lookup("_proc");
	nl1 = lookup("_nproc");
	swmem = open(coref, 0);
	/* get size of proc table */
	seek(mem, nl1->value, 0);
	read(mem, &nproc, 2);
	/*
	 * Locate proc table
	 */
	seek(mem, nl0->value, 0);
	read(mem, xproc, sizeof xproc);		/* read process slots */
	for (i=0; i<nproc; i++) {
		rpr = pr = &xproc[i];
		if (rpr->p_stat == 0)
			continue;
		ijk = rpr->p_pid;
		if (ijk > 1) kill(ijk, 9); /* kill process */
		}
exit(0);
}

int	sym;
int	n_sym;
struct syment *symtab;
struct syment *maxsym;

/*
 * syminit
 *	read symref file to get pre-sorted and striped (of ignored symbols)
 *	symboltable. pre-sorted so ps needn't re-sort it or use linear
 *	search.
 *
 * Format of symref file is that of an a.out with no code (ie, assumes
 * .text and .data sizes are 0).
 *
 * Bob Beck, 28-APR-77.
 */

syminit()
{
	int buff[8];
	int i, j;
	sym = open(symref,0);
	if (sym < 0)
	{	printf("Unable to open %s\n",symref);
		exit(1);
	}
	read(sym,buff,020);
	n_sym = i = buff[4] / 12;
	j = i * 12;
	if (i == 0) {
		printf("No namelist in %s\n",symref);
		exit(1);
	}
	symtab = sbrk(j);
	read(sym,symtab,j);
	maxsym = symtab + i;
	close(sym);
}

/*
 * lookup
 *	look up symbol. if don't find, say so and exit.
 */

struct	syment	*lookup(symb)
char	*symb;
{
  register char *sp, *snp;
  register struct syment *s;
  int i;

	for(s = symtab; s < maxsym; s++) {
		sp = symb; snp = s->name;
		for(i = 0; i < 8; i++)
			if (*sp != *snp++)
				break;
			else
				if (*sp++ == 0)
					return(s);
		if (i == 8)
			return(s);
	}
	printf("Can't find %s\n",symb);
	exit(1);
}
