/*
 * rcopy recsize skip nrec
 * will copy nrec records of size recsize
 * after skipping skip records (via lseek)
 * reads standard input and writes standard output.
 * maximum record size is 1024 bytes
 * by David E. Miran
 * version of 1/6/83
 */

#include	<stdio.h>
#include	<myio.h>


struct	fbuf ifin,ifout;
char	jbuf[1024];

main(argc, argv) 
char **argv;
{
extern long atol();
int recsize;
long nrec;
long start;
extern long lseek();
extern long atol();
long i;

	if (argc != 4) {
		fprintf(stderr,"Usage:  rcopy recsize startrec nrec\n");
		exit(1);
	}
	recsize = atoi(argv[1]);
	start = atol(argv[2]);
	nrec = atol(argv[3]);
	start = start*recsize;
	if (start != 0) lseek(0, start, 0);
	mfinit(&ifin, 0);
	mfinit(&ifout,1);
	for (i=0; i<nrec; i++) {
		if (mgetrec(jbuf, recsize, &ifin) == 0) break;
		mputrec(jbuf, recsize, &ifout);
	}
done:
	mfclose(&ifout);
	exit(0);
}
