/*
 * newdept code
 * will effectively log you out and back in with a different
 * department (project) code.
 * will check valid project code list in /etc/passwd
 * by David E. Miran 12-7-81  Wisconsin State Hygiene Lab
 */

struct {
	char	name[8];
	char	tty;
	char	ifill;
	int	time[2];
	int	ufill;
	char	proj[4];
} utmp;

struct {
	char	name[8];
	char	tty;
	char	ifill;
	int	time[2];
	int	ufill;
	char	proj[4];
} xutmp;

char	pername[8], *pptr;

char	*ttyx;

char projlist[120],projbuf[4],*projp;
char *set0 "0000";
char	*lockfile	"/usr/adm/lockfile";

main(argc, argv)
char **argv;
{
	char pbuf[128];
	register char *namep, *np;
	char pwbuf[9];
	int t, sflags, f, c, uid, gid;
	int pcnt, i;

	ttyx = "/dev/ttyx";
	if ((utmp.tty=ttyn(0)) == 'x') {
		write(1, "Sorry.\n", 7);
		exit();
	}
	ttyx[8] = utmp.tty;
/*   begin new code here  */
	i = getuid() & 0377;
	if (getpw(i, &pbuf)) {
		write(2,"UID not in /etc/passwd\n",23);
		exit(1);
	}
	if (argc != 2) {
		write(2,"Usage:  newdept code\n",21);
		exit(1);
	}
	for (i=0;i<8;i++) {
		if (pbuf[i] == ':') break;
		pername[i] = pbuf[i];
	}
	for (i=0;i<8;i++) {
		if ((pername[i] < 'a') || (pername[i] > 'z')) pername[i] = ' ';
	}
	projp = projbuf;
	pptr = argv[1];
	for (i=0;i<4;i++)
		*projp++ = *pptr++;
/* pername has user id, projbuf has given project */
/* now move to project field of password entry */
	np = pbuf;
	for (i=0;i<4;i++) {
		while (*np++ != ':') ;
	}  /* we have now moved to the project field */
	projp=projlist;
	pcnt=0;
	while (*np != ':') {
		if (*np == '\0') {
			write(1, "bad /etc/passwd\n",16);
			exit(1);
			}
		*projp++ = *np++;
		pcnt++;
		}
	*projp = '\0';
	projp = projbuf;  /* check for all numeric dept code */
	for (i=0; i<4; i++) {
		c = *projp++;
		if ((c < '0') || (c > '9')) goto badproj;
	}
	if (projlist[0] == 'a')  {
		projp = projbuf;
		goto gotproj;
		}
	namep = projlist;
prolp:
	projp = projbuf;
	for (i = 0; i < 4; i++) {
		if (*namep == '\0') goto badproj;
		if (*projp++ != *namep++) goto prolp;
		}
	projp = projbuf;
gotproj:
	for (i=0; i<4; i++)
		utmp.proj[i] = *projp++;
	for (i=0; i<8; i++) {
		utmp.name[i]=pername[i];
		xutmp.name[i]=' ';
	}
	xutmp.proj[0]=xutmp.proj[1]=xutmp.proj[2]=xutmp.proj[3]='0';
	time(xutmp.time);
	time(utmp.time);
	xutmp.tty = utmp.tty;
	while (!flock(lockfile)) sleep(1);
	if ((f = open("/usr/adm/wtmp", 1)) < 0) {
		write(2,"cannot open /usr/adm/wtmp - sorry\n",34);
		exit(1);
	}
	seek(f, 0, 2);
	write(f, &xutmp, 20);
	write(f, &utmp, 20);
	close(f);
	funlock(lockfile);
	write(2,"Now charging Department ",24);
	write(2,projbuf,4);
	write(2,"\n",1);
	exit(0);
badproj:
	write(2,"Invalid Project Number\n",23);
	exit(1);
}
