/*
 * mort Principle Interest #payments [table]
 * will compute monthly payment and total amount paid over life of mortgage
 * Interest is in Annual percentage rate, with 12% entered as .12
 * principle is in dollars.
 * Any entry in the fourth field [table] will print the payment table
 * by David E. Miran
 * version of 12/17/82
 */

#include	<stdio.h>
#include	<math.h>

double pow();

int npay;
double p, mint, annint, monthly, total;

main(argc,argv)
int argc;
char **argv;
{
register int j;
double sum, ix, jx;
double ti, tp;
int flag;
int table;

	if (argc < 4) {
		printf("Usage: mort principal interest #payments [-]\n");
		printf("	Where interest is annual percentage rate (enter 12%% as .12)\n");
		printf("	Optional last argument causes a payment table to be printed\n");
		exit(1);
	}
	table = 0;
	if (argc > 4) table = 1;
	++argv;
	p = atof(*argv);
	++argv;
	annint = atof(*argv);
	++argv;
	npay = atoi(*argv);
	printf("Mortgage computation\nprincipal=%10.2f  Rate = %6.2f  Number of payments=%6d\n",p,annint,npay);
	mint = annint/12.;
	sum = 0;
	ix = 1.0+mint;
#ifdef DEBUG
 printf("mint=%10.4f     ix = %10.6f\n",mint,ix);
#endif
	for (j=1; j<=npay; j++)  {
		jx = j;
		sum = sum + 1.0/pow(ix,jx);
#ifdef DEBUG
		/* debug */ printf("j=%d  jx=%8.2f   sum=%12.4f\n",j,jx,sum);
#endif
	}
	monthly = p/sum;
	total = monthly*npay;
	printf("Monthly payment = %10.2f    Total payments = %12.2f\n",monthly,total);
	if (table) {	/* print a table of payments */
		printf("\nMonth   Remaining Balance  Payment   Interest   Principal\n");
		flag = 0;
		for (j=1; j<=npay; j++) {
			ti = mint*p;
			if (monthly > (p+ti)) {
				tp = p;
				monthly = tp+ti;
				flag = 1;
			} else
				tp = monthly-ti;
			p = p + ti - monthly;
			printf("%5d%20.2f%9.2f%11.2f%12.2f\n",j,p,monthly,ti,tp);
			if (flag) break;
		}
	}
}
