#
/* enq dataset patient [file file file ....]
 * find patient by looking in files of dataset
 * and print all records containing the specified patient name
 * by David E. Miran  -  Wisconsin State Hygiene Lab
 * 9/8/80
 */

#define	DPGROUP	20	/* group id for data processing */

char	rec[2048];
char	ibuf[2048];
char	uname[9];
char	mfile[]	"/2/dp";	/* master directory */
char	afile[]	"auth";		/* file with access authorizations for a data set */
char	datafile[]	"data";	/* directory containing data elements (files) */
char	dir[]	".";		/* the current working directory */

struct	{
	int	inum;
	char	fname[14];
	}	dirent;		/* the directory entry structure */

int	uid, gid, bufeof, recsize;
int	nrd;
int	iptr;			/* ibuf pointer */
int	fptr;			/* for counting off files */
int	fid, dfid;		/* file descriptors */
char	nl[]	"\n";
char	*pptr;

/* args are as follow:
	0 - program name
	1 - data set name
	2 - patient name (actually any patient text)
	3-n - files [optional - all files searched if not specified]
 */
main(argc, argv)
int argc;
char **argv;
{
register int i;
register char c, *cptr;
char *xcptr;

	if (argc < 3) {
		printf("usage: %s dataset patient [file ... ]\n", argv[0]);
		exit(1);
	}
	uid = getuid()&0377;
	gid = getgid()&0377;
	chdir(mfile);
	if (uid == 0) goto auth_sp;
	if (gid == DPGROUP) goto auth_sp;
	if (getpw(uid, rec) != 0) {
		printf("user %d unknown\n", uid);
		exit(1);
	}
	i = 0;
	while ((c = rec[i]) != ':')     uname[i++] = c;
	uname[i] = ',';
	if (argc <2) goto auth_ok; /* only list of data sets */
	if (chdir(argv[1]) < 0) {
		printf("dataset %s does not exist\n", argv[1]);
		exit(1);
	}
	if ((fid = open(afile, 0)) < 0) {
		printf("No authorization file for data set %s\n", argv[1]);
		exit(1);
	}
	iptr = nrd = 0;
	while (getrec()) {	/* returns 0 on eof */
		cptr = uname;
		xcptr = rec;
		c = '\0';
		while (c != ',') {
			c = *cptr++;
			if (c != *xcptr++) break;	/* get next auth record */
			if (c == ',') goto auth_set;	/* good - found name */
		}
	}
	printf("You are not authorized to read data set %s\n", argv[1]);
	exit(1);
auth_sp:
	if (argc <2) goto auth_ok; /* only list of data sets */
	if (chdir(argv[1]) < 0) {
		printf("dataset %s does not exist\n", argv[1]);
		exit(1);
	}
auth_set:
	if (fid) close(fid);
	if (chdir(datafile) < 0) {
		printf("There is no data for data set %s\n", argv[1]);
		exit(1);
	}
auth_ok:
	pptr = argv[2];
	if (argc < 4) goto do_all;
	fptr = 3;
	while (fptr < argc) {
		printf("searching file %s\n",argv[fptr]);
		if ((fid = open(argv[fptr], 0)) < 0) {
			printf("cannot read file %s\n", argv[fptr]);
			fptr++;
			continue;
		}
		scanfile();
		fptr++;
		close(fid);
	}
	goto done;
do_all:
	dfid = open(dir, 0);
	seek(dfid, 32, 0);
	while(read(dfid, &dirent, 16) == 16) {
		if (dirent.inum == 0) continue;
		if ((fid = open(dirent.fname, 0)) < 0) {
			printf("cannot read file %s\n", dirent.fname);
			continue;
		}
		printf("searching file %s\n", dirent.fname);
		scanfile();
		close(fid);
	}
	close(dfid);
done:
	printf("%s done\n", argv[0]);
	exit(0);
}

/* scanfile - search for a patient record in a file */

scanfile()
{
register char c;
register int i, p;
char d;
int j, savi;

	bufeof = iptr = nrd = 0;
	while (getrec()) {
		i = 0;
lp:
		p = 0;
		savi = i;
lp2:
		if ((c = pptr[p++]) == 0) goto match;
		if ((d = rec[i++]) == 0) continue;  /* end of record */
		if (c != d) { /* no match restart on patient and incr on rec */
			i = savi+1;
			goto lp;
		}
		goto lp2; /* matching in progress */
match:
		i = 0;
		while (recsize > 0) {
			j = recsize>78 ? 78:recsize;
			write(1, &rec[i], j);
			write(1,nl, 1);
			i =+ j;
			recsize =- j;
		}
	}
}

/* getrec - read a record into buffer rec as a standard compressed record - i.e.
 * strip out newlines and consider ! to mark the end of the record.
 * return 1 with record, or 0 on eof
 */

getrec()
{
register char c;
register int i;
	i = 0;
glp:
	c = get();
	if (bufeof) return(0);
	if (c == '\n') goto glp;
	rec[i++] = c;
	if (c == '!') {
		recsize = i;
		rec[i] = '\0';
		return(1);
	}
	goto glp;
}

char get()
{
	if (iptr == nrd) {
		nrd = read(fid, ibuf, 2048);
		if (nrd < 1) {
			bufeof = 1;
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}
