/*
 * login [ name ]
 * modified to ask for department (project) code
 * by David E. Miran 4-29-80  Wisconsin State Hygiene Lab
 * modified for file lockout on wtmp file by dem 4/1/81
 * modified for limits on # users logged in by dem 6/30/82
 * version of 7/1/82
 */

#include	<stdio.h>
#define		MAXTTY	62

struct {
	char	name[8];
	char	tty;
	char	ifill;
	int	time[2];
	int	ufill;
	char	proj[4];
} utmp;

struct {
	int	speeds;
	char	erase, kill;
	int	tflags;
} ttyb;

struct {
	int	junk[5];
	int	size;
	int	more[12];
} statb;

char	*ttyx;

char projlist[150],projbuf[4],*projp;
char *set0 "0000";
char	*lockfile	"/usr/adm/lockfile";
char	*limfile	"/etc/logmax";
char	*utfile		"/etc/utmp";
int	loglim	18;	/* max number of users logged in - default 18 */
int	logcnt;
struct	utps	{
		char	ua;
		char	ub[15];
	};
struct	utps	utp[MAXTTY];

#define	ECHO	010

main(argc, argv)
char **argv;
{
	char pbuf[256];
	register char *namep, *np;
	char pwbuf[9];
	int t, sflags, f, c, uid, gid;
	int pcnt, i, j;

	signal(3, 1);
	signal(2, 1);
	nice(0);
	ttyx = "/dev/ttyx";
	if ((utmp.tty=ttyn(0)) == 'x') {
		write(1, "Sorry.\n", 7);
		exit();
	}
	ttyx[8] = utmp.tty;
	gtty(0, &ttyb);
	ttyb.erase = '#';
	ttyb.kill = '@';
	stty(0, &ttyb);
    loop:
	namep = utmp.name;
	if (argc>1) {
		np = argv[1];
		while (namep<utmp.name+8 && *np)
			*namep++ = *np++;
		argc = 0;
	} else {
		write(1, "login: ", 7);
		while ((c = getc(stdin)) != '\n') {
			if (c <= 0)
				exit();
			if (namep < utmp.name+8)
				*namep++ = c;
		}
	}
	while (namep < utmp.name+8)
		*namep++ = ' ';
	t = 0;
	for (i=0; i<8; i++) {
		if ((utmp.name[i] != ' ') && (t != 0)) goto bad;
		if (utmp.name[i] == ' ') t++;
	}
/* modified here for restrictions on number of users logged in */

	if (strncmp(utmp.name,"root",4) == 0) goto letin;  /* root always ok */
	if (strncmp(utmp.name,"who",3) == 0) goto letin;  /* as is who */
	if ((f = open(limfile,0)) < 0) goto gotlim;  /* no limits file */
	i = read(f, &logcnt, 2);
	if (i < 2) {	/* no limit in limits file */
		close(f);
		goto gotlim;
	}
	loglim = logcnt;
	close(f);
gotlim:
	if (loglim == 0) goto nologb;  /* logins turned off */
	if ((f = open(utfile, 0)) < 0) goto letin;
	t = read(f, &utp[0],MAXTTY * sizeof (struct utps));
	close(f);
	i = t/sizeof (struct utps);
	logcnt = 0;
	for (t=0; t<i; t++)
		if (utp[t].ua != '\0') logcnt++;
	if (logcnt < loglim) goto letin;
	write(1,"System too busy. Try Later.\n",28);
	exit(0);
nologb:
	write(1,"Login not allowed now.\n",23);
	exit(0);
letin:
	if (getpwentry(utmp.name, pbuf))
		goto bad;
	np = colon(pbuf);
	if (*np!=':') {
		sflags = ttyb.tflags;
		ttyb.tflags =& ~ ECHO;
		stty(0, &ttyb);
		write(1, "Password: ", 10);
		namep = pwbuf;
		while ((c=getc(stdin)) != '\n') {
			if (c <= 0)
				exit();
			if (namep<pwbuf+8)
				*namep++ = c;
		}
		*namep++ = '\0';
		ttyb.tflags = sflags;
		stty(0, &ttyb);
		write(1, "\n", 1);
		namep = crypt(pwbuf);
		while (*namep++ == *np++);
		if (*--namep!='\0' || *--np!=':')
			goto bad;
	}
	np = colon(np);
	uid = 0;
	while (*np != ':')
		uid = uid*10 + *np++ - '0';
	np++;
	gid = 0;
	while (*np != ':')
		gid = gid*10 + *np++ - '0';
/* code to ask for department number if numbers are in /etc/passwd
   will only ask if more than 1 department number in /etc/passwd, or
   if code in /etc/passwd is 'a' (for all).
   If no dept codes in /etc/passwd then no code is requested.
 */
	projp=projlist;
	pcnt=0;
	np++;
	while (*np != ':') {
		if (*np == '\0') {
			write(1, "bad /etc/passwd\n",16);
			exit(1);
			}
		*projp++ = *np++;
		pcnt++;
		}
	*projp = '\0';
	if (pcnt == 0) {
		projp = set0;
		goto gotproj;
		}
	if (projlist[0] == 'a') goto askproj;
	if (pcnt == 4) {
		projp = projlist;
		goto gotproj;
		}
askproj:
	write(1, "Department Code: ", 17);
	projp = pwbuf;
	t = 0;
	while ((c = getc(stdin)) != '\n') {
		if (c <=0)
			exit();
		if (projp < pwbuf + 4)
			*projp++ = c;
		t++;
		}
	if (t != 4) goto badproj;
	*projp++ = '\0';
	projp = pwbuf;  /* check for all numeric dept code */
	for (i=0; i<4; i++) {
		c = *projp++;
		if ((c < '0') || (c > '9')) goto badproj;
	}
	if (projlist[0] == 'a')  {
		projp = pwbuf;
		goto gotproj;
		}
	namep = projlist;
prolp:
	projp = pwbuf;
	for (i = 0; i < 4; i++) {
		if (*namep == '\0') goto badproj;
		if (*projp++ != *namep++) goto prolp;
		}
	projp = pwbuf;
gotproj:
	for (i=0; i<4; i++)
		utmp.proj[i] = *projp++;
	np = colon(np);
	namep = np;
	np = colon(np);
	if (chdir(namep)<0) {
		write(1, "No directory\n", 13);
		goto loop;
	}
	time(utmp.time);
	if ((f = open(utfile, 1)) >= 0) {
		i = utmp.tty;
		if ((i >= 'a') && (i <= 'z')) {
			j = i - 'a';
			goto got_ut;
		}
		if ((i >= '0') && (i <= '9')) {
			j = i - '0' + 26;
			goto got_ut;
		}
		j = i - 'A' + 36;
got_ut:
		seek(f, j*16, 0);
		write(f, &utmp, 16);
		close(f);
	}
	while (!flock(lockfile)) sleep(1);
	if ((f = open("/usr/adm/wtmp", 1)) >= 0) {
		seek(f, 0, 2);
		write(f, &utmp, 20);
		close(f);
	}
	funlock(lockfile);
	if ((f = open("/etc/motd", 0)) >= 0) {
		while ((t = read(f, projlist, 150)) > 0)
			write(1, projlist, t);
		close(f);
	}
	if(stat(".mail", &statb) >= 0 && statb.size)
		write(1, "You have mail.\n", 15);
	chown(ttyx, uid);
	setgid(gid);
	setuid(uid);
	if (*np == '\0')
		np = "/bin/sh";
	execl(np, "-", 0);
	write(1, "No shell.\n", 9);
	exit();
bad:
	write(1, "Login incorrect.\n", 17);
	goto loop;
badproj:
	write(1, "Invalid Dept Code.\n", 19);
	goto loop;
}

getpwentry(name, buf)
char *name, *buf;
{
FILE	*fin;
	int fi, r, c;
	register char *gnp, *rnp;

	r = 1;
	if((fi = open("/etc/passwd", 0)) < 0)
		goto ret;
	fin = fdopen(fi, "r");
loop:
	gnp = name;
	rnp = buf;
	while((c=getc(fin)) != '\n') {
		if(c <= 0)
			goto ret;
		*rnp++ = c;
	}
	*rnp++ = '\0';
	rnp = buf;
	while (*gnp++ == *rnp++);
	if ((*--gnp!=' ' && gnp<name+8) || *--rnp!=':')
		goto loop;
	r = 0;
ret:
	fclose(fin);
	return(r);
}

colon(p)
char *p;
{
	register char *rp;

	rp = p;
	while (*rp != ':') {
		if (*rp++ == '\0') {
			write(1, "Bad /etc/passwd\n", 16);
			exit();
		}
	}
	*rp++ = '\0';
	return(rp);
}
