/*
 *	myio.c
	a buffered i/o package by
	David E. Miran   7/2/81
 */

#include	"myio.h"

mput(c, file)
char c;
struct fbuf *file;
{
	file->buf[file->ptr++] = c;
	if (file->ptr >= BSIZE) {
		write(file->fid, file->buf, BSIZE);
		file->ptr = 0;
	}
}

mputrec(rec, n, file)
register char *rec;
int	n;
struct fbuf *file;
{
	register i;
	for (i=0; i<n; i++)
		mput(*rec++, file);
}

char mget(file)
struct fbuf *file;
{
register char c;
	if (file->ptr == file->nrd) {
		file->nrd = read(file->fid, file->buf, BSIZE);
		if (file->nrd < 1) return(0);
		file->ptr = 0;
	}
	c = file->buf[file->ptr++];
	return(c);
}

mgetrec(rec, n, file)
register char *rec;
int n;
struct fbuf *file;
{
	register int i;
	register char c;
	for (i=0; i<n; i++) {
		c = mget(file);
		if (file->nrd < 1) return(0);
		rec[i] = c;
	}
	return(1);
}
/* finit */

mfinit(file, id)
struct fbuf *file;
int id;
{
file->fid = id;
file->nrd = file->ptr = 0;
}


mfclose(file)
struct fbuf *file;
{
	if (file->nrd != 0) goto close_it;
	if (file->ptr > 0) write (file->fid, file->buf, file->ptr);
close_it:
	close(file->fid);
}

mflush(file)
struct fbuf *file;
{
	if (file->ptr > 0) write (file->fid, file->buf, file->ptr);
	file->ptr = file->nrd = 0;
}
mgetlin(rec, file)
register char *rec;
struct fbuf *file;
{
	register int i;
	register char c;
	i = 0;
lp:
	c = mget(file);
	if (file->nrd < 1) return(0);
	if (c == '\n') {
		rec[i] = '\0';
		return(i);
	}
	rec[i++] = c;
	goto lp;
}
