/*
 *	dpack [-r] file ...
 *	pack files with holes (0177 characters) in them and optionally
 *	regular them at the same time (-r option)
 *	by David E. Miran   3/19/81
 */

#include	<myio.h>
#include	<stdio.h>
char	*packtmp "/tmp/ptmpXXXXXX";
char	*progname;
int	rflag	0;
int	cpos	0;
char	fldsep	'\'';
char	recsep	'!';

extern char mget();

main(argc, argv)
int argc;
char **argv;
{

	progname = *argv;
	mktemp(packtmp);
	while (--argc) {
		argv++;
		if (strcmp(*argv, "-r") == 0) {
			rflag = 1;
			continue;
		}
		packit(*argv);
	}
	unlink(packtmp);
}

/* packit - squeeze deleted records out of a file */

packit(file)
char *file;
{
extern char mget();
int fidi, fido;
struct fbuf bufi, bufo;
register int i;
register char c;
int delseen;

	delseen = 0;
	if ((fido = creat(packtmp, 0600)) < 0) {
		printf("cannot create pack temp file %s\n", packtmp);
		exit(1);
	}
	if ((fidi = open(file, 2)) < 0) {
		close(fido);
		printf("file %s not packed\n",file);
		return(1);
	}
	mfinit(&bufi, fidi);
	mfinit(&bufo, fido);
lp:
	c = mget(&bufi);
	if (bufi.nrd <1) goto cpback;
	if (c == 0177) {
		delseen = 1;
		goto lp;
	}
	if (rflag) {
		regput(c, &bufo);
	}  else  {
		mput(c, &bufo);
	}
	goto lp;
cpback:
	mfclose(&bufo);
	close(fidi);
	fido = creat(file, 0664);
	fidi = open(packtmp, 0);
	while ((i = read(fidi, &bufo, BSIZE)) > 0)
		write(fido, &bufo, i);
	close(fidi);
	close(fido);
	printf("%s:  file %s packed.\n",progname,file);
}

regput(c, buf)
char c;
struct fbuf *buf;
{
	if (c == '\n') return;
	mput(c, buf);
	cpos++;
	if (cpos == 80) {
		mput('\n', buf);
		cpos = 0;
		return;
	}
	if (c == recsep) {
		mput('\n', buf);
		cpos = 0;
	}
}
