.TH PARAM 3L 
.SH NAME
is_param, nameparam, parameter, timeparam, is_flag - search command
line and environment strings
.SH SYNOPSIS
.nf
#include "param.h"

int is_param (param)
char *param;

char *nameparam (param, defalt)
char *param, *defalt;

double parameter (param, defalt)
char *param; double defalt;

TIME timeparam (param, defalt)
char *param; TIME defalt;

double *listparam(param)
 char *param;

double *listparameter(param,endmarker)
 char *param;
 double endmarker;

int is_flag(flag)
char *flag;
.rj
.SH DESCRIPTION
This set of functions examines the program call line for parameters.
A parameter must be of the form "name=value" where the form of
the value part depends on the function used.  The program call line
will be scanned from the start each time one of these functions is
invoked.  If the argument "env=yes" is found the environment strings
that have been exported will also be examined.

.B is_param
returns 1 if the name given in param is found.

.B nameparam
returns a pointer to a static copy of the argument if it is found.
If nameparam is to be used more than once, the string should be
copied to a safe place.
Only the first 40 chars will be copied.
If the name is a integer, x, the xth argument which is not a flag (starting
with '-' or '+') nor a parameter (contains a '=') is returned.

.B parameter
returns the arithmetic value found.

.B timeparam
returns a pointer to a local DATE structure.  See stdtime.h.
the function atodate() is used to convert the date and should be
consulted for the allowed forms of time.  Since the DATE returned is
local to timeparam, a copy should be made in a safe place.

.B listparam, listparameter
returns a pointer to a double array of values.
The values are obtained from the command line call of
param=val1,val2,... (a comma separated list -- no spaces.)
listparam terminates the list with MISSING,
listparameter terminates the list with endmarker.
Both return a null pointer ( (double *)0 ) if param is not specified.

.B is_flag
takes a one or two character string argument.  The first character is an 
optional sign, the second any character. The routine returns 1 if it finds an
argument on the command line consisting of the sign (default is '-') followed
by a string containing the appropriate character.

.SH FILES
.nf
param.h
stdtime.h
param.c (h?)
/usr/local/lib/libdate.a
/usr/man/manl/param.l
.rj
.SH SEE ALSO
atodate(3L), dsparam(3d), date(3L), sh(1), environ(5)
.SH BUGS
The method used to find the command line may be system dependent.
