/*	getnames - routine to get a list of file names
 *	for dataset, or other use.  Call with a pointer to
 *	a table of strings and a prototype string, such as "in"
 *	which defines the list.  getnames will try first
 *	(in the case of "in" e.g.):
 *		inlist=<file containing list of files>
 *			- then -
 *		in=<file to use>
 *			- then -
 *		<non-parameter list of file names>
 *			- then -
 *		"<"  (i.e. stdin)
 *	getnames will return the number of names found.
 *	NOTE that at least 1 name will always be "found"
 *	so you must check for the "<" if you don't want it.
 *
 *	A sample example follows:
 *
 *		DATASET *dsin;
 *		char *fn, **namelist;
 *		
 *		for (getnames(&namelist); (fn = *namelist++) != NULL; )
 *			{
 *			dsin = dsopen(fn,"R");
 *			.
 *			.
 *			.
 *			dsclose(dsin);
 *			}
 */

#include <stdio.h>
#include "param.h"

#define NAME_CHUNK 20

int num_names;
int max_names;
char **namelist;

int getnames(kind,names)
char *kind;
char **names[];
{
char buf[100];
num_names = 0;
max_names = 0;
namelist = NULL;
strcpy(buf,kind);
strcat(buf,"list");
if (is_param(buf))
	{
	FILE *fp;
	strcat(buf,"=");
	fp = fopenparam(buf,"r");
	while (fscanf(fp,"%s",buf) == 1)
		_name_insert (buf);
	fclose(fp);
	}
else if (is_param(kind))
	_name_insert (nameparam(kind,""));
else if (is_param("1"))
	{
	char n[5];
	int i;
	for (i=1; ;i++)
		{
		sprintf(n,"%d",i);
		if (!is_param(n))
			break;
		_name_insert (nameparam(n,""));
		}
	}
else
	_name_insert ("<");

*names = namelist;
namelist[num_names] = NULL;
return(num_names);
}

_name_insert(buf)
char *buf;
{
char *nextname, **tmp;
nextname = (char *) malloc(strlen(buf)+1);
strcpy(nextname,buf);
num_names += 1;
if (num_names >= max_names)
	{
	max_names += NAME_CHUNK;
	tmp = (char **)malloc(max_names * sizeof(char *));
	if (namelist != NULL)
	    {
	    tofrom(tmp, namelist, (num_names-1)*sizeof(char *));
	    free (namelist);
	    }
	namelist = tmp;
	}
namelist[num_names-1] = nextname;
}
