#define	C1	0.0757646111
#define C2	92353.9357
#define SID	86400.0

#include "stdtime.h"

TIME carrtime(CT,crot,clong)
TIME *CT;
int *crot,*clong;

/*
  If CT = 0 or *CT,*crot, and *clong are 0 their values will be computed
    using the time from the structure curtime.
  If *CT is non-zero the other quantities are computed and date is
    called with the computed standard time.
  If *CT = 0 but *crot or *clong are non-zero the CT and the stdtime
    are computed and date is called.

  In every case, the return value is the Carrington Time (CT) and
    date is called with the appropriate stdtime to update the date
    structure curtime.
*/

{
int deg;
TIME rsd;
TIME lt,TEST;

if(CT!=0 && *CT != 0.0) 
	{
	deg = *CT;
	*crot = deg/360 + 1;
	*clong = 360 - deg%360;
	lt = (C2+C1*(*CT))*SID;
	date(lt);
	return(*CT);
	}

  else if(CT != 0 && (*crot != 0 || *clong != 0))
	{
	*CT = 360 * *crot - *clong;
	lt = (C2 + *CT * C1) * SID;
	date(lt);
	return(*CT);
	}

  else	{
	lt = (curtime._time/SID - C2)/C1;
	if(CT != 0)	*CT = lt;
	deg = lt + 0.5;
	*crot = deg/360 + 1;
	*clong = 360 - deg%360;
	date(curtime._time);
	return(lt);
	}
}
