h37369
s 00053/00000/00000
d D 1.1 82/10/06 14:28:42 jan 1 0
e
u
U
t
T
I 1
/*

Name:
	findenv

Function:
	The first argument is a string which might be an environment variable.
	The second argument is the pointer to the environment.
	The string is looked up, and if it is found, a pointer to the null-
	terminated string to substitute is returned.  Otherwise, zero is
	returned.

Parameters:
	bp = pointer to environment variable
	envp = pointer to environment list (third arg to main from exece)

Returns:
	A pointer to the string to substitute, or 0 for not found.

Files and Programs:
	None.
*/


char *findenv(bp,envp)

char *bp;	/* pointer to variable to look up */
char **envp;	/* pointer to the environment */

{
	static char id[] = "%W% %H%";
	register char *name, *cur;
	char **elist;

	name = bp;		/* set to start of name */
	cur = *(elist = envp);  /* environment list */
	while (cur)  {		/* seek thru envpg list */
		if (*cur == '=')	/* end of env name */
		    if (*name == '\0')      /* exact hit */
			return(++cur);
		    else  {   /* env name short; try next one */
			cur = *elist++;
			name = bp;
			continue;
		    }
		if (*name++ != *cur++)  {   /* try next one */
			cur = *elist++;
			name = bp;
		}
		/* at this point the chars were equal; try next ones */
	}
	return (0);		/* no match was found */
}
E 1
