/*

Name:
	delist

Function:
	Remove the item from the list.

Algorithm:
	Open a temp file. Extract the item and discard it.
	Copy rest of list file to temp. Close the list and temp files.
	Unlink the old list file and link the new list file from the temp
	file. Error exit if temp file problems.

Parameters:
	list file               pointer to list file
	item number		the line number of the dolist item in the dolist file

Returns:
	ENOERR	Normal exit
	EACESS  Access error to files.

Files and Programs:
	user supplied list file or default list file


*/
#include <stdio.h>
#include "../../includes/getdef.h"
#include "../../includes/error.h"
#define TEMPFILE "/tmp/delistXXXXXX"


delist(lfile, item)
char *lfile,
     *item;

{
    static char id[] = "%W% %H%";
    char   *tfile,                                      /* Pointer to temp file name */
	   *line,                                       /* Holds extracted line */
	    com_buf[CMDLEN],
	   *command = com_buf;
    int     index;
    FILE   *tfp, *fp;


    if ((fp = fopen(lfile, "r")) == NULL)   {           /* Open dolist */
	fprintf (stderr, "delist: cannot open dolist %s\n", lfile);
	exit (EACCES);
    }
    tfile = mktemp (TEMPFILE);
    if ((tfp = fopen(tfile, "a")) == NULL)      {
	fprintf(stderr, "delist: cannot open temp file %s\n", tfile);
	exit (EACCES);
    }
    for (index = 1; ((line = getline(fp)) != NULL); index++)
	if (index != atoi(item))        {
	    fputs (line, tfp);
	    fputc ('\n', tfp);
	}
    if ((fclose(tfp)) == EOF)     {
	fprintf (stderr, "cannot close file %s\n", tfile);
	exit (EACCES);
    }
    if ((fclose(fp)) == EOF)      {
	fprintf (stderr, "cannot close file %s\n", lfile);
	exit (EACCES);
    }
    sprintf(command, "cp %s %s", tfile, lfile);
    if ((system(command)) != 0)             {                /* Copy the temp file */
	fprintf (stderr, "delist: error on system call\n");
	exit (ESYSTEM);
    }
    if ((unlink (tfile)) == -1)         {
	fprintf (stderr, "delist: error unlinking temp file %s\n", tfile);
	exit (EUNLINK);
    }
    return;
}
