h64227
s 00000/00000/00234
d D 1.2 83/05/12 15:11:57 jan 2 1
c USENIX Distribution version
e
s 00234/00000/00000
d D 1.1 82/10/06 12:23:51 jan 1 0
e
u
U
t
T
I 1
/*
Name:
	PRIORITYDO Calendar System Command

Function:
	Change priority of a list item.

Algorithm:
	Scan the user supplied list file for the requested item and extract
	it from the list file. If no user file is supplied, look in the
	users $HOME/exec directory to find the default file. Then use the
	current default dolist. Then change the number of asterisks which
	indicate the item's priority to the new number supplied by the user.

Parameters:
	item number             the line number of the list item in the list file
	user supplied list file
		or
	default file in $HOME/exec/default
	(*...)                  new priority expressed as a string of "*"
Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	user supplied list file
	TEMPFILE                                        temporary file for extraction

Installation Instructions:
	Compile as follows: cc -o $EXEC.DIR/prioritydo prioritydo.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Dec 79,	Release 2 Version 1, G. Maltagliati, coded in shell
	Nov 80,	Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	Jul 82, Release 7 Version 1, L. Reed, for Perkin-Elmer
	Aug 82, Release 7 Version 2, J. Neyer...rewrite exec support


*/
#include <stdio.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#define TEMPFILE "/tmp/priXXXXXX"
#define USAGE "You must enter:  prioritydo item-number stars <-llist-file> <-uauth_user>\n"
#include <pwd.h>
#define USERINVL "prioritydo: Invalid userid\n"
#define NOTAUTH "prioritydo: You are not an authorized user\n"

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Validate parameters. Open the list file.
	Change priority on the item. List the dolist file.

Algorithm:
	Insure that the correct number of arguments were entered on the command
	line. Determine if a user supplied list file was given and open it if
	so. Otherwise, find the default dolist file in $HOME/exec/default
	and open it. Call stardo to extract the item from the dolist and
	change its priority. Call dolist_call to sort and re-display the new
	dolist. Close the files and exit.

Parameters:
	item number		the line number of the dolist item in the dolist file
	stars                   ascii string of "*"s
	user supplied list file or default list file

Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	user supplied list file or default list file


*/
main (argc, argv, envp)
int     argc;						/* Count of command line arguments */
char   *argv[];						/* Pointer to list of argument pointers */
char   **envp;                  /* the environment */
{


    char listfile[80],
	 *lfile,                                        /* Pointer to list file name */
	 *date;
    struct  passwd  *user;
    int index;
    char *line;

    FILE *fp;

    extern char *getline();
    extern char *mktemp();
    extern char *sprintf();
    extern char *strcat();
    extern char *findenv();

    if (argc < 3 || argc > 5)       {
	fprintf (stderr, USAGE);
	exit(EFORM);
    }
    parse(argc, argv, envp, &date, &user, &lfile);
    if (user)                  {
	char uname[10];
	char *uptr = uname;
	char udir[13];
	char *dptr = udir;

	if ((chdir(user->pw_dir)) == -1)      {
	    fprintf(stderr, "prioritydo: cannot access directory %s\n", user->pw_dir);
	    exit (EACCES);
	}
	strcpy(dptr, user->pw_dir);
	strcpy(uptr, user->pw_name);
	if (!authuser())      {
	    fprintf(stderr, NOTAUTH);
	    exit(EFORM);
	}
	strcpy(user->pw_dir, dptr);
	strcpy(user->pw_name, uptr);
    }
    else
	user = getpwnam(findenv("USER", envp));
    if (lfile == NULL)  {                               /* Try to get default file */
	lfile = listfile;
	strcpy (lfile, user->pw_dir);                   /* Get the HOME directory */
	strcat (lfile, "/");
	strcat (lfile, DEFAULT);
	if ((fp = fopen(lfile, "r")) == NULL)   {       /* Try to open default */
	    fprintf (stderr, "prioritydo: cannot open default file %s\n", lfile);
	    exit (EACCES);
	}
	line = getline(fp);
	strcpy(lfile, line);
	fclose(fp);
    }
    if ((fp = fopen(lfile, "r")) == NULL)   {         /* Open the list file */
	printf ("prioritydo: cannot open list file %s\n", lfile);
	exit(EACCES);
    }
    stardo(lfile, argv[1], argv[2]);
    dolist_call(lfile, user->pw_name);
    exit(ENOERR);
}
/*

Name:
	stardo

Function:
	Extract the item from the dolist and add new priority to it.

Algorithm:
	Open a temp file. Extract the do item and changes the priority.
	Copy rest of list file to temp. Close the list and temp files.
	Copy the temp file back to the list file. Unlink the temp file.
	Error exit if temp file problems.

Parameters:
	list file               pointer to list file
	item number		the line number of the dolist item in the dolist file
	stars                   ascii string of '*'s or null

Returns:
	ENOERR	Normal exit
	EACESS  Access error to files.

Files and Programs:
	user supplied list file or default list file


*/
stardo (lfile, item, stars)
char *lfile,
     *item,
     *stars;

{
    char   *tfile,                                      /* Pointer to temp file name */
	   *line,                                       /* Holds extracted line */
	    com_buf[CMDLEN],
	   *command = com_buf;
    int     index;
    FILE   *tfp, *fp;


    if ((fp = fopen(lfile, "r")) == NULL)   {           /* Open dolist */
	fprintf (stderr, "prioritydo: cannot open dolist %s\n", lfile);
	exit (EACCES);
    }
    tfile = mktemp (TEMPFILE);
    if ((tfp = fopen(tfile, "a")) == NULL)      {
	fprintf(stderr, "prioritydo: cannot open temp file %s\n", tfile);
	exit (EACCES);
    }
    for (index = 1; ((line = getline(fp)) != NULL); index++)
	if (index != atoi(item))        {
	    fputs (line, tfp);
	    fputc ('\n', tfp);
	}
	else    {
	    fputs(stars, tfp);
	    while (*line == '*')
		line++;
	    fputs(line, tfp);
	    fputc ('\n', tfp);
	}
    if ((fclose(tfp)) == EOF)     {
	fprintf (stderr, "cannot close file %s\n", tfile);
	exit (EACCES);
    }
    if ((fclose(fp)) == EOF)      {
	fprintf (stderr, "cannot close file %s\n", lfile);
	exit (EACCES);
    }
    sprintf(command, "cp %s %s", tfile, lfile);
    if ((system(command)) != 0)             {                /* Copy the temp file */
	fprintf (stderr, "prioritydo: error on system call\n");
	exit (ESYSTEM);
    }
    if ((unlink (tfile)) == -1)         {
	fprintf (stderr, "prioritydo: error unlinking temp file %s\n", tfile);
	exit (EUNLINK);
    }
    return;
}
E 1
