#include <stdio.h>

/*
 * PFS header block on the BCC-500
 *
 * fff802 000000 ffffff xxxxxx xxxxxx 000000 000000 000000
 * Block 0 header
 * ...
 * Block 339 header
 *
 * Block header:
 *
 *     FNAM0       FNAM1      FNAM2       FNAM3  (6 bit SDS ASCII)
 *     FNAM4       FNAM5      FNAM6       FNAM7
 *     FNAM8       FNAM10     FNAM11      FNAM12
 * |           |           |           |           |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |               |               |               |
 *
 *    FNAM13    S END  TYP              BLK/SIZ
 * |           | |   |     | |                     |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |             1 | 1     1 1     |               |
 *               7   5     2 1
 *
 *  GAC PAC OAC   YR      MO      DA        HR
 * |   |   |   |       |       |         |         |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 * |               |   1       1   |     0         |
 *                     4       0         5
 *
 * |                     PASSWD                    |
 * +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *
 */

char chrtbl[128] =  {
	   ' ', '!', '"', '#', '$', '%', '&','\'', '(', ')', '*', '+', ',', '-', '.', '/',  /* 00 */
	   '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',  /* 10 */
	   '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',  /* 20 */
	   'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[','\\', ']', '^', 0x2b, /* 30 */
	   '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',  /* 40 */
	   'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '.', '>',  /* 50 */
	   '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',  /* 60 */
	   '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.' };/* 70 */

char *months[16] = {
		   "???", "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
		   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
		   "???", "???", "???" };

char year[16] =   { 77,78,79,80,81,65,66,67,69,70,71,72,73,74,75,76};
//                  0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15

unsigned int get24(){
unsigned int i;

	i = getchar();
	i = i<<8 | getchar();
	i = i<<8 | getchar();
	return(i);
}

main()
{
unsigned int len, len2, origlen;
unsigned int i;
unsigned int i24;
unsigned int usernum;
unsigned int filename;
int dircnt = 0;
int lastlen = 0;
int block = 0;

		printf("HEADER: %06x \n",get24());
		i = get24();
		i = get24();
		i = get24();
		i = get24();
		i = get24();
		i = get24();
		i = get24();

		for(dircnt = 0; dircnt < 340; dircnt++){
			i = get24();
			if((i&0xff0000) == 0){
			 // printf("%d: <empty>\n", dircnt);
		 	 get24(); get24(); get24(); get24(); get24();
			 continue;
			}
			if(i == 0xffffff){
			 printf("%3d: <bad>\n", dircnt);
		 	 get24(); get24(); get24(); get24(); get24();
			 continue;
			}
			else{
			 printf("%3d: ",dircnt);
			 printf("%c",chrtbl[(i >> 18)&0x3f]);
			 printf("%c",chrtbl[(i >> 12)&0x3f]);
			 printf("%c",chrtbl[(i >> 6 )&0x3f]);
			 printf("%c",chrtbl[(i      )&0x3f]);

			 i = get24();
                         printf("%c",chrtbl[(i >> 18)&0x3f]);
                         printf("%c",chrtbl[(i >> 12)&0x3f]);
                         printf("%c",chrtbl[(i >> 6 )&0x3f]);
                         printf("%c",chrtbl[(i      )&0x3f]);

			 i = get24();
                         printf("%c",chrtbl[(i >> 18)&0x3f]);
                         printf("%c",chrtbl[(i >> 12)&0x3f]);
                         printf("%c",chrtbl[(i >> 6 )&0x3f]);
                         printf("%c",chrtbl[(i      )&0x3f]);

			 i = get24();
                         printf("%c",chrtbl[(i >> 18)&0x3f]);
			 printf("  %06x ",i);
			 if((i>>17)&1) printf(" R"); else printf(" S");
			 printf("%d ", (i>>11)&7);
			 if(((i>>15)&3) == 2){
			  printf(" <end> %4x ", i & 0x7ff);
			 }
			 else printf("       %4x ", i & 0x7ff);


	 		 i = get24();
			 // printf("%06x ",i);
			 printf("%2d ",(i>>10)&0xf);	        // month
			 printf("%2d ",(i>>5)&0x1f);      	// day
			 printf("19%2d ",year[((i>>14)&0xf)]);	// year
			 printf("H%-2d ",i&0x1f); 	        // hour

			 i = get24();	
			 // printf("%06x \n",i);

			 printf("\n");
			}
		}

}
