C$CONTROL
      PROGRAM FM080
C     COMMENT SECTION
C
C     FM080
C
C         THIS ROUTINE CONTAINS EXTERNAL FUNCTION REFERENCE TESTS.
C     THE FUNCTION SUBPROGRAMS CALLED BY THIS ROUTINE ARE FF081,
C     FF082 AND FF083.  THE FUNCTION SUBPROGRAMS ARE DEFINED AS
C     FF081 = INTEGER, FF082 = REAL, FF083 = IMPLICIT REAL.
C     THE FUNCTION SUBPROGRAM DUMMY ARGUMENTS MUST AGREE IN ORDER,
C     NUMBER AND TYPE WITH THE CORRESPONDING ACTUAL ARGUMENTS OF THE
C     MAIN PROGRAM.     THE ARGUMENTS OF THE FUNCTION SUBPROGRAMS WILL
C     CORRESPOND TO ACTUAL ARGUMENT LIST REFERENCES OF VARIABLE-NAME,
C     ARRAY-NAME, ARRAY-ELEMENT-NAME AND EXPRESSION RESPECTIVELY.
C
C         THIS ROUTINE WILL TEST THE VALUE OF THE FUNCTION AND THE
C     FUNCTION ARGUMENTS RETURNED FOLLOWING THE FUNCTION REFERENCE CALL.
C
C
C     REFERENCE   X3.9-1966, AMERICAN STANDARD FORTRAN
C                    SECTION 8.3.2, REFERENCING EXTERNAL FUNCTIONS
C                    SECTION 10.1.3, ARRAY AND ARRAY ELEMENT
C                    SECTION 10.3, DEFINITON REQUIREMENTS FOR USE OF
C                                  ENTITIES
	DIMENSION  IADN1A (5),   IADN2A (4,4)
	DIMENSION RADN3A (3,6,3), RADN1A (10)
	DIMENSION IADN3A (3,4,5)
	INTEGER FF081
	REAL FF082
C
C     ******************************************************************
C         A COMPILER VALIDATION SYSTEM FOR THE FORTRAN LANGUAGE
C     BASED ON SPECIFICATIONS AS DEFINED IN AMERICAN STANDARD FORTRAN
C     X3.9-1966, HAS BEEN DEVELOPED BY THE DEPARTMENT OF THE NAVY.  THE
C     FORTRAN COMPILER VALIDATION SYSTEM (FCVS) CONSISTS OF AUDIT
C     ROUTINES, THEIR RELATED DATA, AND AN EXECUTIVE SYSTEM.  EACH AUDIT
C     ROUTINE IS A FORTRAN PROGRAM OR SUBPROGRAM WHICH INCLUDES TESTS
C     OF SPECIFIC LANGUAGE ELEMENTS AND SUPPORTING PROCEDURES INDICATING
C     THE RESULT OF EXECUTING THESE TESTS.
C
C         THE AUDIT ROUTINES COLLECTIVELY CONTAIN THE FEATURES OF THE
C     1966 FORTRAN STANDARD WHICH HAVE BEEN INCLUDED IN THE DRAFT
C     PROPOSED AMERICAN NATIONAL STANDATD FORTRAN SUBSET LANGUAGE.
C     THUS, THESE ROUTINES FORM A BASIS FOR THE TESTING OF THE NEW
C     FORTRAN STANDARD.
C
C         CORRECTIONS, SUGGESTIONS AND COMMENTS SHOULD BE FORWARDED TO
C
C                   SOFTWARE DEVELOPMENT DIVISION
C                   ADPE SELECTION OFFICE
C                   DEPARTMENT OF THE NAVY
C                   WASHINGTON, D. C.  20376
C
C     ******************************************************************
C
C
C     INITIALIZATION SECTION
C
C     INITIALIZE CONSTANTS
C      **************
C     I01 CONTAINS THE LOGICAL UNIT NUMBER FOR THE CARD READER.
	I01 = 5
C     I02 CONTAINS THE LOGICAL UNIT NUMBER FOR THE PRINTER.
	I02 = 6
C     SYSTEM ENVIRONMENT SECTION
C
CX010     THIS CARD IS REPLACED BY CONTENTS OF X-010 CARD.
CX011     THIS CARD IS REPLACED BY CONTENTS OF X-011 CARD.
C
	I02 = 1
CX021     THIS CARD IS REPLACED BY CONTENTS OF X-021 CARD.
C
	IVPASS=0
	IVFAIL=0
	IVDELE=0
	ICZERO=0
C
C     WRITE PAGE HEADERS
	WRITE (I02,90000)
	WRITE (I02,90001)
	WRITE (I02,90002)
	WRITE (I02, 90002)
	WRITE (I02,90003)
	WRITE (I02,90002)
	WRITE (I02,90004)
	WRITE (I02,90002)
	WRITE (I02,90002)
	WRITE (I02,90005)
	WRITE (I02,90006)
	WRITE (I02,90002)
C
C     TEST SECTION
C
C     EXTERNAL FUNCTION REFERENCE  -  FUNCTION SUBPROGRAM DEFINED AS
C                                     INTEGER (FF081)
C
6741	CONTINUE
	IVTNUM = 674
C
C         TEST 674 THROUGH 679 TEST THE FUNCTION AND ARGUMENT VALUES
C     FROM REFERENCE OF FUNCTION FF081.  FUNCTION SUBPROGRAM FF081 IS
C     DEFINED AS INTEGER.
C
C     **** TEST 674 ****
C
C     TEST 674 TESTS THE FUNCTION VALUE RETURNED FROM FUNCTION FF081
C
	IF (ICZERO) 36740,6740,36740
6740	CONTINUE
	IVON0A        = 0
	IVON02        = 2
	IADN1A (3)    = 8
	IADN1A (2)    = 4
	IADN2A (1,3)  =10
	IVON0A = FF081 (IVON02, IADN1A, IADN2A, 999)
	GO TO 46740
36740	IVDELE =  IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46740,6751,46740
46740	IF (IVON0A - 1015) 26740,16740,26740
16740	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6751
26740	IVFAIL = IVFAIL + 1
	IVCORR = 1015
	IVCOMP = IVON0A
	WRITE  (I02,80004) IVTNUM, IVCOMP, IVCORR
6751	CONTINUE
	IVTNUM = 675
C
C     ****  TEST 675  ****
C
C         TEST 675 TESTS THE RETURN VALUE OF VARIABLE-NAME ARGUMENT
C     IVON02.   VALUE OF IVON02 SHOULD BE 4.
C
	IF (ICZERO) 36750,6750,36750
6750	CONTINUE
	GO TO 46750
36750	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46750,6761,46750
46750	IF (IVON02 - 4) 26750,16750,26750
16750	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6761
26750	IVFAIL = IVFAIL + 1
	IVCORR = 4
	IVCOMP = IVON02
	WRITE  (I02,80004) IVTNUM, IVCOMP, IVCORR
6761	CONTINUE
	IVTNUM = 676
C
C     ****  TEST 676  ****
C
C         TEST 676 TESTS THE RETURN VALUE OF ARRAY-NAME ARGUMENT
C     IADN1A.  IADN1A (2) IS INCREMENTED BY 40 IN FUNCTION SUBPROGRAM
C     AND SHOULD RETURN A VALUE OF 44.
C
	IF (ICZERO) 36760,6760,36760
6760	CONTINUE
	GO TO 46760
36760	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46760,6771,46760
46760	IF (IADN1A (2) - 44) 26760,16760,26760
16760	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6771
26760	IVFAIL = IVFAIL + 1
	IVCORR = 44
	IVCOMP = IADN1A (2)
	WRITE  (I02,80004) IVTNUM, IVCOMP, IVCORR
6771	CONTINUE
	IVTNUM = 677
C
C     ****  TEST 677  ****
C
C        TEST 677 TESTS THE RETURN VALUE OF ARRAY-NAME ARGUMENT IADN1A.
C     IADN1A (3) WAS NOT MODIFFED    BY FUNCTION SUBPROGRAM AND SHOULD
C     HAVE A VALUE OF 8
C
	IF (ICZERO) 36770,6770,36770
6770	CONTINUE
	GO TO 46770
36770	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46770,6781,46770
46770	IF (IADN1A (3) - 8) 26770,16770,26770
16770	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6781
26770	IVFAIL = IVFAIL + 1
	IVCORR = 8
	IVCOMP = IADN1A (3)
	WRITE (I02,80004) IVTNUM, IVCOMP, IVCORR
6781	CONTINUE
	IVTNUM = 678
C
C     ****  TEST 678  ****
C
C         TEST 678 TESTS THE RETURN VALUE OF ARRAY-ELEMENT-NAME
C     IADN2A (1,3).  IADN2A (1,3) WAS INCREMENTED BY 70 IN THE FUNCTION
C     SUBPROGRAM AND SHOULD CONTAIN A VALUE OF 80.
C
	IF (ICZERO) 36780,6780,36780
6780	CONTINUE
	GO TO 46780
36780	IVDELE = IVDELE + 1
	WRITE  (I02,80003) IVTNUM
	IF (ICZERO) 46780,6791,46780
46780	IF (IADN2A (1,3) - 80) 26780,16780,26780
16780	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6791
26780	IVFAIL = IVFAIL + 1
	IVCORR = 80
	IVCOMP = IADN2A (1,3)
	WRITE (I02,80004) IVTNUM, IVCOMP, IVCORR
6791	CONTINUE
	IVTNUM = 679
C
C     ****  TEST 679  ****
C
C         TEST 679  TESTS THE VALUE OF INTEGER FUNCTION ASSIGNED
C     TO A REAL VARIABLE.
C
	IF (ICZERO) 36790,6790,36790
6790	CONTINUE
	RVON0A        = 0.0
	IVON02        = 2
	IADN1A (2)    = 4
	IADN2A (1,3)  = 10
	RVON0A = FF081 (IVON02, IADN1A, IADN2A, 999)
	GO TO 46790
36790	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46790,6801,46790
46790	IF (RVON0A - 1014.5) 26790,16790,46791
46791	IF (RVON0A - 1015.5) 16790,16790,26790
16790	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6801
26790	IVFAIL = IVFAIL + 1
	RVCORR = 1015.0
	RVCOMP = RVON0A
	WRITE  (I02,80004) IVTNUM, RVCOMP, RVCORR
6801	CONTINUE
	IVTNUM = 680
C
C     EXTERNAL FUNCTION REFERENCE - FUNCTION SUBPROGRAM FF082 DEFINED AS
C                                   REAL
C
C         TESTS 680 THRU 685  TESTS THE FUNCTION AND ARGUMENT VALUES
C     FROM THE FUNCTION REFERENCE TO SUBPROGRAM FF082. THE FUNCTION
C     SUBPROGRAM IS DEFINED AS REAL.
C
C     ****  TEST 680  ***
C
C         TEST  680  TESTS THE VALUE OF THE FUNCTION FF082. VALUE OF
C     FUNCTION SHOULD BE 339.0.
C
	IF  (ICZERO) 36800,6800,36800
6800	CONTINUE
	RVON01        =  2.0
	RADN3A (2,5,2) = 100.0
	RADN1A (5)   = 210.5
	RVON0A       = 0.0
	RVON0A = FF082 (RVON01, RADN3A, RADN1A, 26.5)
	GO TO 46800
36800	IVDELE = IVDELE + 1
	WRITE (I02, 80003) IVTNUM
	IF (ICZERO) 46800,6811,46800
46800	IF (RVON0A - 338.5) 26800,16800,46801
46801	IF (RVON0A - 339.5) 16800,16800,26800
16800	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6811
26800	IVFAIL = IVFAIL + 1
	RVCORR = 339.0
	RVCOMP = RVON0A
	WRITE (I02,80004) IVTNUM, RVCOMP, RVCORR
6811	CONTINUE
	IVTNUM = 681
C
C     **** TEST 681  ****
C
C         TEST 681 TESTS THE VALUE OF THE VARIABLE-NAME ARGUMENT RVON01
C     FOLLOWING THE FUNCTION REFERENCE.  VALUE OF RVON01 SHOULD BE 8.4.
C
	IF (ICZERO) 36810,6810,36810
6810	CONTINUE
	GO TO 46810
36810	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46810,6821,46810
46810	IF (RVON01 - 8.395) 26810,16810,46811
46811	IF (RVON01 - 8.405) 16810,16810,26810
16810	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6821
26810	IVFAIL = IVFAIL + 1
	RVCORR = 8.4
	RVCOMP = RVON01
	WRITE (I02,80004) IVTNUM, RVCOMP, RVCORR
6821	CONTINUE
	IVTNUM = 682
C
C     ****  TEST 682  ****
C
C         TEST 682 TESTS THE VALUE OF THE ARRAY-NAME ARGUMENT RADN3A
C     FOLLOWING THE FUNCTION REFERENCE. RADN3A (2,5,2) WAS INITIALIZED
C     IN MAIN PROGRAM AND INCREMENTED IN SUBPROGRAM. VALUE OF RADN3A
C     (2,5,2) SHOULD BE 112.2.
C
	IF (ICZERO) 36820,6820,36820
6820	CONTINUE
	GO TO 46820
36820	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46820,6831,46820
46820	IF (RADN3A (2,5,2) - 111.7) 26820,16820,46821
46821	IF (RADN3A (2,5,2) - 112.7) 16820,16820,26820
16820	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6831
26820	IVFAIL = IVFAIL + 1
	RVCORR = 112.2
	RVCOMP = RADN3A (2,5,2)
	WRITE (I02,80004) IVTNUM, RVCOMP, RVCORR
6831	CONTINUE
	IVTNUM = 683
C
C     ****  TEST 683  ****
C
C         TEST 683 TESTS  THE VALUE OF THE ARRAY-NAME ARGUMENT RADN3A
C     FOLLOWING THE FUNCTION REFERENCE.  RADN3A (1,2,1) WAS INITIALIZED
C     IN THE SUBPROGRAM. THE VALUE OF RADN3A (1,2,1) SHOULD BE 612.2.
C
	IF (ICZERO) 36830,6830,36830
6830	CONTINUE
	GO TO 46830
36830	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46830,6841,46830
46830	IF (RADN3A (1,2,1) - 611.7) 26830,16830,46831
46831	IF (RADN3A (1,2,1) - 612.7) 16830,16830,26830
16830	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6841
26830	IVFAIL = IVFAIL + 1
	RVCORR = 612.2
	RVCOMP = RADN3A (1,2,1)
	WRITE (I02,80004) IVTNUM, RVCOMP, RVCORR
6841	CONTINUE
	IVTNUM = 684
C
C     ****  TEST 684  ****
C
C         TEST 684 TESTS THE VALUE OF THE ARRAY-ELEMENT-NAME ARGUMENT
C     RADN1A FOLLOWING THE FUNCTION REFERENCE. RADN1A (5) WAS
C     INITIALIZED IN THE MAIN PROGRAM AND INCREMENTED BY 18.8 IN THE
C     FUNCTION SUBPROGRAM.  THE VALUE OF RADN1A SHOULD BE 229.3.
C
	IF (ICZERO) 36840,6840,36840
6840	CONTINUE
	GO TO 46840
36840	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46840,6851,46840
46840	IF (RADN1A (5) - 228.8) 26840,16840,46841
46841	IF (RADN1A (5) - 229.8) 16840,16840,26840
16840	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6851
26840	IVFAIL = IVFAIL + 1
	RVCORR = 229.3
	RVCOMP = RADN1A (5)
	WRITE (I02,80004) IVTNUM, RVCOMP, RVCORR
6851	CONTINUE
	IVTNUM = 685
C
C     **** TEST 685 ****
C
C         TEST 685  TESTS THE RESULTANT VALUE WHERE THE FUNCTION
C     SUBPROGRAM IS DEFINED AS REAL AND THE VARIABLE TO WHICH THE
C     FUNCTION VALUE IS ASSIGNED IN THE MAIN PROGRAM IS DEFINED AS
C     INTEGER.
C
	IF (ICZERO) 36850,6850,36850
6850	CONTINUE
	RVON01   = 4.0
	RADN3A (2,5,2) = 200.0
	RADN1A (5) = 2.85
	IVON0A = 0.0
	IVON0A = FF082 (RVON01, RADN3A, RADN1A, 102.68)
	GO TO 46850
36850	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46850,6861,46850
46850	IF (IVON0A - 309)    26850,16850,26850
16850	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6861
26850	IVFAIL = IVFAIL + 1
	IVCORR = 309
	IVCOMP = IVON0A
	WRITE (I02,80004) IVTNUM, RVCOMP, IVCORR
6861	CONTINUE
	IVTNUM = 686
C
C         TESTS 686 THRU 690 TESTS THE FUNCTION AND ARGUMENT VALUES
C     FROM THE EXTERNAL FUNCTION REFERENCE TO SUBPROGRAM FF083. THE
C     FUNCTION SUBPROGRAM IS AN IMPLICIT DEFINITION OF REAL.
C
C     *****  TEST 686  *****
C
C         TEST 686 TESTS THE VALUE OF FUNCTION FF082. THE VALUE OF THE
C     FUNCTION SHOULD BE 921.8.
C
	IF (ICZERO) 36860,6860,36860
6860	CONTINUE
C
C
	IVON01 =  826
	IADN2A (1,1) = 77
	IADN3A (2,3,4) =  10
	RVON02 = 4.4
	RVON03 = 0.0
C
	RVON03 = FF083 (IVON01, IADN2A, IADN3A, RVON02 * 2.0)
	GO TO 46860
36860	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46860,6871,46860
46860	IF (RVON03 - 921.3) 26860,16860,46861
46861	IF (RVON03 - 922.3) 16860,16860,26860
16860	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6871
26860	IVFAIL = IVFAIL + 1
	RVCORR = 921.8
	RVCOMP = RVON03
	WRITE (I02,80004) IVTNUM, RVCOMP, IVCORR
6871	CONTINUE
	IVTNUM = 687
C
C     ****  TEST  687  *****
C
C         TEST 687 TESTS THE VALUE OF THE VARIABLE-NAME ARGUMENT IVON01
C     FOLLOWING THE FUNCTION REFERENCE. THE VALUE OF IVON01 SHOULD BE
C     836.
C
	IF (ICZERO) 36870,6870,36870
6870	CONTINUE
	GO TO 46870
36870	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46870,6881,46870
46870	IF (IVON01 - 836) 26870,16870,26870
16870	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6881
26870	IVFAIL = IVFAIL + 1
	IVCORR = 836
	IVCOMP = IVON01
	WRITE (I02,80004) IVTNUM, IVCOMP, IVCORR
6881	CONTINUE
	IVTNUM = 688
C
C     ****  TEST 688  *****
C
C         TEST 688 TESTS THE VALUE OF THE ARRAY-NAME ARGUMENT IADN2A
C     FOLLOWING THE FUNCTION REFERENCE. THE ACTUAL ARGUMENT WAS
C     INITIALIZED IN THE MAIN PROGRAM AND IS INCREMENTED IN THE
C     SUBPROGRAM. THE VALUE OF IADN2A (1,1) SHOULD BE 97.
C
	IF (ICZERO) 36880,6880,36880
6880	CONTINUE
	GO TO 46880
36880	IVDELE = IVDELE + 1
	WRITE  (I02,80003) IVTNUM
	IF (ICZERO) 46880,6880,46880
46880	IF (IADN2A (1,1) - 97) 26880,16880,26880
16880	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6891
26880	IVFAIL = IVFAIL + 1
	IVCORR = 97
	IVCOMP = IADN2A (1,1)
	WRITE (I02,80004) IVTNUM, IVCOMP, IVCORR
6891	CONTINUE
	IVTNUM = 689
C
C     **** TEST 689 ****
C
C         TEST 689 TESTS THE VALUE OF THE ARRAY-ELEMENT-NAME ARGUMENT
C     IADN3A FOLLOWING THE FUNCTION REFERENCE.  IADN3A (2,3,4)
C     WAS INTIALIZED IN THE MAIN PROGRAM AND INCREMENTED BY 40 IN THE
C     FUNCTION SUBPROGRAM. THE VALUE OF IADN3A SHOULD BE 50.
C
	IF (ICZERO) 36890,6890,36890
6890	CONTINUE
	GO TO 46890
36890	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46890,6901,46890
46890	IF (IADN3A (2,3,4) - 50) 26890,16890,26890
16890	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6901
26890	IVFAIL = IVFAIL + 1
	IVCORR = 50
	IVCOMP = IADN3A (2,3,4)
	WRITE (I02,80004) IVTNUM,IVCOMP,IVCORR
6901	CONTINUE
	IVTNUM = 690
C
C     **** TEST 690  ****
C
C         TEST  690 TESTS THE RESULTANT VALUE WHERE THE FUNCTION
C     SUBPROGRAM IS IMPLICITY DEFINED AS REAL AND THE VARIABLE
C     TO WHICH THE FUNCTION VALUE IS ASSIGNED IN THE MAIN PROGRAM
C     IS DEFINED AS INTEGER. THE VALUE OF IVON03 SHOULD BE 329.
C
	IF (ICZERO) 36900,6900,36900
6900	CONTINUE
	IVON01 =   226
	IADN2A (1,1) = 66
	IADN3A (2,3,4) = 20
	RVON02 = 8.8
	IVON03 = 0
C
	IVON03 = FF083 (IVON01,IADN2A,IADN3A,RVON02 * 2.0)
C
	GO TO 46900
36900	IVDELE = IVDELE + 1
	WRITE (I02,80003) IVTNUM
	IF (ICZERO) 46900,6911,46900
46900	IF (IVON03 - 329) 26900,16900,26900
16900	IVPASS = IVPASS + 1
	WRITE (I02,80001) IVTNUM
	GO TO 6911
26900	IVFAIL = IVFAIL + 1
	IVCORR = 329
	IVCOMP = IVON03
	WRITE (I02,80004) IVTNUM, IVCOMP, IVCORR
6911	CONTINUE
C
C     WRITE PAGE FOOTINGS AND RUN SUMMARIES
99999	CONTINUE
	WRITE (I02,90002)
	WRITE (I02,90006)
	WRITE (I02,90002)
	WRITE (I02,90002)
	WRITE (I02,90007)
	WRITE (I02,90002)
	WRITE (I02,90008)  IVFAIL
	WRITE (I02,90009) IVPASS
	WRITE (I02,90010) IVDELE
C
C
C     TERMINATE ROUTINE EXECUTION
	STOP
C
C     FORMAT STATEMENTS FOR PAGE HEADERS
90000	FORMAT (1H1)
90002	FORMAT (1H )
90001	FORMAT (1H ,10X,33HU. S. NAVY FORTRAN AUDIT ROUTINES)
90003	FORMAT (1H ,10X,42HFCVS77    TAPE DATE 76/08/13   VERSION 1.0)
90004	FORMAT (1H ,10X,38HFOR OFFICIAL USE ONLY - COPYRIGHT 1976)
90005	FORMAT (1H ,5X,4HTEST,5X,9HPASS/FAIL, 5X,8HCOMPUTED,8X,7HCORRECT)
90006	FORMAT (1H ,5X,46H----------------------------------------------)
C
C     FORMAT STATEMENTS FOR RUN SUMMARIES
90008	FORMAT (1H ,15X,I5,19H ERRORS ENCOUNTERED)
90009	FORMAT (1H ,15X,I5,13H TESTS PASSED)
90010	FORMAT (1H ,15X,I5,14H TESTS DELETED)
C
C     FORMAT STATEMENTS FOR TEST RESULTS
80001	FORMAT (1H ,4X,I5,7X,4HPASS)
80002	FORMAT (1H ,4X,I5,7X,4HFAIL)
80003	FORMAT (1H ,4X,I5,7X,7HDELETED)
80004	FORMAT (1H ,4X,I5,7X,4HFAIL,10X,I6,9X,I6)
80005	FORMAT (1H ,4X,I5,7X,4HFAIL,4X,E12.5,3X,E12.5)
C
90007	FORMAT (1H ,20X,20HEND OF PROGRAM FM080)
	END
C  *************  BEGIN  FF081 DECK   ******************
	INTEGER FUNCTION FF081 (IDON01, IDDN10, IDDN20, IDON02)
C
C     COMMENT SECTION
C
C     FF081
C
C         THIS FUNCTION SUBPROGRAM IS CALLED BY THE MAIN PROGRAM FM080.
C     THE FUNCTION DUMMY ARGUMENTS IDON01, IDDN10 AND IDDN20 ARE
C     INCREMENTED BY 2, 40 AND 70 RESPECTIVELY BEFORE CONTROL IS
C     RETURNED TO THE CALLING PROGRAM.  VALUE OF THE FUNCTION WILL BE
C     THE SUM OF THE ACTUAL ARGUMENTS AS PASSED FROM CALLING PROGRAM.
C
C     REFERENCE   X3.9-1966, AMERICAN STANDARD FORTRAN
C                    SECTION 8.3.1, DEFINING FUNCTION SUBPROGRAMS
C
C     TEST SECTION
C
C         FUNCTION SUBPROGRAM
C
	DIMENSION  IDDN10 (5),   IDDN20 (4,4)
	IVON01 = IDON01
	IVON02 = IDDN10(2)
	IVON03 = IDDN20(1,3)
	IVON04 = IDON02
C
	FF081  = IVON01 + IVON02 + IVON03 + IVON04
	IDON01 = IVON01 + 2
	IDDN10 (2) = IVON02   + 40
	IDDN20 (1,3) = IVON03 + 70
	IDDN10 (4) = IVON02 + 40
	RETURN
	END
C  ***************   END  FF081  DECK  *******************
C  *************  BEGIN  FF082 DECK   **********
	REAL FUNCTION FF082 (RDON01, RDDN3A, RDDN1A, RDON02)
	DIMENSION  RDDN3A (3,6,3), RDDN1A (10)
C
C     COMMENT SECTION
C
C     FF082
C
C         THIS FUNCTION SUBPROGRAM IS CALLED BY THE MAIN PROGRAM FM080.
C     THE FUNCTION DUMMY ARGUMENTS RDON01, RDDN3A, AND RDDN1A ARE
C     INCREMENTED BY 6.4, 12.2 AND 18.8 RESPECTIVELY BEFORE CONTROL IS
C     RETURNED TO THE MAIN PROGRAM.  VALUE OF THE FUNCTION WILL BE
C     THE SUM OF THE ACTUAL ARGUMENTS AS PASSED TO THE SUBPROGRAM.
C
C     REFERENCE   X3.9-1966, AMERICAN STANDARD FORTRAN
C                    SECTION 8.3.1, DEFINING FUNCTION SUBPROGRAMS
C
C     TEST SECTION
C
C          FUNCTION SUBPROGRAM
C
	RVON01 = RDON01
	RVON02 = RDDN3A (2,5,2)
	RVON03 = RDDN1A (5)
	RVON04 = RDON02
C
	FF082 = RVON01 + RVON02 + RVON03  + RVON04
C
	RDON01 =     RVON01 + 6.4
	RDDN3A (2,5,2) = RVON02 + 12.2
	RDDN1A (5)     = RVON03 + 18.8
	RDDN3A (1,2,1) =  600.0 + 12.2
	RETURN
	END
C **************  END OF FF082 DECK   **************
C  *************  BEGIN FF083 DECK  ****************
	FUNCTION  FF083 (IDON01,IDDN2A,IDDN3A,RDON02)
	DIMENSION  IDDN2A (2,2), IDDN3A(3,4,5)
C
C     COMMENT SECTION
C
C     FF083
C
C         THIS FUNCTION SUBPROGRAM IS CALLED BY THE MAIN PROGRAM FM080.
C     THE TYPE DECLARATION IS IMPLICIT REAL.
C     THE FUNCTION DUMMY ARGUMENTS ARE BOTH INTEGER AND REAL. DUMMY
C     ARGUMENTS IDON01, IDDN2A AND IDDN3A ARE INCREMENTED BY 10, 20 AND
C     40 RESPECTIVELY BEFORE CONTROL IS RETURNED TO THE MAIN PROGRAM.
C     THE VALUE OF THE FUNCTION RETURNED TO THE REFERENCING PROGRAM
C     WILL BE THE SUM OF THE ACTUAL ARGUMENTS AS PASSED TO THE
C     SUBPROGRAM FF083.
C         DUMMY ARGUMENT IDDN2A CORRESPONDS TO AN ARRAY-NAME IN THE
C     ACTUAL ARGUMENT OF THE MAIN PROGRAM.  DUMMY ARGUMENT IDDN3A
C     CORRESPONDS TO AN ARRAY-ELEMENT-NAME IN THE ACTUAL ARGUMENT OF THE
C     MAIN PROGRAM.  DUMMY ARGUMENT IDON02  CORRESPONDS TO AN EXPRESSION
C     CONTAINING VARIABLES,ARITHMETIC OPERATORS AND CONSTANTS IN THE
C     ACTUAL ARGUMENT OF THE MAIN PROGRAM.
C
C     REFERENCE   X3.9-1966, AMERICAN STANDARD FORTRAN
C                    SECTION 8.3.1, DEFINING FUNCTION SUBROUTINES
C                    SECTION 5.3, TYPE RULES FOR DATA AND PROCEDURE
C                                  IDENTIFIERS.
C
C     TEST SECTION
C
C          FUNCTION SUBPROGRAM
C
	IVON01 = IDON01
	IVON02 = IDDN2A (1,1)
	IVON03 = IDDN3A (2,3,4)
	RVON04 = RDON02
C
	RVON05 = IVON01 + IVON02 + IVON03
	FF083 = RVON05 + RVON04
C
	IDON01 = IVON01 + 10
	IDDN2A (1,1) = IVON02 + 20
	IDDN3A (2,3,4) = IVON03 + 40
C
	RETURN
	END
C *************  END OF  FF083 DECK  **************
C$END
 