/*
 * Tektronix 8560 Unix System Kernel
 *
 *	Based on Western Electric Version 7 Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */

#ifdef SCCSID
/*static char *sccsid = "@(#)iopcmd.h	4.2 dated 11/16/82	Tektronix 8560 Unix";*/
#endif
/*
 * Command descriptions:
 *	A command may pointed to by:
 *		1) device register (non-queued format)
 *		2) command queue pointer
 *	Commands are in PDP-11 memory.
 *
 */




/*
 * Format of the first word of a command:
 */

struct cmdfw {
	char cmd_tag;			/* = IOP or PDP */
	unsigned cmd_port : 2;		/* port number */
	unsigned cmd_intr : 1;		/* interrupt flag */
	unsigned cmd_code : 5;		/* command code */
};


/*
 * Format of Queue-able command:
 */

struct q_cmd {
	unsigned frstwrd;		/* the first word */
	unsigned cmd_txkey;		/* transaction key */
	long cmd_addr;			/* address in PDP-11 */
	unsigned cmd_len;		/* data length */
};


/*
 * Non-queued format of queue-able command:
 * Need dummy integers since can't cast in initialization.
 */

struct nq_cmd {
	unsigned nq_frstwrd;		/* first part identical */
	unsigned nq_cmd_txkey;		/* transaction key */
	int nq_dm1;
	unsigned nq_cmd_addr;		/* address in PDP-11 */
	unsigned nq_cmd_len;		/* data length	*/
	int nq_dm2;
	unsigned nq_cmd_resaddr;	/* response address */
};


/*
 * Set Control Queues command format:
 * Need dummy integers since can't cast in initialization.
 */

struct scq_cmd {
	unsigned frstwrd;		/* the first word */
	unsigned cmd_txkey;		/* transaction key */
	int dummy1;
	unsigned cmd_cmdqa;		/* address of command queue */
	unsigned cmd_cmdlen;		/* number of queue elements */
	int dummy2;
	unsigned cmd_resqa;		/* address of response queue */
	unsigned cmd_reslen;		/* number of queue elements */
	int dummy3;
	unsigned cmd_scqres;		/* response to this command */
};


/*
 * Value of tag field
 */

# define CMD_PDP	0	/* Belongs to PDP-11 */
# define CMD_IOP	1	/* (non-zero) belongs to IOP */
# define RES_IOP	0	/* Belongs to IOP	*/
# define RES_PDP	1	/* Belongs to PDP-11	*/
# define RES_BSY	2	/* Busy by the PDP-11	*/


/*
 * Response description:
 *	Queued commands return responses in the response queue.
 *	Responses to non-queued commands are returned at the
 *	address given in the command.
 */


/*
 * Response format:
 */

struct response {
	char res_tag;		/* = IOP or PDP */
	char res_err;		/* error code */
	unsigned res_txkey;	/* transaction key */
	unsigned res_value;	/* returned value */
};



/*
 * The HSI parameter block.
 *    The following values can be read/written by the SET/GET
 *    Parameter command to the IOP.
 */

#define N_HSI_ERR 19
#define N_NAK_ERR 19

struct HsiParam {
	char hsi_Tone;			/* short timeout value */
	char hsi_Ttwo;			/* medium timeout value */
	char hsi_Tthree;		/* long timeout value */
	char hsi_MxRetries;		/* Maximum allowable retries */
	char hsi_LErr;			/* Last hsi error	*/
	char hsi_Err[N_HSI_ERR];	/* Count of previous errors */
	char hsi_LNak;			/* Last nak error	*/
	char hsi_Nak[N_NAK_ERR];	/* Count of previous nak errors */
};

# define SZ_INTBL	129	/* size of input control table */


/*
 * Terminal Setup table definitions
 */

struct trm_setup {
	char ic_intbl[SZ_INTBL];	/* control table for input */
	char ic_parity;			/* parity control */
	char ic_sbits;			/* stop bits control */
	char ic_flags;			/* iflow, autogo, cts, xtabs */
	char ic_speed;			/* terminal speed */
	char ic_bs[8];			/* backspace string */
	char ic_kill[8];		/* kill string */
	char ic_nl[8];			/* newline string on output */
	char ic_escecho;		/* echo code for escaped chars */
	char ic_framesub;		/* char to sub. on framming error */
};

