/***********************************************************************
 *
 *	File name:  	mainSym.h
 *
 *	Description:	This file contains the global symbols.
 *			
 *	Functions:	
 *
 *      Version		Date		ID		Comment
 *	----------------------------------------------------------------
 *	0.1		110888		TEKELEC/IA	first created
 *	1.0		112188		TEKELEC/IA	first release
 *      1.1		113088      	TEKELEC/IA  	include MTOSUX added
 *  	1.2     	113088      	TEKELEC/IA  	extern char *malloc()
 *  	1.3     	113088      	TEKELEC/IA  	layer 3 REL to RELEA
 *  	1.4     	120688      	TEKELEC/IA  	extern rxlen added
 *  	1.5     	120788      	TEKELEC/IA  	include "paval.h"
 *
 ***********************************************************************/

#include <MTOSUX.h> 
#include "paval.h"



/*
 *    NT POWER SETTING.
 *
 */

#define    NT_POWER         3

/*
 *
 *    TERMINAL TYPES
 *
 */

#define AUTOMATIC           0
#define NON_AUTOMATIC       2 


/*
 *
 *    ENVIRONMENT SPECIFIC TEI VALUES
 *
 */

#define    PHONE_A          64
#define    PHONE_B          65
#define    TA_A             1
#define    TA_B             1



/*
 *
 *    TIMERS AND CONSTANTS SPECIFIC TO LAPD SETUP
 *
 */

#define    T200            10
#define    T203            20
#define    N201            260
#define    N200            10
#define    WINDOW_SIZE      3
#define    MODULUS          1
#define    CONFIG          0x02

/*
 *
 *    PARAMETERS PERTAINING TO THE INITIATION OF
 *    THE COMMUNICATION PROCESSOR.
 *
 */

#define    INTERFACE        2
#define    STATION          0
#define    ENCODE           0
#define    BITRATE          (unsigned long)16000


/*
 *
 *    SAPI VALUES
 *
 */

#define    CONTROL          0
#define    PACKET           16
#define    MNGMT            63

/*
 *
 *    TEI VALUES
 *
 */

#define    BC              127






/*
 *
 *	GENERAL USEFUL SYMBOLS
 *
 *
 */

extern  int     rxlen;

extern	long	_stdvt,getch();

extern char *malloc();

#define		byte	            unsigned char

#define         STOP            0
#define         CONT            1

#define		TRUE	       -1
#define		FALSE		0
#define		YES		1
#define		NO		0

#define		MOD(x,y)	( x % y )

#define         AND             &&
#define		OR		||

#define         NONE               -1


/*
 *
 * TYPEDEF DEFINITIONS
 *
 */

typedef struct
    {
        int type;
        int tei;
        int sapi;
    } LINK;

	
extern LINK linksA[];
extern LINK linksB[];





/*
 *
 *
 *    KEYBOARD CODE DEFINITIONS
 *
 *
 */ 

#define		F1	0x81
#define		F2	0x82
#define		F3	0x83
#define		F4	0x84
#define		F5	0x85
#define		F6	0x86
#define		F7	0x87
#define		F8	0x88
#define		F9	0x89
#define		F10	0x8a
#define		key0	0x30
#define		key1	0x31
#define		key2	0x32
#define		key3	0x33
#define		key4	0x34
#define		key5	0x35
#define		key6	0x36
#define		key7	0x37
#define		key8	0x38
#define		key9	0x39
#define		UP	0x0b
#define		DOWN	0x0a
#define		RIGHT	0x0c
#define		LEFT	0x08
#define		RTN	0x0d
#define		DELETE	0x7f




/*
 *	 SCREEN COMMAND MACRO
 */

#define		setScr(x)	printf(x);fflush(stdout);




/*
 *	 COLOR COMMANDS
 */

#define		BLACK		"%c[30m",0x1b
#define		RED		"%c[31m",0x1b
#define		GREEN		"%c[32m",0x1b
#define		YELLOW		"%c[33m",0x1b
#define		BLUE		"%c[34m",0x1b
#define		MAGENTA		"%c[35m",0x1b
#define		CYAN		"%c[36m",0x1b
#define		WHITE		"%c[37m",0x1b
#define		BBLACK		"%c[40m",0x1b
#define		BRED		"%c[41m",0x1b
#define		BGREEN		"%c[42m",0x1b
#define		BYELLOW		"%c[43m",0x1b
#define		BBLUE		"%c[44m",0x1b
#define		BMAGENTA	"%c[45m",0x1b
#define		BCYAN		"%c[46m",0x1b
#define		BWHITE		"%c[47m",0x1b




/*
 *
 *	SCREEN ATTRIBUTES
 *
 */

#define		RESET		"%c[0m",0x1b
#define		HIGHLIGHT	"%c[1m",0x1b
#define		UNDERLINE	"%c[4m",0x1b
#define		BLINK		"%c[5m",0x1b
#define		REVERSE		"%c[7m",0x1b


/*
 *
 *    SCREEN COMMANDS
 *
 */

#define		POS_CUR 	"%c[%d;%df",0x1b
#define		DEL_EOL		"%c[0K",0x1b
#define		DEL_EOS		"%c[0J",0x1b
#define		CLEAR		"%c[2J",0x1b



/*	
 *
 *    PORT DEFINITIONS
 *
 */


#define		PORTA		0
#define		PORTB		1


/*
 *
 *    CHAMELEON FUNCTION MODE
 *
 */

#define		MONITOR		1
#define		SIMNT		2
#define		SIMTE		3


/*
 *
 *    LINK LAYER STATE.
 *
 *
 */




#define FR_DISC		0
#define LINK_REQ	1
#define REJECT		2
#define LINK_DISC	3
#define	INFO_TRANSF	4
#define LOCAL_BUSY	5
#define REMOTE_BUSY	6
#define L_R_BUSY	7
#define R_NOT_RESP	8



/*
 *
 *    CHANNEL ATTRIBUTE
 *
 */

#define		SYSTEM		1
#define		MILLIWAT	2
#define		CODEC		3
#define		EXTERNAL	4
#define		IDLE		5



/*
 *
 *    DEFINITION FOR UI FRAME 
 *
 */

#define 	UI		0x03
#define		MEI		0x0f
#define		IDREQ		0x01
#define		IDASS		0x02
#define		IDDENY		0x03
#define		IDCHK		0x04
#define		IDCHKACK	0x05
#define		IDREL		0x06
#define		IDCONF		0x07



/*
 *
 *    DEFINITION FOR LAYER 3 MESSAGE TYPE 
 *
 */

#define		PD		0x08

#define		ALERT		0X01
#define		CALLPROC	0X02
#define		CONN		0X07
#define		CONNACK		0X0f
#define		PROG		0X03
#define		SETUP		0X05
#define		SETUPACK	0X0d
#define		RESUME		0X26
#define		RESUMEACK	0X2e
#define		RESREJ		0X22
#define		SUSP		0X25
#define		SUSPACK		0X2d
#define		SUSPREJ		0X21
#define		USERINFO	0X20
#define		DISC		0X45
#define		RELEA		0X4d
#define		RELCOMP		0X5a
#define		REST		0X46
#define		RESTACK		0X4e
#define		CONGCON		0X79
#define		INFO		0X7b
#define		NOTIFY		0X6e
#define		STAT		0X7d
#define		STATENQ		0X75



/*
 *
 *    DEFINITION FOR LAYER 3 TIMER AND OTHERS 
 *
 */


#define		T302		10
#define		T303		10
#define		T305		10
#define		T306		10
#define		T308		10
#define		T310		10
#define		T312		10

