TASK COMMUNICATION C LIBRARY

The Task Communication C Library simplifies the process of 
developing applications with multiple tasks.  The library 
uses a standard structure to communicate named MB_MESS, 
which includes all of the information required to perform 
data transfer between tasks.  The structure is defined as 
follows:

               typedef struct {     int  port ;
                         int  type ;
                         int  info ;
                         int  len ;
                         char *pdata ;
                    }     MB_MESS ;

               port   Origin or the destination of a message: 
                      PORT_A or PORT_B

               type   Type of message sent or received:

                      CT_ERR    error message
                      CT_DATA   data message
                      CT_EXIT   exit message
                      CT_CMD    command message
                      CT_FLUSH  flush the reception buffer

               info   This is a user defined field, 
                      which can be used as follows:

                      -When type = CT_ERR, this field 
                       provides more information to the 
                       destination task about the error 
                       detected.

                      -When type = CT_CMD, this field 
                       provides the type of command sent 
                       to the destination task.

               len     Length of the data when the message 
                       CT_DATA is sent or received.

               pdata   Pointer to the data received or 
                       sent.


The library provides the following functions:

com_chkmb     Checks for received messages.

               #include "com.h"
               int com_chkmb(pmess)
               MB_MESS   *pmess ;

               pmess    pointer to a MB_MESS structure 
                        describing the received message.

               Within this structure, the following items 
               are required for all received messages:
 
               port   For protocol tasks, this is not 
                      needed.
                      For control tasks, it indicates the 
                      port from which the message 
                      originated as PORT_A or PORT_B

               type     Type of message received:

                         CT_ERR
                         CT_CMD
                         CT_DATA
                         CT_FLUSH
                         CT_EXIT

               info    User defined information if type 
                       = CT_ERR or type = CT_CMD

               len     Length of the data if type = 
                       CT_DATA.

               pdata   Pointer to the data received if 
                       type = CT_DATA.

               Returns:    0    Message received
                          -1   No message received


com_crctlmb     Called by the control tasks to create the 
                communication channels for the control 
                task.  Refer to the section on 
                initialization for more information.

                #include "com.h"
                int   com_crctlmb(np)
                int   np ;

                np    Number of channels to the control 
                      task (1 or 2)

               Returns:  0     Successful
                        -1     Insufficient sys. resources


com_crpmb     Called by the protocol tasks to create the 
              communication channels for the protocol 
              tasks.  

              #include "com.h"
              int com_crpmb(port,np)
              int  port ;
              int  np ;

              port    Port where the protocol task is 
                      going to run: PORT_A or PORT_B

               np     Number of channels to the control 
                      task (1 or 2)

               Returns:  0   Successful
                        -1   Insufficient sys resources


com_dlctlmb     Closes communication channels.  It must be 
                called by the control task prior to 
                terminating.

               #include "com.h"
               void com_dlctlmb()

               Returns:      None


com_error      Reports an error to the control task and is 
               called by a protocol task.  

               #include "com.h"
               void com_error(port,status)
               int  port ;
               int  status ;

               port    Port where the protocol task is 
                       going to run:  PORT_A or PORT_B

               status    User field that can be used to 
                         tell more about the error to the 
                         control task.

               Returns:  None


com_exit     Sends an EXIT message to a protocol task.  It 
             is called by the control task.

             #include "com.h"
             void  com_exit(port,lid)
             int  port ;
             long lid ;


             port     Port where the protocol task to 
                      kill is running:  PORT_A or PORT_B

             lid      Loader ID returned by the function 
                      com_startl    

             Returns:  None


com_flush    Flushes the reception channel and then sends 
             a flush message to the protocol task.  This 
             function must be called by the control task. 

             #include "com.h"
             void com_flush(port)
             int  port ;

             port     Port where the protocol task is 
                      running:  PORT_A or PORT_B

             Returns:  None


com_gptr     Gets a pointer to the area where the data is 
             put when sending a data message.

             #include "com.h"
             char  *com_gptr(size)
             int  size ;

             size   Size of memory to allocate for the 
                    data

               Returns:   (char *)0     (NULL pointer) 
                          Not enough pool memory to 
                          allocate the required memory for 
                          the data.

                        > 0L  OK and value of the pointer
                              where the data can be stored 


com_rel     Releases memory allocated for data messages.  

            #include "com.h"
            void  com_rel(pframe)
            char *pframe ;

            pframe     Pointer to the data received 
            (          pdata)

            Returns:  None


com_setrdy     Informs the control task that a protocol 
               task is ready to receive a message.  This 
               function must be called by a protocol task 
               during its initialization.

               #include "com.h"
               void com_setrdy(port)
               int  port ;

               port     Port on which the protocol task is 
                        running:  PORT_A or PORT_B

               Returns:  None


com_snd     Sends a message to a destination task using a 
            communication channel.  This function is 
            called by both the protocol tasks and the 
            control task in order to communicate to 
            each other.

            #include "com.h"
            void com_snd(pmess)
            MB_MESS   *pmess ;

            pmess    Pointer to the MB_MESS structure 
                     containing the description of the 
                     message.

                     Within this structure, the following 
                     items are required for all message 
                     types:

            port     For the control task, this is the 
                     destination task port.  

                     For the protocol tasks, this is 
                     the port of the origin of the 
                     message.

                         PORT_A 
                         PORT_B

            type     Type of message to be sent

            The remaining items of the structure are 
            required depending on the type of message 
            sent.

            For the messages CT_ERR or CT_CMD, the 
            field info needs to be filled.

            For the messages CT_EXIT and CT_FLUSH, no 
            additional fields are needed.

            For the message CT_DATA, the following fields 
            are required:

                    len       Length of the data
                    pdata     Pointer to the data


             Returns:   0    Message sent correctly
                       -1     Queue is full  


com_startl     Loads and starts a protocol task.  This 
               function is called by the control task.

               #include "com.h"
               long  com_startl(name,arg0,arg1,...,0L)
               char *name ;
               char *arg0,*arg1,... ;

               name     pointer to the name of the file
               arg0     pointer to the name of the program
               arg1     pointer to the first parameter
               .
               .
               .
               0L     a long 0 is necessary at the end of 
                      the list of parameters

               Returns:     < 0     Loader error
                            > 0     Loading and startingOK 
                                    and loader ID value.


com_wrdy     This function is called by the control task 
             to cause it to wait for the protocol task 
             to be ready.  It allows you to block the 
             control task so that it will not send 
             messages until the protocol task is ready.

             #include "com.h"
             #include "mtosux.h"
             int com_wrdy(port,delay)
             int  port ;
             long delay ;

             port     Port on which the protocol task is 
                      running:  PORT_A or PORT_B

             delay   This is the maximum delay allowed 
                     by the control task for the task 
                     protocol to be ready.  delay is
                     in the format: time unit + number 
                     of units

                     time units: MS, TMS, HMS SEC, MIN, 
                                 HRS, DAY
                     number of units:      0 - 255

                     Example:  30 + SEC  
 

             Returns:    0   Ready received from the
                             protocol task
                        -1   Timeout

