
CHAMELEON BASIC COMMANDS

@         References the array.
          @(exp)    exp =array subscript

ABS       Returns absolute value of integer or variable 
          ABS(x)

ASC$      EBCDIC to ASCII conversion.
          ASC$($x)

ATIME$    Returns the ASCII value of the realtime stamp.
          ATIME$

AUTO      Automatic line numbering.  
          AUTO    Start at 10, increment by 10.
          AUTO x    Start at x, increment by 10.
          AUTO x,y    Start at x, increment by y. 

BCD$      ASCII to BCD)conversion.  
          BCD$($x)

BLK       Display blinking text.
          BLK       Blinking text
          BLKHLF    Blinking text in double intensity
          BLKREV    Display blinking text in reverse video
          BLKUND    Display blinking underlined text.

CALL      Calls a program file as a subroutine.  
          CALL "filename"

CHAIN     Loads and runs a program file.
          CHAIN"filename"

CHR$      Assigns the binary equivalent of an ASCII value.  
          CHR$(exp)

CLEAR     Clears the trace buffer. 
          CLEAR

CLOSE     Closes an open data file.
          CLOSE

CLS       Clears the screen of text.
          CLS

COUPLER   Configures the Chameleon to transmit and receive
          COUPLER "filename"

DEC$      Converts numeric expression into ASCII string of 
          decimal characters.
          $X = DEC$(exp)

DEFINE    Defines a mnemonic for the mnemonic table.
          Syntax is protocol-specific.

DEL       Deletes a line from the screen. 
          DEL

DELETE    Deletes a mnemonic from the table.
          DELETE "name"

DISPF     Displays the last frame transmitted or received.
          SIMP/L uses RDISPF (rec'd) and TDISPF (transmitted).
          DISPF

EBC$      ASCII to EBCDIC conversion.  
          $A = EBC$($B)

EDIT      Edits a line from the program in memory
          EDIT x    x  = line number
          Editing commands are:
          left arrow    Move cursor 1 space left
          right arrow   Display next character  
          CTRL P        Display line to the right of cursor
          CTRL X        Erases current line
          CTRL D        Deletes next un-displayed character
          CTRL I        Inserts a space
          RETURN        Saves the line to the left of cursor
          CTRL Z        Exits edit mode w/o saving changes.  

EOF       Read-only variable indicates end of data file.  
          Returns:   0 = Not EOF
                     1 = EOF reached

ERAEOL    Erases text to the end of the line.
          ERAEOL

ERAEOS    Erases text to the end of the screen.
          ERAEOS

ERASE     Deletes lines from the program in memory. 
          ERASE x,y    x = first line number 
                  y = last line number 

EXIT      Returns control to a calling program.
          EXIT

FDEFINE   Defines the function key assignments.  
          FDEFINE KEYx=~statement^~
          x  =function key (1 - 10)
          ~ marks beginning and end
          ^=carriage return between statements

FILES     Lists the files on a specified disk drive.  
          FILES A    Lists files on hard disk
          FILES B    Lists files on floppy disk

FLIST     Lists the ten function key assignments. 
          FLIST

FLOAD     Loads a function key definition file into memory. 
          FLOAD "filename"

FLUSH     Clears the acquisition buffer.
          FLUSH

FOR       Controls looping in programs.  Used with NEXT
          FOR x=exp1 TO exp2 [STEP exp3]
          ...
          NEXT x

          x is a numeric variable
          exp1 is the beginning value of x
          exp2 is the maximum value of x 
          exp3 is the step increment

FREE      Returns the number of free mnemonic table entries. 
          PRINT FREE
          IF FREE...

FSAVE     Saves function key assignments in a file.  
          FSAVE "filename"

GOSUB     Sends program to a specific line number to execute 
          a subroutine.  See also RETURN.
          GOSUB exp    exp = line number

GOTO      Sends program control to a specific line number.
          GOTO exp    exp = line number

HEX$      Creates 4-char. ASCII string (hex equivalent of exp)
          $A = HEX$(exp)

HEX       Assigns a string variable value in hexadecimal. 
          $A = HEX>exp

HLF       Displays in double intensity (highlight)
          HLF
          HLFUND    Double intensity and underlined.

IF        Allow program flow to be changed based on a decision
          IF x op y command
          x and y are numeric variables
          op is the operation to execute if statement is true

INKEY$    Assigns next character typed on the keyboard to a 
          string variable.
          $A=INKEY$

INPUT     Stores keyboard input in a variable. 
          INPUT "prompt",x
          prompt is optional text to display
          x is the variable that stores the keyboard input
          , displays the variable name (optional)

$INPUT    Assign a string variable from the keyboard. 
          $INPUT $A

INS       Inserts a blank line on the screen.
          INS

INSTR     Returns offset of a substring within the main string
          x = INSTR(str1,str2)
          str1=main string
          str2= substring.

KILL      Deletes a file from disk.  
          KILL"filename",x
          x is the file type:
              P    Program 
              T    Trace
              M    Mnemonic table
              D    Data
              S    Setup (parameter)
              F    Function key definition
              A    All types

LEFT$     Assigns a specified number of characters from 
          the left end of one string to another string. 
          $A = LEFT$($x,exp)
          exp = number of characters from the left end of $x

LEN       Assign length of string variable to numeric variable
          A= LEN($x)
          $x is a string variable
          A is the numeric variable

LET       Assigns values to numeric or string variables.
          LET x = exp       Numeric variable 
          LET $A = "xxx"    String variable 

LFILES    Outputs file directory to printer.
          LFILES A    Prints hard disk directory
          LFILES B    Prints floppy directory 

LFLIST    Outputs function key assignments to a printer 
          or remote device.
          LFLIST

LIST      Displays program in memory.
          LIST        Lists entire program.
          LIST x      Lists program from line x to end.
          LIST x,y    Lists program from line x to line y.
          LIST ,y     Lists program from beginning to line y.

LLIST     Outputs program in memory to a printer.  
          LLIST       Prints entire program.
          LLIST x     Prints program from line x to end.
          LLIST x,y   Prints program from line x to line y.
          LLIST ,y    Prints program from beginning to line y.

LMLIST    Outputs the mnemonic table in memory to a printer.
          LMLIST

LOAD      Loads a program file into memory.
          LOAD "filename"

LTPRINT   Outputs contents of trace buffer to a printer. 
          LTPRINT

MENU      Exits the simulator and returns to the main menu.  
          MENU

MERGE     Combines a program file with the program in memory.
          MERGE"filename"

MID$      Assigns chars from middle of string to string var
          $A = MID$($x,exp1,exp2)
          exp1 is the position of the first character
          exp2 is the number of characters

MLIST     Displays the mnemonic table in memory. 
          MLIST

MLOAD     Loads a mnemonic table into memory.
          MLOAD"filename"

MSAVE     Saves the mnemonic table in memory to disk.
          MSAVE"filename"

NEW       Deletes the program in memory.
          NEW

NEXT      Increments the counter in a FOR loop.
          NEXT x

NRM       Cancels special display effects (blinking, etc)
          NRM

OPEN      Opens a data file. 
          OPEN "I","filename"    Opens for input 
          OPEN "O","filename"    Opens new file for output 
          OPEN "A","filename"    Opens file for appending

PRINT     Displays a string, expression, or variable. 
          PRINT"string"    Prints the string.
          PRINT $A         Prints string variable.
          PRINT x          Prints numeric variable.
          PRINT %x         Prints x in hex. 
          Options:
              , acts as a field separator
              \)suppresses a line feed
              ; suppresses the carriage return

READ      Reads the next record from an input file.  
          READ $A  

RESEQ     Re-numbers the line numbers of program in memory 
          RESEQ     Begin with line 10, increment by 10
          RESEQ x   Begin with line x, increment by 10
          RESEQ x y Begin with line x, increment by y

RETURN    Returns from a subroutine called by a GOSUB.
          RETURN

REV       Displays text in reverse video.
          REV
          REVHLF    Reverse video in double intensity
          REVUND    Reverse video and underlined

RIGHT$    Assigns a specified number of characters from 
          the right end of one string to another string.
          $A = RIGHT$($x,exp)
          $x is the string
          exp defines the number of characters from the right

RND       Returns a random number. 
          RND(x)

RUN       Executes the program in memory.
          RUN

SAVE      Saves the program in memory to disk.
          SAVE "filename"

SET       Sets physical interface signal to 1 or 0.
          SET xxx = y    y is a 1 or 0 
          xxx is:  CTS, DSR, DCD, RI, SDCD, DTR, or RTS

SETUP     Accesses the parameter set-up menu.  
          SETUP

SIZE      Returns size of free program area in bytes.
          PRINT SIZE
          IF SIZE...

STOP      Terminates program execution.
          STOP

TEST      Tests an interface signal for 1 or 0.
          TEST xxx = y command
          y is  1 or 0
          xxx is:  CTS, DSR, DCD, RI, SDCD, DTR, or RTS
          command is executed when TEST condition is true. 

TFREE     Returns length of the unused trace buffer in bytes.
          PRINT TFREE
          IF TFREE...

TIME      Returns specified byte of system time in BCD digits
          TIME(x)
          x is in the range 0 to 4, as follows:
              0 - hours
              1 - minutes
              2 - seconds
              3 - 1/100s seconds (.01)
              4 - 10s of milliseconds (.0001)

TIME$     Assigns the current time to a string variable.
          TIME$

TLOAD     Loads a trace file into memory.
          TLOAD"filename"

TPRINT    Displays the contents of the trace buffer.
          TPRINT

TROFF     Turns off the program trace facility (debug mode).
          TROFF

TRON      Turns on the program trace facility (debug mode).  
          TRON

TSAVE     Saves the trace buffer to a trace file.
          TSAVE "filename"

UND       Displays text in underline. 
          UND

VAL       Converts a numeric ASCII string to its integer form.
          A= VAL($A)

WRITE     Writes string variable to data file open for output
          WRITE $A 

XYPLOT    Moves cursor to a specified postion on the screen. 
          XYPLOT(y,x)
          y = y-coordinate (row), range 0 - 21 
          x = x-coordinate (column),   range 0 - 79



