
MATH LIBRARY:  libm.a

A zero is represented by all zeros in the floating point 
variable.  

The largest possible value for a float variable is contained in 
the math library variable double dcsu.  The value of this 
variable is 0x7fffffffffffffff.  

The value of infinity is represented by the math library 
variable double dcin.  The value of this variable is 
0xffffffffffffffff.  This value is returned in the instances 
where a floating point operation exceeded the maximum value of 
a double floating point number.

The smallest number x>0 is: x= 0x0000000000000001
                             = ((1+(2-52))(21025)
                             = 1.1125369292536009 x 10-308

If the absolute value of a result is smaller than this number 
(called underflow), a zero is returned.

        #include <math.h>
        double x,y;
        int a, k;


        double log(x)          Base e logarithm function
        double log10(x)        Base 10 logarithm function
        double log2(x)         Base 2 logarithm function
        double exp(x)          Base e exponential function
        double exp10(x)        Base 10 exponential function
        double exp2(x)         Base 2 exponential function
        double sin(x),
            cos(x), tan(x)     Transcendental functions

        double asin(x),
            acos(x),  atan(x)   Inverse transcendental

        double sqr(x)           x squared

        double sqrt(x)          square root of x

        double powerd(x, y)     xy (exp2(x*log2(y))

        double poweri(x,a)      xa (exp2(x*log2(a))

        double dabs(x)          absolute value

        int dint (x)            Integer part of the double that 
                                fractional is the parameter.

        double mulpower2(x, k)  Fast floating point 
                                multiplication by 2k.

        double lngamma(x)       Natural logarithm of the gamma 
                                function if 0<x<5.1x10305. 
                                Outside of this range dcin 
                                (infinity) is returned.

        double fac(k)           k!, where 0?k?170



matinv      matinv is the matrix inverse of the n x n array a.  

            double matinv(a, c, n)
            double *a;
            long *c;
            long n;


