
LAPD LIBRARY FILENAME:  liblapd.a

FLUSH       Clears reception buffer.
            int flush()
            Returns:
              0=Successful
              1=Time out
              3=Receive buffer overflow

GET_MOD     Returns the current modulus.
            int get_mod()
            Returns:
              0=Mod8
              1=Mod128

GET_RNTEI  Returns value of user-defined receive TEI.
            int get_rntei(val)
            int val;     Range: 0 - 2
            Returns:
                  0-127= TEI value
                 -1=val outside of range
                 -2= No extended memory

GET_RSAPI  Returns value of user-defined SAPI.
            int get_rsapi(val)
            int val;     Range: 0 - 2
            Returns:
                  0 - 63= SAPI value
                 -1= val outside of range
                 -2= No extended memory

GET_RTEI    Returns the TEI type last accepted. 
            Not available in extendable LAPD.
            int get_rtei()
            Returns:
              0=Selected TEI
              1=Broadcast TEI

GET_SCONFIG   Returns status configuration byte.
               int get_sconfig
               Returns byte (see manual for interpretation).

GET_SIM     Returns the side being simulated.
            int get_sim()
            Returns:
              0=Network
              1=Subscriber

GETIME    Gets the elapsed milliseconds since the system was 
          started.
          include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;

GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected

INITP1      Initializes P1 and loads software. 
            int initp1(interface,station,encode,bitrate)
            int interface;  0=DCE
                            1=DTE
                            2=ISDN
            int station;    0=Network
                            1=Subscriber
            int encode;     0=NRZ
                            1=NRZI
            long bitrate;   50L - 64000L
            Returns:
              0=Successful
             -1=Parameter error
             -2=Code not found (see manual) 
             -3=Time out
             -4=Can't set interface mode
             -5=Can't set Vtype interface module
             -6=Can't set bit rate
             -7=Internal error
             -8=Cannot run FEP
             -10=Cannot restart simulator
             -11=Cannot initialize simulator (another
                 application is running)
             -13=Cannot initialize timers

P1RESET     Restarts or stops P1 simulation. 
            int p1reset(kind)
            int kind;   0  Restart
                        1  Stop
            Returns:
              0=Successful
             -1=kind is invalid value
              1=Time out

RECEIVE     Receives an I-frame from P1 and places it at 
            address in rloc.
            extern int rxlen;
            int receive(rloc)
            char *rloc;  
            Returns:
              0=Successful or no frame waiting
              2=initp1 not performed
              4=P1 busy

RESTARTSIM    Restarts P1 simulation.
              int restartsim()
              Returns:
                0=Successful
                1=Time out

SETFLG      Changes the idle fill pattern.
            int setflg(flag)
            int flag;   0=FF
                        1=7E
            Returns:
              0=Successful
              1=Time out

SET_BIT_RATE  Sets the bit rate.
               int set_bit_rate(rate)
               long rate;   Range: 50-64000
               Returns:
                 0=Successful
                 1=Error

SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed

SET_MOD     Sets the modulus to Mod8 or Mod128.
            int set_mod(val)
            int val;    0=Mod8
                        1=Mod128
            Returns:
              0=Successful
             -1=val outside of range
              1=Time out

S_N201      Sets N1 (maximum packet size).
            int s_n201(val)
            int val;    Range: 1 - 512
            Returns:
              0=Successful
             -1=val outside of range
              1=Time out

S_N200      Sets N2 (retransmissions).
            int s_n200(val)
            int val;
            Returns:
              0=Successful
              1=Time out

SET_NET     Sets simulation of network.
            int set_net()
            Returns:
              0=Successful
              1=Time out

SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available

SET_RNTEI   Sets user-defined TEI value.
            int set_rntei(val,tei)
            int val;     Range 0 - 2
            int tei;     Range 0 - 255
            Returns:
              0=Successful
              1=Time out
             -1=val or tei outside of range
             -2=No extended memory

SET_RSAPI   Sets value of user-defined SAPI.
            int set_rsapi(val, sapi)
            int val;     Range 0 - 2
            int sapi;    Range 0 - 63 
            Returns:
              0=Successful
              1=Time Out
             -1=val is outside range
             -2=No extended memory

SET_SAPI    Sets transmit and receive SAPI value.
            int set_sapi(val)
            int val;      0 - 63
            Returns:
              0=Successful
             -1=Invalid value
              1=Time out

SET_SCONFIG     Sets status configuration byte.  See manual 
                for interpretation.
                int set_sconfig(byte)
                int byte;
                Returns:
                  0=Successful
                  1=Time Out
                 -2=No extended memory

SET_SUB     Sets simulation of subscriber.
            int set_sub()
            Returns:
              0=Successful
              1=Time out

S_T200      Sets value of the T200 timer.
            int s_t200(val)
            int val;  
            Returns:
              0=Successful
              1=Time out

S_T203      Sets value of T2 timer.
            int s_t203(val)
            int val;
            Returns:
              0=Successful
              1=Time out

SET_TEI     Sets transmit and receive TEI value.
            int set_tei(val)
            int val;     Range: 0 - 127
            Returns:
              0=Successful
             -1=val outside or range
              1=Time out

SETTIMER   Sets the timer value.
           int settimer(number,value)
           int  number;   0=.01 timer (down)
                          1=.01 timer (up)
                          2=seconds (down)
                          3=seconds (up)
           unsigned int value;    timer setting
           Returns:
             0=Successful
             1=Invalid number
             2=inittime not performed

SET_WINDOW   Sets window size.
             int set_window(val)
             int val;    Range: 1 - 7
             Returns:
               0=Successful
              -1=val outside of range
               1=Time out

SLOF        Disconnects link.
            int slof()
            Returns:
              0=Successful
              1=Time out

SLON        Establishes link by sending a SABM or SABME.
            int slon()
            Returns:
              0=Successful
              1=Time out

STATUS      Indicates status of frame level.
            int status()
            Returns:
               0=Disconnected
               1=Link connection requested
               2=Packet reject 
               3=Link disconnection requested
               4=Information transfer
               5=Local station busy
               6=Remote station busy
               7=Local and remote station busy
              *8=Remote station not responding
              other=LAPD not running

STOPSIM     Stops P1 simulation.
            int stopsim()
            Returns:
              0=Successful
              1=Time out

TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)

TRANS       Transmits a specified type of frame.
            int trans(stat,frame,len)
            int stat;   0x80=I-Frame
                        0x81=UI frame
                        0x82=XID Command frame
                        0x83=XID Response frame
            char *frame;
            int len;    Range: 0 - 511
            Returns:
              0=Successful
              1=P1 busy
              2=initp1 not performed
              3=Link not established
              5=Time out
              trxcni if an XID command with len=0
              trxrni if an XID response with len=0

TRANSMIT    Transmits number of bytes in length, starting at 
            address in packet.
            int transmit(packet, length)
            char *packet;
            int length;
            Calls and returns the value returned by: 
            trans(IFRAME,packet, length)

TRUI        Transmits an unnumbered I-frame.
            int trui(xloc,xlen)
            char *xloc;    Location of data
            int xlen;      Length of data field
            Calls and returns the value returned by:  
            trans(UI,packet, length)

TRXCNI      Transmits an XID command frame without an I-field.
            int trxcni()
            Returns:
              0=Successful
              1=Time out

TRXIDC      Transmits an XID command frame with an I-field.
            int trxidc(xloc,xlen)
            char *xloc;    Location in memory
            int xlen;       Length
            Calls and returns the value returned by:  
            trans(XIDC,xloc,xlen)

TRXIDR      Transmits an XID response frame with an I-field. 
            int trxidr(xloc,xlen)
            char *xloc;     Location in memory
            int xlen;       Length
            Calls and returns the value returned by:   
            trans(XIDR,xloc,xlen)

TRXRNI     Transmits an XID response frame without an I-field.
           int trxrni()
           Returns:
             0=Successful
             1=Time out

