
BSC LIBRARY FILENAME:   libbsc.a

FLUSH      Clears reception buffer.
           int flush()
           Returns:     3 = Receive buffer overflow


GETPHY     Returns state of the physical interface.
           int getphy()
           Returns a 16-bit integer, bit encoded as:

                Byte 0
           Bit    7     6     5     4     3     2     1     0
           Pin   105   108   140   141   104   103   114   115
           Pin    4     20                3     2     15    17
           Sig   RTS   DTR   SQ          RD    TD    SCT   SCR

                Byte 1
           Bit    7     6     5     4     3     2   1    0
           Pin   106   107   109   122   125   142
           Pin    5     6     8     12    22
           Sig   CTS   DSR   CD    SDCD   RI


GETIME    Gets the elapsed milliseconds since the system was 
          started.
          include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected


IDLE_MODE    Specifies the character to be transmitted while
             the line is idle.
             #include <cham.h>
             int idle_mode(mode)
             int mode;

             mode is either:  IDLE or 0   (Transmits FF)
                              SYNC or 1   (Transmits SYN char)



INITP1     Initializes P1. Loads simulation software. 
           int initp1(type, encode, bitrate, crc, data)
           int type;   0=DCE
                       1=DTE
           struct control encode
           Defines the control characters for BSC, as follows:
           struct control
               {
               unsigned char eot;
               unsigned char syn;
               unsigned char dle;
               unsigned char stx;
               unsigned char etx;
               unsigned char soh;
               unsigned char etb;
               unsigned char itb;
               unsigned char enq;
               };
           unsigned long bitrate;     50 - 64000
           char crc;   0=CRC16 block check
                       1=CCITT-CRC block check
           int data;   0x10    EBCDIC data
                       0x04    ASCII (no parity)
                       0x01    ASCII (even parity)
                       0x00    ASCII (odd parity)
           Returns:
             0=Successful
            -1=Invalid parameter(s)
            -2=P1 program not loaded

INITTIME   Initializes the interrupt system to start and 
           maintain the .01 second and 1 second timers.


P1RESET    Restarts or stops P1 simulation. 
           int p1reset(kind)
           int kind;  0=Restart
                       1=Stop
           Returns:
             0=Successful
            -1=Invalid parameter(s)

RECEIVE    Receives a frame from P1 and places it at address 
           in frame.
           char receive (frame)
           char *frame;
           Returns:
             0=Good BCC or no frame waiting
             1=Bad BCC
             2=initp1 not performed
             3=Overflow


SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed


SETPHY     Sets physical interface lines as below.
           setphy()

               DCE
           Bit    7     6     5     4     3     2   1    0
           Pin   106   107   109   122   125   142
           Pin    5     6     8     12    22
           Sig   CTS   DSR   CD    SDCD   RI

               DTE
           Bit    7     6     5   4   3   2   1    0
           Pin   105   108   140   
           Pin    4     20
           Sig   RTS   DTR    SQ


SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETTIMER   Sets the timer value.
           int settimer(number,value)
           int number;   0=.01 timer (down)
                         1=.01 timer (up)
                         2=seconds (down)
                         3=seconds (up)
          unsigned int value;       timer setting
          Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed


TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)


TREADY     Returns status of P1 transmitter.
           int tready()
           Returns:
             0=Transmitter ready
             1=Transmitter not ready
             2=initp1 not performed
             3=Overflow


TRANSMIT   Transmits number of bytes in length, starting at 
           address pointed to by *frame, with the control 
           characters and BCC as specified by mode.  
           int transmit(mode, frame, length)
           char *frame;
           int length;
           char mode;     (bit-encoded as shown below)
           Returns:
             0=Successful
             1=P1 busy
             2=initp1 not performed
             3=Parameter error
             4=Buffer overflow

           Bit 0 - Start Framing Character:  0=SOF
                                             1=STX
           Bits 1,2 - End Framing Character:  00=EOT
                                              01=ETB
                                              10=ETX
                                              11=Illegal
           Bit 3 - Transparent Text Enable:  0=Normal Text
                                             1=Xparent Text
           Bit 4 - Transparent Mode: 0=Xparent mode 0
                                     1=Xparent mode 1
           Bit 5 - Text Mode:  0=Control Mode
                               1=Text Mode
           Bit 6 - Block Check Character: 0=Good BCC
                                          1=Bad BCC
           Bit 7 - Reserved (must be 1)

