#include "x25.h"

/********************************************************************
file : x25_ub.c
date : Dec 28th 1989
Author : Gilles Lejeune
desc : unbuild x25 packet
parameters : 
	pframe : pointer on the HDLC data
	len    : length of those data
	px25   : pointer on an X25 description structure ( x25_st )
return    :
	0  : decoding Ok
	-1 : decoding error
Comment : This routine will decode the HDLC data pointed by "pframe" and
          fill the structure pointed by "px25".
Warning : The Calling and called addresses will be copied to user buffer
          and will the data.
**********************************************************************/

int	x25_ub(pframe,len,px25)
uchar	*pframe ;
int	len ;
struct	x25_st	*px25 ;
{
int	i,j,numoct ;
int	dataflag = 1 ;

if ( len < 3 )
	return(-1) ;
px25->x25_q = (*pframe & 0x80) >> 7 ;
px25->x25_d = (*pframe & 0x40) >> 6 ;
px25->x25_mod = (*pframe & 0x30) >> 4 ;
px25->x25_lcgn = (*pframe++ & 0x0f) ;

px25->x25_lcn = *pframe++ ;

if (( *pframe & 1 ) == 0) 
	px25->x25_type = PT_DT ;
else if ( (*pframe & 0x1f ) == PT_RR )
	px25->x25_type = PT_RR ;
else if ( (*pframe & 0x1f ) == PT_RNR )
	px25->x25_type = PT_RNR ;
else if ( (*pframe & 0x1f ) == PT_REJ )
	px25->x25_type = PT_REJ ;
else
	px25->x25_type = *pframe ;

len -= 3 ;

switch(px25->x25_type)
	{
	case PT_CLC :
	case PT_IT :
	case PT_ITC :
	case PT_RSTC :
		dataflag = 0 ;
		break ;
	case PT_CLR :
	case PT_RES :
	case PT_REC :
	case PT_RST :
	case PT_DIAG :
		pframe++ ;
		break ;		 
	case PT_RR :
	case PT_RNR :
	case PT_REJ :
		px25->x25_pr = (*pframe & 0xe0 ) >> 5 ;
		dataflag = 0 ;
		break ;
	case PT_DT :
		px25->x25_pr = (*pframe & 0xe0 ) >> 5 ;
		px25->x25_ps = (*pframe & 0x0e ) >> 1 ;
		px25->x25_m = (*pframe & 0x10 ) >> 4 ;
		pframe++ ;
		break ;
	case PT_CR :
	case PT_CA :
		if ( len < 1 )
			return(-1) ;
		pframe++ ;
		px25->x25_cgal = (*pframe & 0xf0) >> 4 ;
		px25->x25_cdal = (*pframe++ & 0x0f ) ;
		len-- ;
		numoct = px25->x25_cgal + px25->x25_cdal ;
		if ( numoct % 2 )
			numoct + 1 ;
		numoct /= 2 ;
		len -= numoct ;
		if ( len < 1 )
			return(-1) ;
		for ( i=0 ; i!= px25->x25_cgal ; i++ )
			{
			if ( i % 2 )
				{
				*(px25->x25_cga+i) = cvdig(*pframe&0x0f) ;	
				pframe++ ;
				}
			else
				*(px25->x25_cga+i) = cvdig((*pframe & 0xf0) >> 4 ) ;
			}
		*(px25->x25_cga+i) = 0 ;
		for( j=0 ; j!= px25->x25_cdal ; j++, i++)
			{
			if ( i % 2 )
				{
				*(px25->x25_cda+j) = cvdig(*pframe&0x0f) ;	
				pframe++ ;
				}
			else
				*(px25->x25_cda+j) = cvdig((*pframe & 0xf0) >> 4 ) ;
			}
		*(px25->x25_cda+j) = 0 ;
		break ;
	
	default :
		return(-1) ;
	}

if ( dataflag )
	{
	if ( len > 0 )
		{
		for( i=0 ; i!= len ; i++ )
			*(px25->x25_data+i) = *pframe++ ;
		px25->x25_dtl = len ;
		}
	}
return(0) ;
}
	 		
cvdig(dig)
uchar	dig ;
{
if ( ( dig >= 0 ) && ( dig <= 9 ) )
	return(dig+'0') ;
else if ( ( dig >= 0x0a ) && ( dig <= 0x0f ) )
	return(dig+'A') ;
}
