/************************************************************************
*
* lnkloader - Loads objects from asm990 for linking.
*
* Changes:
*   06/05/03   DGP   Original.
*   06/25/03   DGP   Changed to print listing like TXLINK.
*                    Changed to link undefined external chains.
*   06/27/03   DGP   Added compressed binary support.
*   07/10/03   DGP   Changed to use first global definition and ignore 
*                    absolute externals with a zero value.
*   04/12/04   DGP   Changed to allow non-80 byte records.
*   05/25/04   DGP   Added long ref/def support.
*
************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>

#include "lnkdef.h"

extern FILE *lstfd;
extern int listmode;
extern int pc;
extern int errcount;
extern int absentry;
extern int relentry;
extern int linecnt;
extern int modcount;
extern uint8 memory[MEMSIZE];
extern Memory memctl[MEMSIZE];
extern char idtbuf[IDTSIZE+2];
extern Module modules[MAXMODULES];

extern int errno;

int
lnkloader (FILE *fd, int loadpt, int pass, char *file)
{
   int status = 0;
   int binarymode = FALSE;
   int reclen;
   int curraddr;
   int relo;
   int wordtaglen = WORDTAGLEN;
   unsigned char inbuf[82];
   char module[MAXSYMLEN+2];

#ifdef DEBUGLOADER
   printf ("lnkloader: loadpt = %04X, pass = %d, file = %s\n",
	 loadpt, pass, file);
#endif

   curraddr = loadpt;

   while (fgets (inbuf, 81, fd) != NULL)
   {
      SymNode *s;
      unsigned char *op = inbuf;
      int i;

      reclen = strlen (inbuf);
#ifdef DEBUGLOADER
      printf ("reclen = %d\n", reclen);
#endif
      if (*op == EOFSYM)
      {
	 if (pass == 1)
	 {
	    if (reclen > 60)
	    {
	       strncpy (modules[modcount].date, &inbuf[TIMEOFFSET], 8);
	       modules[modcount].date[9] = '\0';
	       strncpy (modules[modcount].time, &inbuf[DATEOFFSET], 8);
	       modules[modcount].time[9] = '\0';
	       strncpy (modules[modcount].creator, &inbuf[CREATOROFFSET], 8);
	       modules[modcount].creator[9] = '\0';
	    }
	    else
	    {
	       strncpy (modules[modcount].date, "        ", 8);
	       strncpy (modules[modcount].time, "        ", 8);
	       strncpy (modules[modcount].creator, "        ", 8);
	    }
	    modcount++;
	 }
	 loadpt = curraddr;
	 continue;
      }

      for (i = 0; i < reclen; i++)
      {
	 char *bp;
	 int refaddr;
	 char otag;
	 char item[80];
	 uint16 wdata;

	 relo = FALSE;
	 otag = *op++;
	 if (binarymode)
	 {
	    wdata = (*op << 8) | *(op+1);
	 }
	 else
	 {
	    int wd;
	    strncpy (item, op, 4);
	    item[4] = '\0';
	    sscanf (item, "%4X", &wd);
	    wdata = wd & 0xFFFF;
	 }
#ifdef DEBUGLOADER
	 printf ("otag = %c, loadpt = %04X, curraddr = %04X\n",
		  isprint(otag) ? otag : '0', loadpt, curraddr);
	 printf ("data = %04X\n", wdata & 0xFFFF);
#endif

	 refaddr = 0;

         switch (otag)
	 {
	 case BINIDT_TAG: /* Binary IDT */
	    binarymode = TRUE;
	    wdata = (*op << 8) | *(op+1);
	    wordtaglen = BINWORDTAGLEN;
#ifdef DEBUGLOADER
            printf ("Binary mode: wdata = %04x\n", wdata);
#endif
	 case IDT_TAG:
	    op += wordtaglen-1;
	    strncpy (item, op, IDTSIZE);
	    item[IDTSIZE] = '\0';
#ifdef DEBUGLOADER
            printf ("IDT = %s\n", item);
#endif
	    bp = item;
	    for (; *bp; bp++) if (isspace(*bp)) *bp = '\0';
	    strcpy (module, item);
	    if (pass == 1)
	    {
	       strcpy (modules[modcount].objfile, file);
	       strcpy (modules[modcount].name, item);
	       modules[modcount].length = wdata;
	       modules[modcount].origin = loadpt;
	       modules[modcount].creator[0] = '\0';
	       modules[modcount].date[0] = '\0';
	       modules[modcount].time[0] = '\0';
	    }
	    if (idtbuf[0] == '\0')
	    {
	       strcpy (idtbuf, item);
	    }
	    op += IDTSIZE;
	    break;

         case RELORG_TAG:
	    wdata += loadpt;
         case ABSORG_TAG:
	    PUTMEM (curraddr, wdata);
	    memctl[curraddr].tag = otag;
	    curraddr = wdata & 0xFFFF;
	    op += wordtaglen-1;
	    break;

	 case RELDATA_TAG:
	    wdata += loadpt;
	    memctl[curraddr].relocatable = TRUE;
	 case ABSDATA_TAG:
	    PUTMEM (curraddr, wdata);
	    memctl[curraddr].tag = otag;
	    curraddr += 2;
	    op += wordtaglen-1;
	    break;

	 case RELENTRY_TAG:
	    relentry = (wdata + loadpt) & 0xFFFF;
	    op += wordtaglen-1;
	    break;

	 case ABSENTRY_TAG:
	    absentry = wdata & 0xFFFF;
	    op += wordtaglen-1;
	    break;

	 case RELEXTRN_TAG:
	    wdata += loadpt;
	    relo = TRUE;
	 case ABSEXTRN_TAG:
	    refaddr = wdata;
	    op += wordtaglen-1;
	    if (pass == 2)
	    {
	       strncpy (item, op, MAXSHORTSYMLEN);
	       item[MAXSHORTSYMLEN] = '\0';
	       bp = item;
	       for (; *bp; bp++) if (isspace(*bp)) *bp = '\0';

	       if ((s = symlookup (item, module, FALSE)) == NULL)
	       {
		  if (otag != ABSEXTRN_TAG && wdata != 0)
		  {
		     s = symlookup (item, module, TRUE);
		     s->relocatable = relo;
		     s->external = TRUE;
		     s->undef = TRUE;
		     s->value = wdata;
		  }
	       }
	       else
	       {
		  if (!s->undef)
		  {
		     while (refaddr)
		     {
			int k;
			k = GETMEM (refaddr);
			PUTMEM (refaddr, s->value);
			memctl[refaddr].tag = s->relocatable ? RELDATA_TAG
				       : ABSDATA_TAG;
			refaddr = k;
		     }
		  }
	          else
		  {
		     while (refaddr)
		     {
			int k;
			k = GETMEM (refaddr);
			if (k == 0)
			{
			   memctl[refaddr].tag = RELDATA_TAG;
			   PUTMEM(refaddr, s->value);
			   s->value = wdata;
			}
			refaddr = k;
		     }
		  }
	       }
	    }
	    op += MAXSHORTSYMLEN;
	    break;

	 case RELGLOBAL_TAG:
	    wdata += loadpt;
	    relo = TRUE;
	 case ABSGLOBAL_TAG:
	    op += wordtaglen-1;
	    strncpy (item, op, MAXSHORTSYMLEN);
	    item[MAXSHORTSYMLEN] = '\0';
	    bp = item;
	    for (; *bp; bp++) if (isspace(*bp)) *bp = '\0';
	    if (pass == 1)
	    {
	       if ((s = symlookup (item, module, FALSE)) == NULL)
	       {
		  s = symlookup (item, module, TRUE);
		  s->global = TRUE;
		  s->relocatable = relo;
		  s->value = wdata;
	       }
	       else
	       {
	          s->muldef = TRUE;
	       }
	    }
	    op += MAXSHORTSYMLEN;
	    break;

	 case LRELEXTRN_TAG:
	    wdata += loadpt;
	    relo = TRUE;
	 case LABSEXTRN_TAG:
	    refaddr = wdata;
	    op += wordtaglen-1;
	    if (pass == 2)
	    {
	       strncpy (item, op, MAXSYMLEN);
	       item[MAXSYMLEN] = '\0';
	       bp = item;
	       for (; *bp; bp++) if (isspace(*bp)) *bp = '\0';

	       if ((s = symlookup (item, module, FALSE)) == NULL)
	       {
		  if (otag != ABSEXTRN_TAG && wdata != 0)
		  {
		     s = symlookup (item, module, TRUE);
		     s->relocatable = relo;
		     s->external = TRUE;
		     s->longsym = TRUE;
		     s->undef = TRUE;
		     s->value = wdata;
		  }
	       }
	       else
	       {
		  if (!s->undef)
		  {
		     while (refaddr)
		     {
			int k;
			k = GETMEM (refaddr);
			PUTMEM (refaddr, s->value);
			memctl[refaddr].tag = s->relocatable ? RELDATA_TAG
				       : ABSDATA_TAG;
			refaddr = k;
		     }
		  }
	          else
		  {
		     while (refaddr)
		     {
			int k;
			k = GETMEM (refaddr);
			if (k == 0)
			{
			   memctl[refaddr].tag = RELDATA_TAG;
			   PUTMEM(refaddr, s->value);
			   s->value = wdata;
			}
			refaddr = k;
		     }
		  }
	       }
	    }
	    op += MAXSYMLEN;
	    break;

	 case LRELGLOBAL_TAG:
	    wdata += loadpt;
	    relo = TRUE;
	 case LABSGLOBAL_TAG:
	    op += wordtaglen-1;
	    strncpy (item, op, MAXSYMLEN);
	    item[MAXSYMLEN] = '\0';
	    bp = item;
	    for (; *bp; bp++) if (isspace(*bp)) *bp = '\0';
	    if (pass == 1)
	    {
	       if ((s = symlookup (item, module, FALSE)) == NULL)
	       {
		  s = symlookup (item, module, TRUE);
		  s->global = TRUE;
		  s->longsym = TRUE;
		  s->relocatable = relo;
		  s->value = wdata;
	       }
	       else
	       {
	          s->muldef = TRUE;
	       }
	    }
	    op += MAXSYMLEN;
	    break;

	 case EOR_TAG:
	    i = 81;
	    break;

	 default: ;
	    op += wordtaglen-1;
	 }
      }
   }


   pc = curraddr;
   return (status);

}
