/***********************************************************************
*
* asmdef.h - Assembler header for the TI 990 computer.
*
* Changes:
*   05/21/03   DGP   Original.
*   08/12/03   DGP   Revert print format to one word per line.
*                    Add all operation types.
*   05/25/04   DGP   Added Long REF/DEF pseudo ops.
*   06/07/04   DGP   Added LONG, QUAD, FLOAT and DOUBLE pseudo ops.
*	
***********************************************************************/

#include <stdio.h>

/*
** Definitions
*/

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define VERSION "1.3.0"

#define LITERALSYM '='
#define COMMENTSYM '*'
#define MEMSYM '@'
#define STRINGSYM '\''
#define EOFSYM ':'

#define MAXLINE 256
#define MAXASMFILES 30
#define LINESPAGE 60
#define NOOPERAND 60
#define TTLSIZE 60
#define IDTSIZE 8

#define TEMPSPEC "asXXXXXX"

/*
** Object output formats
*/

#define OBJFORMAT "%c%04X"
#define IDTFORMAT "%c%04X%-8.8s"
#define REFFORMAT "%c%4.4X%-6.6s"
#define DEFFORMAT "%c%4.4X%-6.6s"
#define BYTEFORMAT "%c%02X00"
#define SEQFORMAT "%6.6d\n"
#define LREFFORMAT "%c%4.4X%-32.32s"
#define LDEFFORMAT "%c%4.4X%-32.32s"

/*
** Listing formats
*/

#define H1FORMAT "ASM990 %-8.8s  %-24.24s   %s Page %04d\n"
#define H2FORMAT "%s\n\n"

#define L1FORMAT "%s %s %4d %s"
#define L2FORMAT "%s %s\n"
#define LITFORMAT "%s %s       %s\n"

#define PCBLANKS "    "
#define PCFORMAT "%04X"

#define OPBLANKS  "     "
#define OP1FORMAT "%04X%c"
#define ADDRFORMAT "%04X%c"
#define CHAR1FORMAT "%02X   "
#define DATA1FORMAT "%04X%c"

#define SYMFORMAT " %-8.8s %4.4X%c "
#define LONGSYMFORMAT " %-34.34s %4.4X%c "

#define XREFHEADER " SYMBOL   ADDR    DEF            REFERENCES\n\n"
#define LONGXREFHEADER \
" SYMBOL                             ADDR    DEF            REFERENCES\n\n"

/*
** Data type definitions
*/

#ifndef __TYPE_DEFS__
#define __TYPE_DEFS__
#define int8            char
#define int16           short
#define int32           int
typedef int             t_stat;                         /* status */
typedef int             t_bool;                         /* boolean */
typedef unsigned int8   uint8;
typedef unsigned int16  uint16;
typedef unsigned int32  uint32, t_addr;                 /* address */

#if defined (WIN32)                                     /* Windows */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (VMS)                /* Alpha VMS */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (__unix__)           /* Alpha UNIX */
#define t_int64 long
#else                                                   /* default GCC */
#define t_int64 long long
#endif                                                  /* end OS's */
typedef unsigned t_int64        t_uint64, t_value;      /* value */
typedef t_int64                 t_svalue;               /* signed value */
#ifdef USS
#define DOUBLE double
#else
#define DOUBLE t_uint64
#endif
#if defined(USS) || defined(SOLARIS) || defined(AIX) || defined(__s390__) 
#define ASM_BIG_ENDIAN
#endif
#endif /* __TYPE_DEFS__ */

/*
** OpCode table definition
*/

#define NUMOPS 190

enum optypes
{
   TYPE_1=1,
   TYPE_2,
   TYPE_3,
   TYPE_4,
   TYPE_5,
   TYPE_6,
   TYPE_7,
   TYPE_8,
   TYPE_9,
   TYPE_10,
   TYPE_11,
   TYPE_12,
   TYPE_13,
   TYPE_14,
   TYPE_15,
   TYPE_16,
   TYPE_17,
   TYPE_18,
   TYPE_19,
   TYPE_20,
   TYPE_21,
   TYPE_P  	/* Pseudo op */
};

enum psops
{
   AORG_T=1,
   ASMIF_T,
   ASMELS_T,
   ASMEND_T,
   BES_T,
   BSS_T,
   BYTE_T,
   CEND_T,
   CKPT_T,
   COPY_T,
   CSEG_T,
   DATA_T,
   DEF_T,
   DEND_T,
   DFOP_T,
   DORG_T,
   DOUBLE_T,
   DSEG_T,
   DXOP_T,
   END_T,
   EQU_T,
   EVEN_T,
   FLOAT_T,
   IDT_T,
   LDEF_T,
   LIST_T,
   LOAD_T,
   LONG_T,
   LREF_T,
   NOP_T,
   OPTION_T,
   PAGE_T,
   PEND_T,
   PSEG_T,
   QUAD_T,
   REF_T,
   RORG_T,
   RT_T,
   SETMNL_T,
   SETRM_T,
   SREF_T,
   TEXT_T,
   TITL_T,
   UNL_T,
   WPNT_T,
   XVEC_T
};

typedef struct
{
   char *opcode;	/* Opcode */
   unsigned opvalue;	/* Opcode value */
   unsigned opmod;	/* Opcode modifier */
   int optype;		/* Opcode type (format) */
   int cputype;		/* Supported CPU */
} OpCode;

/*
** Symbol table
*/

#define MAXSYMLEN 32
#define MAXSHORTSYMLEN 6
#define MAXSYMBOLS 4000

typedef struct Xref_Node
{
   struct Xref_Node *next;
   int line;
} XrefNode;

typedef struct
{
   XrefNode *xref_head;
   XrefNode *xref_tail;
   char symbol[MAXSYMLEN+2];
   int line;
   int value;
   int relocatable;
   int external;
   int global;
   int longsym;
   int load;
   int sref;
   int xop;
   int predefine;
} SymNode;

/*
** Object tags
*/

#define IDT_TAG		'0'
#define ABSENTRY_TAG	'1'
#define RELENTRY_TAG	'2'
#define RELEXTRN_TAG	'3'
#define ABSEXTRN_TAG	'4'
#define RELGLOBAL_TAG	'5'
#define ABSGLOBAL_TAG	'6'
#define CKSUM_TAG	'7'
#define NOCKSUM_TAG	'8'
#define ABSORG_TAG	'9'
#define RELORG_TAG	'A'
#define ABSDATA_TAG	'B'
#define RELDATA_TAG	'C'
#define EOR_TAG		'F'

#define RELSYMBOL_TAG	'G'
#define ABSSYMBOL_TAG	'H'
#define LOAD_TAG	'U'
#define RELSREF_TAG	'V'
#define ABSSREF_TAG	'Y'

#define LRELSYMBOL_TAG	'i'
#define LABSSYMBOL_TAG	'j'
#define LRELEXTRN_TAG	'l'
#define LABSEXTRN_TAG	'm'
#define LRELGLOBAL_TAG	'n'
#define LABSGLOBAL_TAG	'o'
#define LLOAD_TAG	'p'
#define LRELSREF_TAG	'q'
#define LABSSREF_TAG	'r'

#define CHARSPERREC	66  /* Chars per object record */
#define CHARSPERCASREC	73  /* Chars per cassette object record */
#define WORDTAGLEN	5   /* Word + Object Tag length */
#define EXTRNLEN	11  /* Tag + SYMBOL + addr */
#define GLOBALLEN	11  /* Tag + SYMBOL + addr */
#define IDTLEN		13  /* Tag + IDT + length */
#define SEQUENCENUM	74  /* Where to put the sequence */

/*
** Pass 1 error table - pass 2 does the printing.
*/

#define MAXERRORS 1000

typedef struct
{
   char *errortext;
   int errorline;
} ErrTable;

/*
** COPY files data
*/

typedef struct
{
   FILE *fd;
   int line;
} COPYfile;

/*
** Parser definitions
*/

#include "asm990.tok"

#define MEMREF	1
#define FLTNUM	2

typedef uint8  tchar;  /* 0..255 */
typedef uint8  pstate; /* 0..255 */
typedef uint16 toktyp; /* 0..0x7F */
typedef uint16 tokval;

#define TOKENLEN  80 /* symbol and string length */
#define VALUEZERO 0

/*
** External definitions
*/

extern int detab (FILE *, FILE *);
extern int asmpass1 (FILE *);
extern int asmpass2 (FILE *, FILE *, int, FILE *);

extern OpCode *oplookup (char *);

extern char *tokscan (char *, char **, int *, int *, char *);
extern SymNode *symlookup (char *, int, int);
extern char *exprscan (char *, int *, char *, int *, int, int, int);
extern unsigned long cvtfloat (char *);
extern t_uint64 cvtdouble (char *);
extern DOUBLE ibm_strtod (const char *, char **);

extern FILE *opencopy (char *, FILE *);
extern FILE *closecopy (FILE *);

extern void Parse_Error (int, int, int);
extern tokval Parser (char *, int *, int *, int, int, int);
extern toktyp Scanner (char *, int *, tokval *, char *, char *, int);
