/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char sccsid[] = "@(#)cps.c 9.4 88/01/19 Copyright 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*-
	c->postscript interface constructor

	cps.c, Thu Mar 13 17:08:47 1986

		James Gosling and Craig Taylor
		Sun Microsystems
 */

#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
#include "encoding.h"
#include <stdio.h>
#include <ctype.h>

#define STRCONSTLIMIT 400	/* Set this to the length of the longest
				 * string constant that your C compiler can
				 * deal with */

enum p_types {
    t_none,
    t_int,
    t_float,
    t_double,
    t_fixed,
    t_string,
    t_cstring,
    t_postscript,
    t_cpostscript,
    t_usertoken,
    t_max
};

struct token {
    short       len;
    short       kind;
    enum p_types param:8;
    int         ppos:8;
    int         value;
    struct token *left,
               *right;
    char        token[4];
};

char       *magicnames[] = {
#include "systoklst.h"
    0
};

static char *default_definitions[] = {

#ifndef NOHEADER
#include "defs.incl"
#endif

    0
};

struct token *root;
char       *token;
int         compilemode = 0;
int         tokenlen;
int         tokensize;
FILE       *input;
FILE       *initfile;
int         seperateinit;
struct token *tokent;
struct token *arglist[50];
struct token **argtop;
struct token *retlist[50];
struct token **rettop;
struct token *thisproc;
int         packetid;
int         havepacketid;
char       *filename;
char       *psbuf;
int         reusetoken;
int         psbufsize,
            psbufused;
int         lineno = 1;
int         inprocdef = 0;
int         needspace = 0;
int         ppos;
int         error_seen;

char       *cpplist[100];
char      **cpptop = cpplist;

char        chartype[257];
#define ct_plist 1
#define ct_str 2
#define ct_single 4
#define ct_ignore 8
#define isa(c,type) ((chartype[(c)+1]&(type))!=0)
int         tokenmask = ct_single;

#define k_normal 0
#define k_keyword 1
#define k_systok 2
#define k_usertok 3
#define k_string 4
#define k_fract 5
struct token *ttab[(int) t_max];

int         sysindex;
int         userindex;

#define addchar(ch) { \
    if (tokenlen>=tokensize) \
	token = (char *) realloc(token, tokensize += 100); \
    token[tokenlen++] = ch; \
}

addpstr(s, n)
    register char *s;
    register    n;
{
    register char *d;
    if (n > 0) {
	if (psbufused + n > psbufsize)
	    psbuf = (char *) realloc(psbuf, psbufsize += n + 1000);
	d = psbuf + psbufused;
	psbufused += n;
	do {
	    *d++ = *s++;
	} while (--n);
    }
}

addppstr(s, n)
    register char *s;
    register    n;
{
    while (--n >= 0) {
	if (psbufused + 2 > psbufsize)
	    psbuf = (char *) realloc(psbuf, psbufsize += 1000);
	if (*s == '%' && !compilemode)
	    psbuf[psbufused++] = '%';
	psbuf[psbufused++] = *s++;
    }
}

addpch(c)
    char        c;
{
    addppstr(&c, 1);
}

struct token *
lookup(str, len)
    register char *str;
{
    register struct token *t,
              **from;
    register    flag;
    from = &root;
    while (t = *from) {
	if ((flag = str[0] - t->token[0]) == 0
		&& (flag = strncmp(str, t->token, len)) == 0
		&& (flag = len - t->len) == 0)
	    return t;
	if (flag < 0)
	    from = &t->left;
	else
	    from = &t->right;
    }
    t = (struct token *) malloc(sizeof(struct token) + len - sizeof t->token);
    t->len = len;
    t->kind = 0;
    t->value = 0;
    t->param = t_none;
    t->left = 0;
    t->right = 0;
    bcopy(str, t->token, len);
    *from = t;
    if (isdigit(*str) || *str == '.') {
	register    flag = 0;
	register double v = 0;
	while (--len >= 0)
	    if (isdigit(*str)) {
		if (v > 0x7FFFFFFF / 10)
		    break;
		v = v * 10 + (*str++ - '0');
		if (flag)
		    flag++;
	    }
	    else if (*str == '.')
		str++, flag++;
	    else
		break;
	if (len < 0) {
	    while (flag > 1)
		flag--, v /= 10;
	    if (0.01 < v && v < (1 << 15) || v == 0) {
		t->kind = k_fract;
		t->value = v * (1 << 16) + 0.5;
	    }
	}
    }
    return t;
}

gettoken()
{
    register FILE *f = input;
    register    c,
                whitespace = 0;
    if (reusetoken) {
	reusetoken = 0;
	return 0;
    }
    while (isa(c = getc(f), ct_ignore)) {
	if (c == '\n')
	    lineno++;
	whitespace = 1;
    }
    if (c == '%') {
	while ((c = getc(f)) != EOF && c != '\n');
	lineno++;
	return gettoken();
    }
    tokenlen = 0;
    addchar(c);
    if (c == EOF)
	return -1;
    if (!isa(c, tokenmask)) {
	if (isa(c, ct_str)) {
	    register    depth = 1;
	    while (1) {
		c = getc(f);
		addchar(c);
		switch (c) {
		case '(':
		    depth++;
		    break;
		case ')':
		    depth--;
		    if (depth <= 0) {
			tokent = lookup(token, tokenlen);
			tokent->kind = k_string;
			return 0;
		    }
		    break;
		case '\\':
		    c = getc(f);
		    tokenlen--;
		    switch (c) {
		    case 'n':
			addchar('\n');
			break;
		    case 't':
			addchar('\t');
			break;
		    case 'f':
			addchar('\f');
			break;
		    case 'b':
			addchar('\b');
			break;
		    case '\n':
			lineno++;
			break;
		    case '0':
		    case '1':
		    case '2':
		    case '3':
		    case '4':
		    case '5':
		    case '6':
		    case '7':
			{
			    register    n = c - '0',
			                left = 2;
			    while (--left >= 0) {
				c = getc(f);
				if (c < '0' || c > '7') {
				    ungetc(c, f);
				    break;
				}
				n = (n << 3) + (c - '0');
			    }
			    addchar(n);
			}
			break;
		    default:
			addchar(c);
			break;
		    }
		    break;
		case '\n':
		    fprintf(stderr, "String goes past end of line, at line %d\n", lineno);
		    lineno++;
		    depth = 0;
		    ungetc(')', f);
		    break;
		}
	    }
	}
	else {
	    while (!isa(c = getc(f), tokenmask | ct_str | ct_ignore) && c != EOF)
		addchar(c);
	    if (c == '\n')
		lineno++;
	    ungetc(c, f);
	}
    }
    else if (c == '\\') {	/* Check for syntactic break \# */
	if ((c = getc(f)) != '#') {
	    ungetc(c, f);
	}
	else if (!whitespace) {
	    needspace = 0;
	}
	return gettoken();
    }

    tokent = lookup(token, tokenlen);
    return 0;
}

clean_params(t)
    register struct token *t;
{
    while (t) {
	clean_params(t->left);
	t->param = t_none;
	t = t->right;
    }
}

keyword(str, inx)
{
    register struct token *t = lookup(str, strlen(str));
    t->kind = k_keyword;
    t->value = inx;
}

closeproc()
{
    register struct token **p;
    register char *s;
    register    n;
    char       *sep;
    if (!inprocdef)
	return;
    if (needspace)
	addpstr(" ", 1);
    if (rettop != retlist || havepacketid)
	printf("(");
    if (psbufused > 0) {
	if (psbufused == 1 && argtop == arglist)
	    printf("psio_putc('\\%o', PostScript)", psbuf[0] & 0xff);
	else {
	    n = psbufused;
	    s = psbuf;
	    printf(" pprintf(PostScript, _CPS_%.*s, %d",
		   thisproc->len, thisproc->token,
		   psbufused);
	    for (p = arglist; p < argtop; p++) {
		if ((*p)->param == t_cstring || (*p)->param == t_cpostscript)
		    printf(", L__%d", (*p)->ppos);
		if ((*p)->kind == k_usertok)
		    printf(", %.*s_token", (*p)->len, (*p)->token);
		else
		    printf(", P__%d", (*p)->ppos);
	    }
	    printf(")");
	}
    }
    if (havepacketid) {
	if (psbufused > 0)
	    printf(", ps_waitfor(PostScriptInput, %d)", packetid);
	else {
	    printf("ps_lookingat(PostScriptInput, %d)", packetid);
	    if (rettop != retlist)
		printf(" && (");
	}
    }
    if (rettop != retlist) {
	if (psbufused > 0)
	    printf(", ");
	printf("_CPS_RETURN_%.*s(", thisproc->len, thisproc->token);
	sep = "";
	for (p = retlist; p < rettop; p++) {
	    if ((*p)->param == t_cstring || (*p)->param == t_cpostscript)
		printf("%sL__%d", sep, (*p)->ppos), sep = ", ";
	    printf("%sP__%d", sep, (*p)->ppos);
	    sep = ", ";
	}
	printf(")");
    }

    if (havepacketid && psbufused == 0 && rettop != retlist)
	printf(", 1)");
    if (rettop != retlist || havepacketid)
	printf(")");
    printf("\n");

    if (rettop != retlist) {
	printf("#define _CPS_RETURN_%.*s(", thisproc->len, thisproc->token);
	sep = "";
	for (p = retlist; p < rettop; p++) {
	    if ((*p)->param == t_cstring || (*p)->param == t_cpostscript)
		printf("%sL__%d", sep, (*p)->ppos), sep = ", ";
	    printf("%sP__%d", sep, (*p)->ppos);
	    sep = ", ";
	}
	printf(") ");

	printf("pscanf(PostScriptInput,\"");
	for (p = retlist; p < rettop; p++)
	    switch ((*p)->param) {
	    case t_int:
		printf("d");
		break;
	    case t_fixed:
		printf("e");
		break;
	    case t_float:
		printf("f");
		break;
	    case t_double:
		printf("F");
		break;
	    case t_string:
		printf("s");
		break;
	    case t_cstring:
		printf("*s");
		break;
	    case t_postscript:
		printf("p");
		break;
	    case t_cpostscript:
		printf("*p");
		break;
	    default:
		fprintf(stderr, "Warning: CPS can not currently return %.*s\n",
			(*p)->len, (*p)->token);
	    }
	printf("\"");
	for (p = retlist; p < rettop; p++) {
	    if ((*p)->param == t_cstring || (*p)->param == t_cpostscript)
		printf(", L__%d", (*p)->ppos);
	    printf(", P__%d", (*p)->ppos);
	}
	printf(")");
	printf("\n");
    }

    if (psbufused > 1) {
	if (seperateinit)
	    printf("extern char _CPS_%.*s[];\n",
		   thisproc->len, thisproc->token);
	else
	    printf("static ");
	fprintf(initfile, "char _CPS_%.*s[] = ",
		thisproc->len, thisproc->token);
	if (n < STRCONSTLIMIT) {
	    fputc('"', initfile);
	    while (--n >= 0) {
		register    c = *s++;
		if (c < ' ' || c >= 0177 || c == '\\' || c == '"') {
		    putc('\\', initfile);
		    switch (c) {
		    case '\n':
			putc('n', initfile);
			break;
		    case '\t':
			putc('t', initfile);
			break;
		    default:
			putc(((c >> 6) & 3) + '0', initfile);
			putc(((c >> 3) & 7) + '0', initfile);
			putc((c & 7) + '0', initfile);
		    }
		}
		else
		    putc(c, initfile);
	    }
	    fputc('"', initfile);
	}
	else {
	    int         cols = 20;
	    fprintf(initfile, "{\n");
	    while (--n >= 0) {
		if (cols <= 0) {
		    fputc('\n', initfile);
		    cols = 20;
		}
		cols--;
		fprintf(initfile, "%3d,", *s++ & 0xFF);
	    }
	    fprintf(initfile, "\n}");
	}
	fprintf(initfile, ";\n");
    }
    needspace = 0;
    inprocdef = 0;
    psbufused = 0;
    havepacketid = 0;
    clean_params(root);
}

print_syntax(msg)
    char       *msg;
{
    fprintf(stderr, "Syntax error at line %d, found by %s\n", lineno, msg);
    tokenmask = ct_single;
    error_seen++;
}

print_syntax_at(n)
{
    fprintf(stderr, "Syntax error at line %d, found by %n\n", lineno, n);
    tokenmask = ct_single;
    error_seen++;
}

check_C_name(t)
    register struct token *t;
{
    register char *s = t->token;
    register    n = t->len;
    if (isalpha(*s))
	while ((isalnum(*s) || *s == '_') && --n > 0);
    if (n != 0)
	fprintf(stderr, "\"%.*s\" isn't a legal C identifier, at line %d\n",
		t->len, t->token, lineno);
}

main(argc, argv)
    char      **argv;
{
    char       *program = argv[0];
    char       *prefixfile = "./defs.cps";
    FILE       *mainin = stdin;
    int         adddefs = 1;
    psbuf = (char *) malloc(psbufsize = 10);
    psbufused = 0;
    *cpptop++ = "cpp";
    *cpptop++ = "-C";
    *cpptop++ = "-P";
    while (--argc > 0)
	if (**++argv == '-')
	    switch (argv[0][1]) {
	    case 'c':
		compilemode++;
		break;
	    case 'I':
	    case 'D':
		*cpptop++ = argv[0];
		break;
	    case 'i':
		seperateinit = 1;
		break;
	    case 'n':
		adddefs = 0;
		break;
	    case 'p':
		prefixfile = *++argv;
		argc--;
		break;
	    default:
		fprintf(stderr, "%s: bad switch: %s\n", program, *argv);
		break;
	    }
	else if (filename != 0)
	    fprintf(stderr, "%s: only one input file allowed; %s ignored\n",
		    program, argv[0]);
	else
	    filename = argv[0];
    initfile = stdout;
    *cpptop = 0;
    if (filename) {
	char        outfile[100];
	char        backup[100];
	int         cppfd[2];
	register char *s,
	           *st;
	if ((mainin = fopen(filename, "r")) == 0) {
	    fprintf(stderr, "%s: Can't read %s\n", program, filename);
	    exit(0);
	}
	if (pipe(cppfd) < 0) {
	    fprintf(stderr, "%s: Can't create pipe.\n", program);
	    exit(0);
	}
#ifdef SYSVREF
	if (fork() == 0) {
#else
	if (vfork() == 0) {
#endif
	    dup2(fileno(mainin), 0);
	    dup2(cppfd[1], 1);
	    close(cppfd[0]);
	    close(cppfd[1]);
	    execv("/lib/cpp", cpplist);
	    write(2, "Can't exec /lib/cpp.\n", 21);
	    exit(0);
	}
	dup2(cppfd[0], fileno(mainin));
	close(cppfd[1]);
	close(cppfd[0]);
	st = filename;
	for (s = filename; *s;)
	    if (*s++ == '/')
		st = s;
	if (*st == 0)
	    st = filename;
	s = outfile;
	while (*st && *st != '.')
	    *s++ = *st++;
	*s++ = '.';
	if (seperateinit) {
	    s[0] = 'c';
	    s[1] = 0;
	    sprintf(backup, "%s.BAK", outfile);
	    rename(outfile, backup);
	    if ((initfile = fopen(outfile, "w")) == 0) {
		fprintf(stderr, "%s: Can't create %s\n",
			program, outfile);
		exit(0);
	    }
	    fprintf(initfile, "\
/* DO NOT EDIT THIS FILE.  It contains C->PostScript communication\n\
   initializations that were automatically generated from %s */\n\n",
		    filename);
	}
	*s++ = 'h';
	*s++ = 0;
	sprintf(backup, "%s.BAK", outfile);
	rename(outfile, backup);
	if (freopen(outfile, "w", stdout) == 0) {
	    fprintf(stderr, "%s: Can't create %s\n", program, outfile);
	    exit(0);
	}

#ifndef NOHEADER
	printf("\
/* DO NOT EDIT THIS FILE.  It contains C->PostScript communication\n\
   definitions that were automatically generated from %s */\n\n",
	       filename);
#endif
    }
    token = (char *) malloc(tokensize = 100);
    {
	register char *p;
#define setype(str,type) for(p = str; *p; p++) chartype[*p + 1] |= type;
	setype("(", ct_str);
	setype("[]{}%\\", ct_single);
	setype("(,)", ct_plist);
	setype(" \t\n\b\r\f", ct_ignore);
    }
#define settype(type,str) ttab[(int) type] = lookup(str,sizeof str-1);
    settype(t_int, "int");
    settype(t_float, "float");
    settype(t_double, "double");
    settype(t_string, "string");
    settype(t_cstring, "cstring");
    settype(t_postscript, "postscript");
    settype(t_cpostscript, "cpostscript");
    settype(t_fixed, "fixed");
    settype(t_usertoken, "token");
    if (compilemode) {
	register    c;
	if ((c = getchar()) == '#') {
	    do
		putchar(c);
	    while ((c = getchar()) != '\n' && c != EOF);
	    putchar(c);
	}
	else
	    ungetc(c, stdin);
	inprocdef++;
    }
    else {
	keyword("cdef", 0);
	keyword("systok", 1);
	keyword("systoken", 1);
	keyword("usertok", 2);
	keyword("usertoken", 2);
	keyword("C:", 3);
	keyword("=>", 4);
    }
    {
	register char **p;
	for (p = magicnames; *p; p++) {
	    register struct token *t = lookup(*p, strlen(*p));
	    t->kind = k_systok;
	    t->value = sysindex++;
	}
    }
    readfile(mainin);
    if (compilemode) {
	if (psbufused)
	    fwrite(psbuf, psbufused, 1, stdout);
	putchar('\n');
    }
    else {
	closeproc();
	if (adddefs) {
	    register char **init = default_definitions;
	    while (*init)
		puts(*init++);
	}
    }
    if (seperateinit)
	fclose(initfile);
    exit(0);
}

readfile(thisin)
    FILE       *thisin;
{
    if (thisin == 0)
	return;
    input = thisin;
#define syntax() {print_syntax_at(__LINE__);goto restart;}
restart:
    while (gettoken() >= 0) {
	register struct token *t = tokent;
	if (t->param) {
	    switch (t->param) {
	    case t_int:
		addpstr("%d", 2);
		break;
	    case t_fixed:
		addpstr("%e", 2);
		break;
	    case t_float:
		addpstr("%f", 2);
		break;
	    case t_double:
		addpstr("%F", 2);
		break;
	    case t_usertoken:
		addpstr("%u", 2);
		break;
	    case t_string:
		addpstr("%s", 2);
		break;
	    case t_cstring:
		addpstr("%*s", 3);
		break;
	    case t_postscript:
		if (needspace)
		    addpstr(" ", 1);
		addpstr("%p", 2);
		needspace = 1;
		break;
	    case t_cpostscript:
		addpstr("%*p", 3);
		break;
	    }
	    *argtop++ = t;
	    if (t->param != t_postscript)
		needspace = 0;
	}
	else
	    switch (t->kind) {
	    case k_normal:
		if (!inprocdef)
		    syntax();
		if (needspace)
		    addpstr(" ", 1);
		addppstr(token, tokenlen);
		needspace = 1;
		break;
	    case k_keyword:
		switch (t->value) {
		case 0:	/* cdef */
		    closeproc();
		    tokenmask = ct_single | ct_plist;
		    rettop = retlist;
		    ppos = 0;
		    if (gettoken() < 0)
			syntax();
		    {
			int         argindex = 1;
			argtop = arglist;
			t = tokent;
			check_C_name(t);
			thisproc = t;
			printf("#define %.*s(", tokenlen, token);
			if (gettoken() < 0 || token[0] != '(')
			    syntax();
			if (gettoken() < 0)
			    syntax();
			if (token[0] != ')')
			    while (1) {
				register enum p_types type;
				for (type = t_int; (int) type < (int) t_max;
				      type = (enum p_types) ((int) type + 1))
				    if (ttab[(int) type] == tokent)
					break;
				if (type == t_max)
				    type = t_int;
				else if (gettoken() < 0)
				    syntax();
				printf("P__%d", ppos);
				if (type == t_cstring || type == t_cpostscript)
				    printf(",L__%d", ppos);
				tokent->param = type;
				tokent->ppos = ppos++;
				check_C_name(tokent);
				if (gettoken() < 0)
				    syntax();
				if (token[0] == ')')
				    break;
				if (token[0] != ',')
				    syntax();
				printf(",");
				if (gettoken() < 0)
				    syntax();
			    }
			printf(") ");
			inprocdef = 1;
		    }
		    tokenmask = ct_single;
		    break;
		case 1:	/* systok */
		    closeproc();
		    if (gettoken() >= 0) {
			t = lookup(token, tokenlen);
			t->kind = k_systok;
			t->value = sysindex++;
		    }
		    break;
		case 2:	/* usertok */
		    closeproc();
		    if (gettoken() >= 0) {
			check_C_name(t);
			printf("int %.*s_token;\n", tokenlen, token);
			t = lookup(token, tokenlen);
			t->kind = k_usertok;
		    }
		    break;
		case 3:	/* C: */
		    closeproc();
		    {
			register    c;
			register FILE *f = input;
			while ((c = getc(f)) <= ' ');
			while (c != '\n' && c != EOF) {
			    putchar(c);
			    c = getc(f);
			}
			putchar('\n');
			lineno++;
		    }
		    break;
		case 4:	/* => */
		    handle_output_spec();
		}
		break;
	    case k_systok:
		if (t->value < 32)
		    addpch(t->value + enc_syscommon);
		else {
		    addpch(enc_syscommon2);
		    addpch(t->value - 32);
		}
		needspace = 0;
		break;
	    case k_usertok:
		addpstr("%u", 2);
		*argtop++ = t;
		needspace = 0;
		break;
	    case k_string:
		if (tokenlen < 16 + 2)
		    addpch(enc_short_string + tokenlen - 2);
		else {
		    if (tokenlen >= (1 << 8) + 2) {
			if (tokenlen >= (1 << 16) + 2) {
			    addpch(enc_string + 3);
			    addpch((tokenlen - 2) >> 24);
			    addpch((tokenlen - 2) >> 16);
			}
			else
			    addpch(enc_string + 1);
			addpch((tokenlen - 2) >> 8);
		    }
		    else
			addpch(enc_string);
		    addpch(tokenlen - 2);
		}
		addppstr(token + 1, tokenlen - 2);
		needspace = 0;
		break;
	    case k_fract:
		{
		    register    an;
		    register    n = t->value;
		    register    fractbytes = 2 << 2;
		    if ((n & 0377) == 0)
			n >>= 8, fractbytes -= 1 << 2;
		    if ((n & 0377) == 0)
			n >>= 8, fractbytes -= 1 << 2;
		    an = n;
		    if (an < 0)
			an = -an;
		    if (an < 128)
			addpch(enc_int + fractbytes);
		    else {
			if (an < (1 << 15))
			    addpch(enc_int + fractbytes + 1);
			else {
			    if (an < (1 << 23))
				addpch(enc_int + fractbytes + 2);
			    else {
				addpch(enc_int + fractbytes + 3);
				addpch(n >> 24);
			    }
			    addpch(n >> 16);
			}
			addpch(n >> 8);
		    }
		    addpch(n);
		}
		break;
	    }
    }
}

handle_output_spec()
{
    tokenmask = ct_single | ct_plist;
    if (gettoken() < 0) {
Syntax:print_syntax("=>");
	return 0;
    };
    if (tokent->kind == k_fract) {
	packetid = tokent->value >> 16;
	havepacketid = 1;
	if (gettoken() < 0)
	    return 0;
    }
    if (tokent->kind == k_keyword) {
	reusetoken++;
	return 0;
    }
    if (token[0] != '(')
	goto Syntax;
    while (1) {
	if (gettoken() < 0)
	    goto Syntax;
	if (token[0] == ')')
	    break;
	*rettop++ = tokent;
	if (!tokent->param) {
	    fprintf(stderr, "Return value \"%.*s\" should be declared as a parameter at line %d\n",
		    tokenlen, token, lineno);
	    error_seen++;
	}
	if (gettoken() < 0)
	    goto Syntax;
	if (token[0] == ')')
	    break;
	if (token[0] != ',')
	    goto Syntax;
    }
    tokenmask = ct_single;
}

#ifdef SYSVREF

rename(source, target)
	char	*source;
	char	*target;
{
	link(source, target);
	unlink(source);
}

#endif /*SYSVREF */
