%
% This file is a product of Sun Microsystems, Inc. and is provided for
% unrestricted use provided that this legend is included on all tape
% media and as a part of the software program in whole or part.  Users
% may copy or modify this file without charge, but are not authorized to
% license or distribute it to anyone else except as part of a product
% or program developed by the user.
% 
% THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
% WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
% PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
% 
% This file is provided with no support and without any obligation on the
% part of Sun Microsystems, Inc. to assist in its use, correction,
% modification or enhancement.
% 
% SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
% INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
% OR ANY PART THEREOF.
% 
% In no event will Sun Microsystems, Inc. be liable for any lost revenue
% or profits or other special, indirect and consequential damages, even
% if Sun has been advised of the possibility of such damages.
% 
% Sun Microsystems, Inc.
% 2550 Garcia Avenue
% Mountain View, California  94043
%

% CPS PostScript definitions to support clocks.
%
% "@(#)roundclock.cps 9.3 88/01/18
%
% Copyright (c) 1987 by Sun Microsystems, Inc.
%/

cdef ps_createclock()
    /window framebuffer /new DefaultWindow send def
    {
	/IconLabel (Clock) def
	/FixFrame { (F) print } def
	/PaintClient { (P) print } def
	/ShapeFrameCanvas {
	    gsave ParentCanvas setcanvas
	    FrameX FrameY translate
	    FrameWidth FrameHeight scale
	    .5 .5 .5 0 360 arc FrameCanvas setcanvasshape
	    grestore
    	} def
	/ShapeClientCanvas { } def
	/CreateClientCanvas { /ClientCanvas FrameCanvas newcanvas def } def
	/PaintFrame { } def
	/PaintFocus {
	    gsave FrameCanvas setcanvas
	    KeyFocus? {KeyFocusColor} {FrameFillColor} ifelse setcolor
	    calctransform 0 0 40 0 360 arc stroke
	    grestore
	} def
    } window send
    /reshapefromuser window send				% Shape it.
    /map window send  % Map the window. (Damage causes PaintClient to be called)

    window /FrameCanvas get setcanvas
    /calctransform {
	initmatrix initclip
	clippath pathbbox 100 div exch 100 div exch scale pop pop
	50 50 translate
    } def
    /RDC {
	window /FrameCanvas get setcanvas
	damagepath clipcanvas
	calctransform drawclockframe clipcanvas
    } def
    /F {
	/PaintFocus window send
    } def

cdef ps_white() W
cdef ps_black() B
cdef ps_redrawclock() RDC
cdef ps_redrawfocus() F

%
% ps_hand draws a plain clock hand.
%
cdef ps_hand(rot,rad)
    gsave 
    rot rotate 0 0 moveto 0 rad rlineto 
    stroke 
    grestore

%
% ps_fancy_hand draws a fancy clock hand.
%
cdef ps_fancy_hand(rot,rad)
    gsave 
    rot rotate newpath -5 0 moveto 0 0 5 180 360 arc
    0 rad rlineto -5 5 rlineto -5 -5 rlineto closepath
    fill
    grestore

cdef ps_initializeclock()
    /drawclockframe { 
	bordercolor setcolor clippath fill
	0 0 45 0 360 arc
	backgroundcolor setcolor fill
	textcolor setcolor
	12 {0 40 moveto 0 5 rlineto stroke 30 rotate} repeat
    } def
    /B {
	textcolor setcolor
    } def
    /W {
	backgroundcolor setcolor
    } def


cdef ps_fancy_initializeclock()
    /drawclockframe {
	.75 monochromecanvas {setgray} {.7 .7 setrgbcolor} ifelse fill
	clippath fill
	0 0 40 0 360 arc
	1 monochromecanvas {setgray} {1 1 setrgbcolor} ifelse fill
	1 monochromecanvas {setgray} {1 0 setrgbcolor} ifelse fill
	0 45 5 0 360 arc fill
    } def
    /B {
	.5 monochromecanvas {setgray} {.6 1 setrgbcolor} ifelse fill
    } def
    /W {
	1 monochromecanvas {setgray} {1 1 setrgbcolor} ifelse fill
    } def
