/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char sccsid[] = "@(#)psman.c 9.4 88/01/18 Copyright 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*-
	Display a section from the manual

	psman.c, Sun Jul 26 07:36:32 1987

 */

#include <stdio.h>
#include <sys/types.h>
#ifdef REF
#include <ref/config.h>
#endif
#ifdef SYSVREF
#include <dirent.h>
#else
#include <sys/dir.h>
#endif
#include <sys/stat.h>

char       *ProgramName;
int         chapter;
char       *section;
int         seclen;
int         verbose;
char       *manpath;
char       *newsserver;
char       *altprefix;
extern char *getenv();
char        kflag;
char       *klist[40];
char      **kend = klist;

trypath(testdir, alt)
    char       *testdir,
               *alt;
{
    DIR        *dir;
    char        mandirs[10];
#ifdef SYSVREF
    register struct dirent *d;
#else
    register struct direct *d;
#endif
    register    i;
    if (kflag) {
	register struct stat st;
	*kend = (char *) malloc(strlen(testdir) + 8);
	sprintf(*kend, "%s/whatis", testdir);
	if (stat(*kend, &st) >= 0)
	    kend++;
	return;
    }
    bzero(mandirs, sizeof mandirs);
    if (testdir == 0 || *testdir == 0)
	testdir = ".";
    if (verbose)
	printf(" Trying %s\n", testdir);
    if ((dir = opendir(testdir)) == 0)
	return;
    while (d = readdir(dir)) {
#ifdef SYSVREF
	if (strlen(d->d_name) >= seclen + 2 && d->d_name[seclen] == '.'
		&& d->d_name[0] == section[0])
#else
	if (d->d_namlen >= seclen + 2 && d->d_name[seclen] == '.'
		&& d->d_name[0] == section[0])
#endif
	{
	    char        altname[200],
	                altdir[200],
	                fullname[200];
	    int         do_unlink = 0;
	    int         flag;
	    struct stat st;
	    if (strncmp(section, d->d_name, seclen) != 0)
		continue;
	    if (chapter && chapter + '0' != d->d_name[seclen + 1])
		continue;
#ifdef SYSVREF
	    sprintf(fullname, "%s/%.*s", testdir, strlen(d->d_name), d->d_name);
#else
	    sprintf(fullname, "%s/%.*s", testdir, d->d_namlen, d->d_name);
#endif
	    if (verbose)
		printf("Bingo!  %s\n", fullname);
	    umask(0);
	    if (alt == 0)
		sprintf(alt = altdir, "%s/%s", testdir, altprefix);
#ifdef SYSVREF
	    sprintf(altname, "%s/%.*s", alt, strlen(d->d_name), d->d_name);
#else
	    sprintf(altname, "%s/%.*s", alt, d->d_namlen, d->d_name);
#endif
	    if (stat(altname, &st) >= 0) {
		if (verbose)
		    printf("  Found alternate %s\n", altname);
	    }
	    else {
		register    fd = creat(altname, 0666);
		if (fd < 0) {
		    mkdir(alt, 0777);
		    fd = creat(altname, 0666);
		    if (fd < 0) {
			sprintf(altname, "/tmp/man.%d", getpid());
			do_unlink++;
			fd = creat(altname, 0666);
			if (fd < 0) {
			    fprintf(stderr, "%s: Can't create temp file %s\n",
				    ProgramName, altname);
			    exit(0);
			}
		    }
		    else if (verbose)
			printf("  Made directory %s\n", alt);
		}
		if (verbose)
		    printf("  Building alternate in %s\n", altname);
		if (newsserver) {
		    int         pfd[2];
		    if (pipe(pfd) < 0) {
			perror("pipe1");
			exit(0);
		    }
#ifdef SYSVREF
		    if (fork() == 0)
#else
		    if (vfork() == 0)
#endif
		    {
			dup2(pfd[1], 1);
			close(pfd[0]);
			close(pfd[1]);
			execl("/usr/doctools/bin/ditroff", "ditroff", "-Tpsc", "-man", fullname, 0);
			execlp("ditroff", "ditroff", "-Tpsc", "-man", fullname, 0);
			write(2, "no ditroff\n", 11);
			exit(0);
		    }
#ifdef SYSVREF
		    if (fork() == 0)
#else
		    if (vfork() == 0)
#endif
		    {
			dup2(pfd[0], 0);
			close(pfd[0]);
			close(pfd[1]);
			dup2(fd, 1);
			execl("/usr/doctools/bin/psdit", "psdit", 0);
			execlp("psdit", "psdit", fullname, 0);
			write(2, "no psdit\n", 9);
			exit(0);
		    }
		    fprintf(stderr, "[ Please be patient, troff is reformatting the manual entry ]\n");
		    close(pfd[0]);
		    close(pfd[1]);
		}
		else {
#ifdef SYSVREF
		    if (fork() == 0)
#else
		    if (vfork() == 0)
#endif
		    {
			dup2(fd, 1);
			close(fd);
			execlp("nroff", "nroff", "-man", fullname, 0);
			write(2, "no nroff\n", 9);
			exit(-1);
		    }
		}
	    }
	    while (wait(&flag) >= 0);
	    if (newsserver) {
#ifdef SYSVREF
		if (fork() == 0)
#else
		if (vfork() == 0)
#endif
		{
		    execlp("psview", "psview", altname, 0);
		    write(2, "no psview\n", 10);
		    exit(-1);
		}
		if (do_unlink)
		    while (wait(&flag) >= 0);
	    }
	    else {
#ifdef SYSVREF
		if (fork() == 0)
#else
		if (vfork() == 0)
#endif
		{
#ifdef SYSVREF
		    execlp("pg", "pg", altname, 0);
		    write(2, "no pg\n", 6);
#else
		    execlp("more", "more", altname, 0);
		    write(2, "no more\n", 8);
#endif
		    exit(-1);
		}
		while (wait(&flag) >= 0);
	    }
	    if (do_unlink)
		unlink(altname);
	    exit(0);
	}
#ifdef SYSVREF
	if (strlen(d->d_name) == 4
#else
	if (d->d_namlen == 4
#endif
		&& '0' <= d->d_name[3] && d->d_name[3] <= '9'
		&& (chapter == 0 || d->d_name[3] == chapter + '0')
		&& d->d_name[0] == 'm'
		&& d->d_name[1] == 'a'
		&& d->d_name[2] == 'n')
	    mandirs[d->d_name[3] - '0'] = 1;
    }
    closedir(dir);
    for (i = 1; i < 10; i++)
	if (mandirs[i]) {
	    char        buf[100];
	    char        altbuf[100];
	    sprintf(buf, "%s/man%d", testdir, i);
	    sprintf(altbuf, "%s/%s%d", testdir, altprefix, i);
	    trypath(buf, altbuf);
	}
}

main(argc, argv)
    char      **argv;
{
    manpath = getenv("MANPATH");
    newsserver = getenv("NEWSSERVER");
    altprefix = newsserver ? "fmt" : "cat";
    ProgramName = argv[0];
    while (--argc > 0)
	if ((++argv)[0][0] == '-')
	    switch (argv[0][1]) {
	    case 'd':
		if (argv[0][2])
		    manpath = &argv[0][2];
		else {
		    manpath = *++argv;
		    argc--;
		}
		break;
	    case 'k':
		kflag++;
		break;
	    case 'v':
		verbose++;
		break;
	    default:
		fprintf(stderr, "%s: Illegal switch `%s'\n", ProgramName, argv[0]);
		exit(-1);
		break;
	    }
	else if ('1' <= argv[0][0] && argv[0][0] <= '9')
	    chapter = argv[0][0] - '0';
	else if (section)
	    fprintf(stderr, "%s: Ignoring `%s'\n", ProgramName, argv[0]);
	else
	    section = argv[0];
    if (section == 0)
	section = "man";
    if (kflag) {
	*kend++ = "grep";
	*kend++ = "-y";
	*kend++ = section;
    }
    if (manpath == 0) {
	static char buf[200];
	register char *newshome = getenv("NEWSHOME");
	sprintf(buf, "%s/man:/usr/man", newshome ? newshome : "/usr/NeWS");
	manpath = buf;
    }
    if (verbose)
	printf("manpath='%s'\n", manpath);
    seclen = strlen(section);
    {
	register char *st,
	           *p;
	st = manpath;
	while (*st) {
	    p = st;
	    while (*p && *p != ':')
		p++;
	    if (*p == 0) {
		trypath(st, 0);
		break;
	    }
	    *p = 0;
	    trypath(st, 0);
	    st = p + 1;
	}
    }
    if (kflag && kend > klist + 3) {
	*kend = 0;
	execvp("grep", klist);
    }
    fprintf(stderr, "%s: No documentation found for %s", ProgramName, section);
    if (chapter)
	fprintf(stderr, " in chapter %d", chapter);
    fprintf(stderr, "\n");
}
