/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape media
 * and as a part of the software program in whole or part.  Users may copy or
 * modify this file without charge, but are not authorized to license or
 * distribute it to anyone else except as part of a product or program
 * developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
 * OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the part
 * of Sun Microsystems, Inc. to assist in its use, correction, modification or
 * enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE OR
 * ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue or
 * profits or other special, indirect and consequential damages, even if Sun
 * has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc. 2550 Garcia Avenue Mountain View, California  94043
 */

#ifndef lint
static char sccsid[] = "@(#)psload.c	9.4  1/18/88";
#endif

#include <sys/param.h>
#ifndef SYSVREF
#include <sys/time.h>
#endif
#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
#ifdef SYSVREF
#include <sys/sysinfo.h>
#include <stropts.h>
#include <poll.h>
#include <time.h>
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include <errno.h>
#include <nlist.h>
#include <stdio.h>
#include <psio.h>

#include "psload.h"

#ifdef SYSVREF
#define L_SET	0
#endif

#ifdef SYSVREF
/*
 * The following is only true for System V.3 on the Intel 80386.
 * the name of this variable may need to be different for other
 * implementations. "_sysinfo" is often used.
 */
struct nlist nl[] = {{"sysinfo"}, 0};
#else
struct nlist nl[] = {{"_avenrun"}, 0};
#endif

#define	MINHISTORY	60
int         history = 600;	/* 10 minutes worth of info */
int         kmem = -1;
int         nloads;
float      *loads;
#define	MINUPDATE	5
int         update = MINUPDATE;
extern int  errno;
extern double atof();

main(argc, argv)
    char       *argv[];
{
    char       *cp,
                buf[1024],
                hostname[32],
                title[50];
#ifdef SYSVREF
    int			tv;
    struct pollfd	rmask[1];
#else
    struct timeval tv;
    int         rmask;
#endif
    int         n,
                i,
                middle;

#ifdef SYSVREF
    struct sysinfo	systeminfo;
#else /* SYSVREF */
#ifdef sun
    int         avenrun[1];
#else
    double      avenrun[1];
#endif
#endif /* SYSVREF */
    float       v,
                curload;

    argc--, argv++;
    while (argc > 0 && argv[0][0] == '-') {
	for (cp = &argv[0][1]; *cp; cp++)
	    switch (*cp) {

	    case 'u':
		argc--, argv++;
		if (argc < 1) {
		    fprintf(stderr, "-u: Missing update interval.\n");
		    exit(-1);
		}
		v = atof(argv[0]);
		update = v * 60;
		if (update < MINUPDATE)
		    update = MINUPDATE;
		goto next;

	    case 'h':
		argc--, argv++;
		if (argc < 1) {
		    fprintf(stderr, "-h: Missing history time.\n");
		    exit(-1);
		}
		v = atof(argv[0]);
		history = v * 60;
		if (history < MINHISTORY)
		    history = MINHISTORY;
		goto next;

	    default:
		fprintf(stderr,
			"usage: load [-u update] [-h history]\n");
		exit(-1);
	    }
next:
	argc--, argv++;
    }
#ifdef SYSVREF
    nlist("/unix", nl);
    if (nl[0].n_value == 0) {
	fprintf(stderr, "/unix namelist botch\n");
	exit(-1);
    }
#else
    nlist("/vmunix", nl);
    if (nl[0].n_value == 0) {
	fprintf(stderr, "/vmunix namelist botch\n");
	exit(-1);
    }
#endif
    kmem = open("/dev/kmem", O_RDONLY);
    if (kmem < 0) {
	perror("/dev/kmem");
	exit(-1);
    }
    if (ps_open_PostScript() == 0) {
	fprintf(stderr, "No window manager.\n");
	exit(-1);
    }
    gethostname(hostname, sizeof(hostname));
    sprintf(title, "%s's load average", hostname);
    nloads = history / update;
    middle = nloads / 2;
    loads = (float *) malloc(nloads * sizeof(float));
    CreateLoadWindow(nloads, title);
    i = 0;
    for (;;) {
	(void) lseek(kmem, (long) nl[0].n_value, L_SET);
#ifdef SYSVREF
	(void) read(kmem, (char *) &systeminfo, sizeof(systeminfo));
#else
	(void) read(kmem, (char *) avenrun, sizeof(avenrun));
#endif

#ifdef SYSVREF
#define FSHIFT	8
#define FSCALE	(1<<FSHIFT)
#define EXP	(92*FSCALE/100)
	{
		static unsigned	orunque = 0;
		static time_t	otime = 0;
		time_t		now;
		static long	avg;
	
		now = time(0);
		if (((otime + 5000) >= now) || otime == 0)
		{
		     	if (orunque == 0)
				orunque = systeminfo.runque;
			otime = time(0);
			avg = (long) (EXP * avg + 
				(systeminfo.runque - orunque) * FSCALE *
				(FSCALE - EXP)) >> FSHIFT;
			orunque = systeminfo.runque;
		}
		curload = (float) avg / FSCALE;
	}
#else /* SYSVREF */
#ifdef sun
	curload = (float) avenrun[0] / FSCALE;
#else
	curload = avenrun[0];
#endif
#endif /* SYSVREF */

	loads[i] = curload;
	if (i == nloads) {
	    bcopy(&loads[middle], &loads[0], (i = nloads - middle + 1) * sizeof(float));
	    RedrawScreen(i);
	}
	else
{
	    DrawLoadValue(i++, curload);
}
	ps_flush_PostScript();
#ifdef SYSVREF
	rmask[0].fd = psio_fileno(PostScriptInput);
	rmask[0].events = POLLIN;
	tv = update * 1000;
	if (poll(rmask, 1, tv) > 0)
#else
	rmask = 1 << psio_fileno(PostScriptInput);
	tv.tv_sec = update, tv.tv_usec = 0;
	if (select(32, &rmask, 0, 0, &tv) > 0)
#endif
	{
	    n = read(psio_fileno(PostScriptInput), buf, sizeof(buf));
	    if (n <= 0) {
		if (n < 0) {
		    if (errno == EINTR)
			continue;
		    perror("read");
		}
		break;
	    }
	    RedrawScreen(i);
	}
    }
}

RedrawScreen(last)
    int         last;
{
    register float max;
    register int i;

    max = 1;
    for (i = 0; i < last; i++)
	if (loads[i] > max)
	    max = loads[i];
    ResetScale(max);
    for (i = 0; i < last; i++)
	DrawMidLoadValue(i, loads[i]);
    FinishLoad(i - 1);
}
