c       .data
c       .asciz  "@(#)FSlog10s.fs 1.1 86/09/25 Copyr 1985 Sun Micro"
c       .even
c       .text

c       Copyright (c) 1985 by Sun Microsystems, Inc.

	real*4 function FSlog10s ( x )
	real*4 x
	
	real *4 xs, FFscales
	integer e, ixs, FFexpos
	equivalence (xs, ixs)
	real*4 log102a, log102b, log10e, log2e, half
	integer sqrt2, sqrthalf, zero
	parameter (log102a = 3.010330200195312500e-1)
	parameter (log102b =-3.024355550054801459e-6)
	parameter (log10e  = 0.43429 44819 03251 82765 e0)
	parameter (log2e   = 1.44269 50408 88963 40735 e0)
	parameter (half    = 0.5                       e0)
	data sqrt2   / x'3f b5 04 f3' /
	data sqrthalf/ x'3f 35 04 f3' /
	data zero    / x'00 00 00 00' /
	
	e = FFexpos(x)
	xs = FFscales( x, -e )
	if (ixs .gt. sqrt2) then
		xs = half * xs
		e = e + 1
	else if (ixs .lt. sqrthalf) then
		if (ixs .gt. zero) then
 1			continue
			xs = xs + xs
			e = e - 1
			if (ixs .lt. sqrthalf) goto 1
		endif
	endif	
	FSlog10s = log102a * e + (log102b * e + log10e * log(xs))
	end

	real*4 function FSlog2s ( x )
	real*4 x
	
	real *4 xs, FFscales
	integer e, ixs, FFexpos
	equivalence (xs, ixs)
	real*4 log102a, log102b, log10e, log2e, half
	integer sqrt2, sqrthalf, zero
	parameter (log102a = 3.010330200195312500e-1)
	parameter (log102b =-3.024355550054801459e-6)
	parameter (log10e  = 0.43429 44819 03251 82765 e0)
	parameter (log2e   = 1.44269 50408 88963 40735 e0)
	parameter (half    = 0.5                       e0)
	data sqrt2   / x'3f b5 04 f3' /
	data sqrthalf/ x'3f 35 04 f3' /
	data zero    / x'00 00 00 00' /
	
	e = FFexpos(x)
	xs = FFscales( x, -e )
	if (ixs .gt. sqrt2) then
		xs = half * xs
		e = e + 1
	else if (ixs .lt. sqrthalf) then
		if (ixs .gt. zero) then
 1			continue
			xs = xs + xs
			e = e - 1
			if (ixs .lt. sqrthalf) goto 1
		endif
	endif	
	FSlog2s = e + log2e * log(xs)
	end
