#ifndef lint
static  char sccsid[] = "@(#)if_ie.c 1.3 86/12/19 Copyr 1986 Sun Micro";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

/*
 * Sun Intel Ethernet Controller interface
 */

/* Conditional compilation symbol for debugging: */
/* #define	DEBUGIE	*/

/*
 * Controls whether ether header lives in tfd/rfd or in start
 * of mbuf chain/buffer for packet.  Current thinking is that it's
 * more efficient to keep it in the mbuf chain, as this
 * conforms to assumptions made elsewhere about data placement
 * in the first mbuf and thus lets ether_pullup avoid allocating
 * a fresh mbuf when transmitting.
 */
/* #define	IE_FDADDR */

#include "ie.h"
#if	NIE > 0

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mbuf.h"
#include "../h/buf.h"
#include "../h/map.h"
#include "../h/socket.h"
#include "../h/vmmac.h"
#include "../h/errno.h"
#include "../machine/pte.h"

#include "../h/time.h"
#include "../h/kernel.h"
#include "../h/ioctl.h"

#include "../net/if.h"
#include "../netinet/in.h"
#include "../netinet/if_ether.h"

#include "../sundev/mbvar.h"
#include "../sunif/if_iereg.h"
#include "../sunif/if_mie.h"
#include "../sunif/if_obie.h"
#include "../sunif/if_ievar.h"

/*
 * Notes on the driver's data structures
 * (see also definitions in if_ievar.h)
 *
 * Transmit Buffer Descriptor (tbd) organization:
 *	Tbds are configured as a ring carved out of a contiguous chunk
 *	of the control block map.  The ring contains two regions, the
 *	set of descriptors currently in use and the set of free descriptors.
 *	The driver maintains pointers to the start of these two regions
 *	(respectively, es_utbd and es_ftbd).  The routine iexmitdone
 *	reclaims in-use tbds, converting them back into free tbds, and
 *	ietbdget does the opposite.  Both routines treat the descriptor
 *	ring as a pair of queues, with tbds moving from the front of one
 *	queue to the end of the other.
 *
 *	The organization above has the property that link fields are
 *	never changed once they've been initialized.  The only operation
 *	on them is to move to the next tbd.  This property allows the
 *	time optimization of adding a ietbd_link field that's redundant
 *	with the chip-recognized ietbd_next field, but that is a regular
 *	pointer instead of an offset from the chip's memory base.  The
 *	driver can move to the next descriptor more quickly using this
 *	field.
 *
 *	The tbd ring is allocated in ieinitmem, which calls ie_tbdinit
 *	to do the actual work.
 *
 * Transmit Frame Descriptor (tfd) organization:
 *	Tfds are configured as a pool with free descriptors chained
 *	into a free list through the ietfd_flink field.  As with tbds
 *	and tbufs, the routines iestartout and iexmitdone respectively
 *	consume and free tfds.
 *
 *	Tfds can almost be organized into a ring in the same way tbds
 *	are.  The sticking point is that other command block types
 *	can (and do) intervene between consecutive tfds, the culprits
 *	being the no-op commands generated by iedog.
 *
 *	Tfds are allocated in ieinitmem, which calls ie_tbdinit to do
 *	the actual work.
 *
 * Transmit Buffer (tbuf) organization:
 *	Wherever possible the driver tries to transmit directly from the
 *	mbufs constituting an output packet.  However, this isn't always
 *	possible, so the driver uses tbufs to hold non-mbuf packet data.
 *	Each tbuf is large enough to hold a complete packet and, when in
 *	use, contains a complete trailing packet suffix -- that is, all
 *	of the packet from some point on.  Thus, there's at most one tbuf
 *	per outgoing packet.  Free tbufs are chained together into a free
 *	list rooted at es_tbuf_free.  When a tbuf is in use, it's referenced
 *	from two places, the last tbd of the corresponding packet chain
 *	and from the packet's tfd.  The tfd reference is redundant, but
 *	convenient for reclaiming the tbuf when transmission is complete
 *	or requeueing is required.
 *
 *	Tbufs are allocated in ieinitmem, which calls ie_tbufinit to do
 *	the actual work.
 *
 * Receive Buffer Descriptor (rbd) organization:
 *	Rbds are organized into a ring containing an embedded list that
 *	completely fills the ring.  The list itself has two halves.  The
 *	front half contains rbds that the chip has filled from incoming
 *	packets, but that the driver has not yet processed.  The back half
 *	contains empty rbds that the chip has not yet filled.  The list
 *	head always points to the next rbd the driver is to process.  The
 *	chip keeps track of the start of the back half of the list; the
 *	driver maintains no explicit record of its location, but can
 *	determine that it has reached it by discovering an rbd with its
 *	ierbd_used field cleared.
 *
 * Receive Frame Descriptor (rfd) organization:
 *	Rfds are organized completely analogously to rbds.
 *
 * Receive Buffer (rbuf) organization:
 *	Receive buffers can be in one of three states:
 *		free:		inactive and available for use
 *		attached:	awaiting packet reception and visible to
 *				the chip as a packet receptacle
 *		loaned:		contains packet data that is being processed
 *				by the higher-level protocol code
 *	Free rbufs are chained together through their ierbuf_next fields
 *	into a free list rooted at es_rbuf_free.  Attached rbufs can be
 *	found only by working back from the descriptors in the rbd ring.
 *	Loaned buffers can be detected only by virtue of their not being
 *	in either of the other two states.  However, we do maintain a
 *	count of loaned rbufs in es_loaned, so that we can tell whether
 *	or not it's safe to reallocate driver memory.
 *
 *	Note that driver memory can be (re)allocated only when no rbufs
 *	are on loan.
 */

/*
 * Controller types
 */
#define IE_MB	1	/* Multibus (possibly embedded in VME) */
#define IE_OB	2	/* On main CPU board ("On-Board") */

/*
 * Delay values
 */
#define IEDELAY		400000	/* delay period (in us) before giving up */
#define IEKLUDGE	    20	/* delay period (in us) to make chip work */


int	ieprobe(), ieattach(), iepoll();
struct	mb_device *ieinfo[NIE];
struct	mb_driver iedriver = {
	ieprobe, 0, ieattach, 0, 0, iepoll,
	/* take the larger of the two devices */
	sizeof (struct mie_device), "ie", ieinfo,
};

int		ieinit(), ieioctl(), ieoutput(), iereset();
int		iebark(), iedog();
int		ieclfree();
long		iecalcmem();
struct mbuf	*copy_to_mbufs(), *mclgetx(), *ether_pullup();
struct ietbd	*ietbdget();
caddr_t		from_ieaddr();
caddr_t		from_ieoff();
ieaddr_t	to_ieaddr();
ieaddr_t	to_ieaddr_opt();
ieoff_t		to_ieoff();
ieint_t		to_ieint();
#define from_ieint	to_ieint


/*
 * Ethernet software status per interface.
 */
struct ie_softc	ie_softc[NIE];


/*
 * Allocation constant for on board memory
 *	There must be at least two pages worth, so that we have
 *	a complete page.  (This page is doubly mapped to hold the
 *	SCP -- see iegetmem.)  The amount desired is determined
 *	in iecalcmem, based on the resource amounts given just
 *	below.
 */
#define IE_MEMMIN	(2*NBPG)

/*
 * Intial values for resource allocation (patchable).
 *
 * XXX:	Refine these values -- they seem reasonably good
 *	as they stand, but could stand further polishing.
 */
int	ie_tbds  = 16;	/* Generous, but they're cheap */
int	ie_tfds  =  5;	/* Ditto */
int	ie_tbufs =  3;	/* Probably too many */
int	ie_rbds  = 10;	/* 11 quite adequate except possibly for promisc. */
int	ie_rfds  =  9;	/* Must be < ie_rbds to avoid suspected chip bug. */
int	ie_rbufs = 25;	/* Must be >= ie_rbds */

/*
 * Patchable variable -- set this to 1 to enable retransmission
 * after the chip detects a failed packet transmission attempt.
 */
int	ie_retransmit = 1;


/*
 * Resource map for chip-visible memory.
 *	We allocate 11 things in this map, one of which (the SCP)
 *	is pinned at a specific address.  See ie{get,init}mem.
 *	However, since we never release storage without reallocating
 *	everything, and since rmalloc uses first fit, we never
 *	consume more than two map slots in addition to the slots
 *	used by the mapping routines themselves.
 */
#define 	IERMAPSIZE	5	/* 1 extra just to be safe */
struct map	iermap[NIE][IERMAPSIZE];

/*
 * Reserve and release the statically allocated CB for synchronously
 * executed commands.  Note that the space allocated for es_cbsync must
 * be large enough to hold the largest CB type synccb_res is called with.
 *	Once we're completely certain that calls to iesynccmd
 *	can't/don't nest, eliminate the counter manipulation.
 */
#ifdef	DEBUGIE
#define synccb_res(es, t) \
			((es)->es_synccmd ? (t)0 : \
				((es)->es_synccmd = 1, (t)(es)->es_cbsync))
#define synccb_rel(es)	((es)->es_synccmd = 0)
#else	DEBUGIE
#define synccb_res(es, t) \
			((t)(es)->es_cbsync)
#define synccb_rel(es)
#endif	DEBUGIE


#ifdef	DEBUGIE
/*
 * Verify that X is within the range reachable
 * from es->es_base by a 16-bit chip offset.
 */
#define	ie_chkbounds(X) \
{ \
	caddr_t	y = (caddr_t)(X); \
\
	if (y < es->es_base || y > es->es_base + 0xffff) { \
		identify(&es->es_if); \
		printf("X"); \
		printf(" at %x: not addressible (base at %x)\n", \
			y, es->es_base); \
		panic("rmalloc botch"); \
	} \
}
#endif	DEBUGIE


/*
 * Probe for device.
 */
ieprobe(reg, unit)
	caddr_t	reg;
	int	unit;
{
	register struct ie_softc *es = &ie_softc[unit];

	if ((getkpgmap(reg) & PGT_MASK) == PGT_OBIO) {
		register struct obie_device *obie = (struct obie_device *)reg;

		/* onboard Ethernet */
		if (pokec(reg, 0))
			return (0);
		if (peekc(reg) == -1)
			return (0);
		if (obie->obie_noreset)
			return (0);
		es->es_type = IE_OB;
	} else {
		register struct mie_device *mie = (struct mie_device *)reg;
		register short *sp;

		/* Multibus Ethernet */
		sp = (short *)mie;
		if (poke(sp, 0))
			return (0);
		sp = &mie->mie_prom[0];
		if (poke(sp, 0x6789))
			return (0);
		if (peek(sp) == 0x6789)
			return (0);
		es->es_type = IE_MB;
	} 
	return (1);
}

/*
 * Interface exists; make available by filling in network interface
 * record.  System will initialize the interface when it is ready
 * to accept packets.
 */
ieattach(md)
	struct mb_device *md;
{
	struct ie_softc *es = &ie_softc[md->md_unit];

#ifdef	DEBUGIE
	printf("DEBUGIE: debugging on\n");
#endif	DEBUGIE

	/* Set up vectored interrupts. */
	if (md->md_intr)
		*(md->md_intr->v_vptr) = (int)es;

	/* Set minimum memory consumption. */
	es->es_memsize = IE_MEMMIN;

	/* Record chip address. */
	if (es->es_type == IE_OB)
		es->es_obie = (struct obie_device *)md->md_addr;
	else
		es->es_mie = (struct mie_device *)md->md_addr;

	iechipreset(es);
	(void) localetheraddr((struct ether_addr *)0, &es->es_enaddr);

	/*
	 * Do hardware-independent attach stuff.
	 */
	ether_attach(&es->es_if, md->md_unit,
		     "ie", ieinit, ieioctl, ieoutput, iereset);
}

/*
 * Reset interface following a system reset.
 */
iereset(unit)
	int unit;
{
	register struct mb_device *md;

	if (unit >= NIE || (md = ieinfo[unit]) == 0 || md->md_alive == 0)
		return;
	printf("reset ie%d", unit);
	ieinit(unit);
}

/*
 * Unconditionally restart the interface from ground zero.
 * If the driver's memory resources haven't yet been allocated,
 * do it here.
 */
ieinit(unit)
	int unit;
{
	struct ie_softc *es = &ie_softc[unit];
	register struct ifnet *ifp = &es->es_if;
	register struct mbuf *m;
	int s = splie();

	iechipreset(es);
	untimeout(iebark, (caddr_t)es);
	untimeout(iedog, (caddr_t)es);
	es->es_if.if_flags &= ~(IFF_UP|IFF_RUNNING|IFF_PROMISC);

	/*
	 * Drain the output queue, against the possibility that
	 * something has occurred to invalidate the packets in it
	 * (such as our Ethernet address changing).
	 */
	while (es->es_if.if_snd.ifq_head) {
		IF_DEQUEUE(&es->es_if.if_snd, m);
#ifdef	DEBUGIE
		iechkmbuf(m);
#endif	DEBUGIE
		m_freem(m);
	}

	if (!address_known(ifp))
		goto exit;

	/*
	 * If we haven't yet allocated memory resources,
	 * grab them now.  Note that the SIOCSIFMEM ioctl
	 * may release resources, causing reallocation here.
	 */
	if (!es->es_base) {
		int msize = iecalcmem(es, ie_tbds, ie_tfds, ie_tbufs, ie_rbds,
			ie_rfds, ie_rbufs);

		if (msize > es->es_memsize)
			es->es_memsize = msize;
		iegetmem(es);
		ieinitmem(es);
	}

	es->es_cbhead = NULL;

	if (!iechipinit(es))
		goto exit;
	iedoaddr(es);
	/* XXX: should check with DUMP */

	/*
	 * Hang out receive buffers and start any pending writes.
	 */
	es->es_if.if_flags |= IFF_UP|IFF_RUNNING;
	ierustart(es);
	iesplice(es);
	iestartout(unit);
	route_arp(ifp, &es->es_ac);
	timeout(iedog, (caddr_t)es, 10*hz);
	es->es_latest.tv_sec = time.tv_sec;
exit:
	(void) splx(s);
}

/*
 * Unresponsive chip alarm. Scheduled by iedog; chip has some number
 * of seconds to execute a nop, else alarm goes off.
 */
iebark(es)
	struct ie_softc *es;
{
	int unit = es - ie_softc;

	identify(&es->es_if);
	printf("iebark reset\n");
#ifdef	DEBUGIE
	ieprt();
#endif	DEBUGIE
	ieinit(unit);
}

/*
 * Watchdog (deadman) timer routine, invoked every 10 seconds.
 */
iedog(es)
	register struct ie_softc	*es;
{
	register int		unit = es - ie_softc;
	register int		s = splie();
	register struct iecb	*cb = es->es_cbnop;
	int			fatal = 0;

	/* poll for bus error on obie */
	if (es->es_type == IE_OB)
		if (es->es_obie->obie_buserr) {
			identify(&es->es_if);
			printf("obie buserr reset\n");
			fatal = 1;
			goto reset;
		}

	/*
	 * Ensure cu ok with a nop.
	 */
	bzero((caddr_t)cb, sizeof (struct iecb));
	cb->iec_cmd = IE_NOP;
	iedocb(es, cb);
	iecustart(es);
	/* some number of seconds delay before iebark */
	timeout(iebark, (caddr_t)es, 4*hz);

	/* ensure ru ok with recent reception */
	if (es->es_latest.tv_sec + 90 < time.tv_sec) {
		/* restart timeout period */
		es->es_latest.tv_sec = time.tv_sec;
		goto reset;
	}

	timeout(iedog, (caddr_t)es, 10*hz);
	goto exit;

reset:
	es->es_dogreset++;
	ieinit(unit);
	if (fatal) {
		identify(&es->es_if);
		panic("iedog");
	}

exit:
	(void) splx(s);
}

/*
 * Handle polling Ethernet interrupts
 */
iepoll()
{
	register struct ie_softc *es;
	register int found = 0;

	for (es = ie_softc; es < &ie_softc[NIE]; es++) {
		switch (es->es_type) {
		case IE_MB:
			if (es->es_mie->mie_pie && es->es_mie->mie_pe) {
				ieparity(es);
				return (1);
			}
			if (es->es_mie->mie_ie == 0)
				continue;
			if (es->es_mie->mie_intr)
				found = 1;
			break;
		case IE_OB:
			if (es->es_obie->obie_buserr) {
				identify(&es->es_if);
				panic("bus error");
			}
			if (es->es_obie->obie_ie == 0)
				continue;
			if (es->es_obie->obie_intr)
				found = 1;
			break;
		default:	/* not present */
			continue;
		}
		/*
		 * Since the 82586 can take away an interrupt
		 * request after presenting it to the processsor
		 * (to facilitate an update of a new interrupt
		 * condition in the scb), we also have to check
		 * the scb to see if it indicates an interrupt
		 * condition from the chip.
		 */
		if (found == 0) {
			register struct iescb *scb = es->es_scb;

			if (scb->ie_cx || scb->ie_fr ||
			    scb->ie_cnr || scb->ie_rnr)
				found = 1;
		}
		if (found) {
			ieintr(es);
			break;
		}
	}
	return (found);
}

/*
 * Handle Ethernet interrupts
 */
ieintr(es)
	register struct ie_softc *es;
{
	register struct iescb *scb;
	register int cmd, unit;

	unit = es - ie_softc;
	scb = es->es_scb;
	iechkcca(es);
	if (scb->ie_cmd != 0)  {
		identify(&es->es_if);
		printf("lost sync\n");
		iestat(es);
		iereset(unit);
		return;
	}

	/*
	 * This can be done faster with something like:
	 * cmd = (scb->ie_status) &
	 *	    (IECMD_ACK_CX|IECMD_ACK_FR|IECMD_ACK_CNR|IECMD_ACK_RNR);
	 */
	cmd = 0;
	if (scb->ie_cx)
		cmd |= IECMD_ACK_CX;
	if (scb->ie_fr)
		cmd |= IECMD_ACK_FR;
	if (scb->ie_cnr)
		cmd |= IECMD_ACK_CNR;
	if (scb->ie_rnr)
		cmd |= IECMD_ACK_RNR;

	if (cmd == 0) {
		identify(&es->es_if);
		printf("spurious interrupt\n");
		cmd = IECMD_ACK_CX+IECMD_ACK_FR+IECMD_ACK_CNR+IECMD_ACK_RNR;
	}
	scb->ie_cmd = cmd;
	ieca(es);

	/* if interface is not just right, avoid touching cbs */
	if ((es->es_if.if_flags&(IFF_UP|IFF_RUNNING)) != (IFF_UP|IFF_RUNNING))
		return;

	if (cmd & (IECMD_ACK_RNR|IECMD_ACK_FR))
		ierecv(es);

	if (cmd & (IECMD_ACK_CNR|IECMD_ACK_CX))
		iecbdone(es);
	else if (es->es_cbhead == NULL && es->es_if.if_snd.ifq_head) {
		identify(&es->es_if);
		printf("lost interrupt: resetting\n");
		/*
		 * Experience shows that proceeding normally doesn't
		 * suffice, so hit the chip with a hammer.
		 */
		ieinit(unit);
	}

	if (es->es_cbhead && scb->ie_cus == IECUS_IDLE) {
		iechkcca(es);
		if (es->es_cbhead && scb->ie_cus == IECUS_IDLE &&
		    !scb->ie_cx && !scb->ie_cnr) {
			identify(&es->es_if);
			printf("CU out of sync\n");
		}
	}
}

ieoutput(ifp, m0, dst)
	struct ifnet *ifp;
	struct mbuf *m0;
	struct sockaddr *dst;
{
	return (ether_output(ifp, m0, dst, iestartout,
				&ie_softc[ifp->if_unit].es_ac));
}

/*
 * Process an ioctl request.
 */
ieioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	int cmd;
	caddr_t data;
{
	int unit = ifp->if_unit;
	register struct ie_softc *es = &ie_softc[unit];
	int error = 0;
	int mem;
	int s;
	
	s = splie();

	switch (cmd) {

	case SIOCSIFADDR:
		error = set_if_addr(ifp, data, &es->es_enaddr);
		break;

	case SIOCGIFADDR:
		bcopy((caddr_t) &es->es_enaddr,
			(caddr_t) &((struct ifreq *)data)->ifr_addr.sa_data[0],
			(u_int) sizeof (struct ether_addr));
		break;

	case SIOCSIFMEM:
		/*
		 * Set size of driver CB and buffer memory pool.
		 *	N.B.: this ioctl is pointless and is retained
		 *	only for compatibility with earlier versions
		 *	of the driver.  Although it's possible to use
		 *	this ioctl to make the driver allocate more
		 *	memory, the driver won't use it.
		 */
		if (es->es_type != IE_OB) {
			error = EINVAL;
			break;
		}
		if (es->es_base) {
			/* already in use */
			if (es->es_loaned) {
				/* outstanding loaned mbufs -- punt */
				error = EBUSY;
				break;
			}
			ieobfree(es);
		}
		if ((mem = *(int *)data) < IE_MEMMIN)
			mem = IE_MEMMIN;
		es->es_memsize = mem;
		ieinit(unit);
		break;

	case SIOCGIFMEM:
		if (es->es_type != IE_OB) {
			error = EINVAL;
			break;
		}
		*(int *)data = es->es_memsize;
		break;

	case SIOCGIFFLAGS:
		*(short *)data = ifp->if_flags;
		break;

	case SIOCSIFFLAGS:
	    {
		short flags = *(short *)data;
		int up;
		struct sockaddr sa;
		int promisc;

		up = flags & IFF_UP;
		if (up != (ifp->if_flags&IFF_UP))
			if (up)
				/* going up */
				ieinit(unit);
			else {
				/* going down */
				sa = ifp->if_addr;
				bzero((caddr_t)&ifp->if_addr,
				    sizeof(ifp->if_addr));
				ieinit(unit);
				ifp->if_addr = sa;
			}

		if (ifp->if_flags&IFF_UP)
			flags |= (IFF_UP|IFF_RUNNING);
		else
			flags &= ~(IFF_UP|IFF_RUNNING);

		promisc = flags & IFF_PROMISC;
		if (promisc != (ifp->if_flags&IFF_PROMISC))
			if ((ifp->if_flags&IFF_UP) == 0) {
				flags &= ~IFF_PROMISC;
				error = ENETDOWN;
			} else {
				register struct ieconf *ic;

				ic = synccb_res(es, struct ieconf *);
#ifdef	DEBUGIE
				if (!ic) {
					identify(&es->es_if);
					panic("ieioctl: nested iesynccmd");
				}
#endif	DEBUGIE
				iedefaultconf(ic);
				ic->ieconf_promisc = promisc ? 1 : 0;
				iesynccmd(es, &ic->ieconf_cb);
				synccb_rel(es);
			}

		ifp->if_flags = flags;
	    }
		break;

	default:
		error = EINVAL;
		break;
	}

	(void) splx(s);
	return (error);
}

/*
 * Tell the chip its ethernet address.
 */
iedoaddr(es)
	register struct ie_softc	*es;
{
	register struct ieiaddr	*iad;

	iad = synccb_res(es, struct ieiaddr *);
#ifdef	DEBUGIE
	if (!iad) {
		identify(&es->es_if);
		panic("iedoaddr: iad");
	}
#endif	DEBUGIE
	bzero((caddr_t)iad, sizeof (struct ieiaddr));
	iad->ieia_cb.iec_cmd = IE_IADDR;
	*(struct ether_addr *)iad->ieia_addr = es->es_enaddr;
	iesynccmd(es, &iad->ieia_cb);
	synccb_rel(es);
}

/*
 * Process completed input packets and recycle resources;
 * only called from interrupt level by ieintr.
 *
 * If we could count on there being exactly one receive buffer
 * per receive frame, this code could be simplified.  The rest
 * of the driver conforms to this assumption.  Seemingly, the
 * only way it could be violated is by reception of a giant
 * packet.  Todo: instrument to see whether we ever do receive
 * multiple buffer frames.
 */
ierecv(es)
	register struct ie_softc *es;
{
	register struct ierbd	*rbd;
	register struct ierfd	*rfd;
	register struct iescb	*scb = es->es_scb;
	int eof, e;

	es->es_latest = time;		/* latch arrival time */
	
	rfd = es->es_rfdhd;
	if (!rfd)			/* not initialized */
		return;

top:
	/* Process each received frame. */
	while (rfd->ierfd_done) {
		ieread(es, rfd);

		/* Reclaim resources associated with the frame. */
		if (rfd->ierfd_rbd != IENULLOFF) {
			rbd = es->es_rbdhd;
#ifdef	DEBUGIE
			/*
			 * Sanity check.  Verify that we agree with the
			 * frame descriptor about which rbd is current.
			 */
			if (rbd != (struct ierbd *) from_ieoff(es,
					(ieoff_t)rfd->ierfd_rbd)) {
				identify(&es->es_if);
				panic("ierecv rbd");
			}
#endif	DEBUGIE
			/*
			 * Gobble up all rbd/buffer pairs associated with
			 * the frame, stopping if we catch up to the spot
			 * where the chip is filling buffers.
			 */
			while (rbd && rbd->ierbd_used) {
#ifdef	DEBUGIE
				/*
				 * Sanity check.  Verify that the current rfd
				 * points to the head of the filled rbd queue.
				 */
				if (rbd != es->es_rbdhd) {
					identify(&es->es_if);
					panic("ierecv rbdhd");
				}
#endif	DEBUGIE

				/*
				 * Advance the rbd list head and tail one
				 * notch around the ring.
				 */
				rbd->ierbd_el = 1;
				eof = rbd->ierbd_eof;
				rbd->ierbd_status = 0;
				/* Put rbd/buffer back onto receive list. */
				es->es_rbdtl->ierbd_el = 0;
				es->es_rbdtl = rbd;
				rbd = es->es_rbdhd = rbd->ierbd_link;
				if (eof)
					break;
			}
		}

		/*
		 * Advance the rfd list head and tail
		 * one notch around the ring.
		 */
		rfd->ierfd_rbd = IENULLOFF;
		rfd->ierfd_el = 1;
		rfd->ierfd_status = 0;
		/* Put frame descriptor back onto receive list. */
		es->es_rfdtl->ierfd_el = 0;
		es->es_rfdtl = rfd;
		rfd = es->es_rfdhd = rfd->ierfd_link;
	}

	/*
	 * Update cumulative statistics.  (These relate to everything
	 * that's come in since we last updated, not to a single packet.)
	 */
	if (e = scb->ie_crcerrs) {	/* count of CRC errors */
		scb->ie_crcerrs = 0;
		e = from_ieint(e);
		es->es_if.if_ierrors += e;
		es->es_ierr.crc += e;
	}
	if (e = scb->ie_alnerrs) {	/* count of alignment errors */
		scb->ie_alnerrs = 0;
		e = from_ieint(e);
		es->es_if.if_ierrors += e;
		es->es_ierr.aln += e;
	}
	if (e = scb->ie_rscerrs) {	/* count of discarded packets */
		scb->ie_rscerrs = 0;
		e = from_ieint(e);
		es->es_if.if_ierrors += e;
		es->es_ierr.rsc += e;
	}
	if (e = scb->ie_ovrnerrs) {	/* count of overrun packets */
		scb->ie_ovrnerrs = 0;
		e = from_ieint(e);
		es->es_if.if_ierrors += e;
		es->es_ierr.ovr += e;
	}

	/*
	 * If the receive unit is still chugging along, we're done.
	 * Otherwise, it must have caught up with us and entered
	 * the No Resources state, and we must restart it.
	 */
	if (scb->ie_rus == IERUS_READY)
		return;
	es->es_runotready++;		/* important instrumentation var! */
	/* The following test must be made when we know chip is quiet. */
	if (es->es_rfdhd->ierfd_done) {
		/* more snuck in */
		goto top;
	}

	/* Reset our data structures and restart. */
	es->es_rfdhd->ierfd_rbd = to_ieoff(es, (caddr_t)es->es_rbdhd);
	iechkcca(es);
	scb->ie_rfa = to_ieoff(es, (caddr_t)es->es_rfdhd);
	scb->ie_cmd = IECMD_RU_START;
	ieca(es);
}

/*
 * Move info from driver toward protocol interface.
 */
ieread(es, rfd)
	register struct ie_softc	*es;
	register struct ierfd		*rfd;
{
	register struct ierbd	*rbd;
	struct ether_header	*header;
	struct mbuf *m;
	int length, off;
	caddr_t buffer;

	es->es_if.if_ipackets++;
	if (!rfd->ierfd_ok) {
		es->es_if.if_ierrors++;
		identify(&es->es_if);
		printf("receive error\n");
		return;
	}

	if (rfd->ierfd_rbd == IENULLOFF)
		length = 0;
	else {
		rbd = (struct ierbd *)from_ieoff(es, (ieoff_t)rfd->ierfd_rbd);
		/*
		 * There is more work we would do here if the rbs
		 * were smaller than IE_BUFSZ, namely chase down
		 * the segments; but for ease of programming we
		 * allocate the receiver buffers large enough
		 * so that the input packet is contiguous.
		 */
		if (!rbd->ierbd_eof) {		/* length > IE_BUFSZ  */
			identify(&es->es_if);
			printf("giant packet\n");
			es->es_if.if_ierrors++;
			return;
		}
		length = (rbd->ierbd_cnthi << 8) + rbd->ierbd_cntlo;
	}
#ifdef	IE_FDADDR
	header = (struct ether_header *)rfd->ierfd_dhost;
	buffer = from_ieaddr(es, rbd->ierbd_buf);
#else	IE_FDADDR
	header = (struct ether_header *) from_ieaddr(es, rbd->ierbd_buf);
	buffer = ((caddr_t) header) + sizeof (struct ether_header);
	if (length >= sizeof (struct ether_header))
		length -= sizeof (struct ether_header);
	else
		length = 0;
#endif	IE_FDADDR

	if (check_trailer(header, buffer, &length, &off)) {
		identify(&es->es_if);
		printf("trailer error\n");
		es->es_if.if_ierrors++;
		return;
	}

	if (length == 0) {
		identify(&es->es_if);
		printf("runt packet\n");
		es->es_if.if_ierrors++;
		return;
	}

	/*
	 * Receive buffer loan-out:
	 *	We're willing to loan the buffer containing this
	 *	packet to the higher protocol layers provided that
	 *	the packet's big enough and doesn't have a trailer
	 *	and that we have a spare receive buffer to use as
	 *	a replacement for it.
	 */
	if (length > MLEN && off == 0) {
		/* Big enough and no trailer... */
		struct ierbuf	*rborig, *rbrepl;

		es->es_prloans++;

		rborig = rbd->ierbd_rbuf;
		rbrepl = es->es_rbuf_free;
		if (!rbrepl || !(m = mclgetx (ieclfree, (int)rborig,
		    buffer, length, M_DONTWAIT)))
			goto cantloan;

		es->es_arloans++;
		es->es_loaned++;

		/*
		 * The packet's receive buffer is now wrapped in an
		 * MCL_LOANED mbuf.  Move it onto the loan-out list.
		 */
		rborig->ierbuf_next = es->es_rbuf_loan;
		es->es_rbuf_loan = rborig;
		/*
		 * Install the replacement in the rbd and take
		 * it off the free list.
		 */
		rbd->ierbd_rbuf = rbrepl;
		rbd->ierbd_buf = to_ieaddr(es, (caddr_t)rbrepl->ierbuf_data);
		es->es_rbuf_free = rbrepl->ierbuf_next;
	}
	else {
cantloan:
		m = copy_to_mbufs(buffer, length, off);
	}

#ifdef	DEBUGIE
	iechkmbuf(m);
#endif	DEBUGIE
	if (!m)
		return;

	/*
	 * There used to be a separate variable "wirelen" that remembered
	 * the length of the packet before the trailer code changed the
	 * length.  The trailer code now no longer changes the length
	 * variable (but it does adjust the length reflected in the mbuf
	 * chain), so the separate "wirelen" is unnecessary.
	 */
	do_protocol(header, m, &es->es_ac, length);
}


/*
 * Allocation and deallocation routines for descriptors and buffers.
 */

/*
 * Allocate and initialize the ring of transmit buffer descriptors.
 * Assumes that the ring is currently unallocated.
 */
ie_tbdinit(es, ntbds)
	register struct ie_softc	*es;
	register int			ntbds;
{
	struct ietbd		*tbd_start;
	register struct ietbd	*tbd;
	long			tbd_rsize;

	if (ntbds <= 0) {
		identify(&es->es_if);
		panic("ie_tbdinit: ridiculous request");
	}
	es->es_ftbds = es->es_tbds = ntbds;

	/*
	 * Grab a chunk of control block space
	 * to hold the descriptor ring.
	 */
	tbd_rsize = ntbds * sizeof (struct ietbd);
	tbd_start = (struct ietbd *) rmalloc(es->es_rmap, tbd_rsize);
	if (!tbd_start) {
		identify(&es->es_if);
		panic("ie_tbdinit: no rmap space");
	}
	es->es_tbdring = tbd_start;
#ifdef	DEBUGIE
	ie_chkbounds(es->es_tbdring);
	ie_chkbounds(es->es_tbdring+es->es_tfds-1);
#endif	DEBIGIE

	/*
	 * Link the tbds together into a ring, setting up the
	 * ietbd_next and ietbd_link fields in tandem.
	 */
	for (tbd = tbd_start; tbd < tbd_start + ntbds - 1; ) {
		register struct ietbd	*ptbd = tbd++;

	 	ptbd->ietbd_next = to_ieoff(es, (caddr_t)tbd);
		ptbd->ietbd_link = tbd;
	}
	tbd->ietbd_next = to_ieoff(es, (caddr_t)tbd_start);
	tbd->ietbd_link = tbd_start;

	/* Initialize queue head pointers. */
	es->es_utbd = es->es_ftbd = tbd_start;
}

/*
 * Allocate and initialize the pool of transmit frame descriptors.
 * Assumes the pool is currently unallocated.
 */
ie_tfdinit(es, ntfds)
	register struct ie_softc	*es;
	register int			ntfds;
{
	register struct ietfd	*tfd_pool;
	long			tfd_psize;
	register int		i;

	if (ntfds <= 0) {
		identify(&es->es_if);
		panic("ie_tfdinit: ridiculous request");
	}
	es->es_tfds = ntfds;

	/*
	 * Carve the pool out of the resource map.
	 */
	tfd_psize = ntfds * sizeof (struct ietfd);
	tfd_pool = (struct ietfd *) rmalloc(es->es_rmap, tfd_psize);
	if (!tfd_pool) {
		identify(&es->es_if);
		panic("ie_tfdinit: no rmap space");
	}
	es->es_tfdpool = tfd_pool;
#ifdef	DEBUGIE
	ie_chkbounds(es->es_tfdpool);
	ie_chkbounds(es->es_tfdpool+es->es_tfds-1);
#endif	DEBUGIE

	/*
	 * Chain the tfds together into a free list.
	 */
	for (i = 1; i < ntfds; i++)
		tfd_pool[i - 1].ietfd_flink = &tfd_pool[i];
	tfd_pool[ntfds - 1].ietfd_flink = (struct ietfd *)0;

	es->es_tfd_free = tfd_pool;
}

/*
 * Allocate and initialize the transmit buffer pool.
 * Assumes the pool is currently unallocated.
 */
ie_tbufinit(es, ntbufs)
	register struct ie_softc	*es;
	register int			ntbufs;
{
	register union ietbuf 	*tbuf_pool;
	long			tbuf_psize;
	register int 		i;

	if (ntbufs <= 0) {
		identify(&es->es_if);
		panic("ie_tbufinit: ridiculous request");
	}
	es->es_tbufs = ntbufs;

	/*
	 * Carve the pool out of the resource map.
	 */
	tbuf_psize = ntbufs * sizeof (union ietbuf);
	tbuf_pool = (union ietbuf *) rmalloc(es->es_rmap, tbuf_psize);
	if (!tbuf_pool) {
		identify(&es->es_if);
		panic("ie_tbufinit: no rmap space");
	}
	es->es_tbufpool = tbuf_pool;

	/*
	 * Chain the tbufs together into a free list.
	 */
	for (i = 1; i < ntbufs; i++)
		tbuf_pool[i - 1].ietbuf_next = &tbuf_pool[i];
	tbuf_pool[ntbufs - 1].ietbuf_next = (union ietbuf *)0;

	es->es_tbuf_free = tbuf_pool;
}

/*
 * Allocate and initialize the ring of receive buffer descriptors.
 * Assumes that the ring is currently unallocated.
 */
ie_rbdinit(es, nrbds)
	register struct ie_softc	*es;
	register int			nrbds;
{
	struct ierbd		*rbd_start;
	register struct ierbd	*rbd;
	long			rbd_rsize;

	if (nrbds <= 0) {
		identify(&es->es_if);
		panic("ie_rbdinit: ridiculous request");
	}
	es->es_rbds = nrbds;

	/*
	 * Grab a chunk of control block space
	 * to hold the descriptor ring.
	 */
	rbd_rsize = nrbds * sizeof (struct ierbd);
	rbd_start = (struct ierbd *) rmalloc(es->es_rmap, rbd_rsize);

	if (!rbd_start) {
		identify(&es->es_if);
		panic("ie_rbdinit: no rmap space");
	}
	es->es_rbdring = rbd_start;
#ifdef	DEBUGIE
	ie_chkbounds(es->es_rbdring);
	ie_chkbounds(es->es_rbdring+es->es_rbds-1);
#endif	DEBUGIE

	/*
	 * Clear the rbds.  Ierustart counts on virgin rbds having
	 * null ierbd_rbuf fields, as it must attach rbufs to such
	 * rbds but leave others untouched.
	 */
	bzero((caddr_t)rbd_start, (u_int)rbd_rsize);

	/*
	 * Link the rbds together into a ring, setting up the
	 * ierbd_next and ierbd_link fields in tandem.
	 */
	for (rbd = rbd_start; rbd < rbd_start + nrbds - 1; ) {
		register struct ierbd	*prbd = rbd++;

	 	prbd->ierbd_next = to_ieoff(es, (caddr_t)rbd);
		prbd->ierbd_link = rbd;
	}
	rbd->ierbd_next = to_ieoff(es, (caddr_t)rbd_start);
	rbd->ierbd_link = rbd_start;

	/* Initialize list pointers. */
	es->es_rbdhd = rbd_start;
	es->es_rbdtl = rbd;
}

/*
 * Allocate and initialize the ring of receive frame descriptors.
 * Assumes that the ring is currently unallocated.
 */
ie_rfdinit(es, nrfds)
	register struct ie_softc	*es;
	register int			nrfds;
{
	struct ierfd		*rfd_start;
	register struct ierfd	*rfd;
	long			rfd_rsize;

	if (nrfds <= 0) {
		identify(&es->es_if);
		panic("ie_rfdinit: ridiculous request");
	}
	es->es_rfds = nrfds;

	/*
	 * Grab a chunk of control block space
	 * to hold the descriptor ring.
	 */
	rfd_rsize = nrfds * sizeof (struct ierfd);
	rfd_start = (struct ierfd *) rmalloc(es->es_rmap, rfd_rsize);

	if (!rfd_start) {
		identify(&es->es_if);
		panic("ie_rfdinit: no rmap space");
	}
	es->es_rfdring = rfd_start;
#ifdef	DEBUGIE
	ie_chkbounds(es->es_rfdring);
	ie_chkbounds(es->es_rfdring+es->es_rfds-1);
#endif	DEBUGIE

	/*
	 * Link the rfds together into a ring, setting up the
	 * ierfd_next and ierfd_link fields in tandem.
	 */
	for (rfd = rfd_start; rfd < rfd_start + nrfds - 1; ) {
		register struct ierfd	*prfd = rfd++;

	 	prfd->ierfd_next = to_ieoff(es, (caddr_t)rfd);
		prfd->ierfd_link = rfd;
	}
	rfd->ierfd_next = to_ieoff(es, (caddr_t)rfd_start);
	rfd->ierfd_link = rfd_start;

	/* Initialize list pointers. */
	es->es_rfdhd = rfd_start;
	es->es_rfdtl = rfd;
}

/*
 * Allocate and initialize the receive buffer pool.
 * Assumes the pool is currently unallocated.
 */
ie_rbufinit(es, nrbufs)
	register struct ie_softc	*es;
	register int			nrbufs;
{
	register struct ierbuf	*rbuf_pool;
	long			rbuf_psize;
	register int 		i;

	if (nrbufs <= 0) {
		identify(&es->es_if);
		panic("ie_rbufinit: ridiculous request");
	}
	es->es_rbufs = nrbufs;

	/*
	 * Carve the pool out of the resource map.
	 */
	rbuf_psize = nrbufs * sizeof (struct ierbuf);
	rbuf_pool = (struct ierbuf *) rmalloc(es->es_rmap, rbuf_psize);
	if (!rbuf_pool) {
		identify(&es->es_if);
		panic("ie_rbufinit: no rmap space");
	}
	es->es_rbufpool = rbuf_pool;

	/*
	 * Chain the rbufs together into a free list.
	 */
	for (i = 1; i < nrbufs; i++)
		rbuf_pool[i - 1].ierbuf_next = &rbuf_pool[i];
	rbuf_pool[nrbufs - 1].ierbuf_next = (struct ierbuf *)0;

	es->es_rbuf_free = rbuf_pool;
}


/*
 * Extend the tbd list ending at tbd by transferring the head of
 * the free list to it.  Tbd is assumed to be the end of the chain
 * of tbds depending from the current tfd.  If nonnull, it must
 * coincide with the in-use list tail.  Return the address of the
 * new chain tail or NULL if there were no free tbds.
 *
 * This routine critically depends on the permanent arrangement of
 * tbds into a ring with embedded free and in-use queues biting
 * each others' tails.
 */
struct ietbd *
ietbdget(es, tbd)
	register struct ie_softc	*es;
	register struct ietbd		*tbd;
{
	register struct ietbd	*ntbd;

	if (es->es_ftbds == 0)
		return ((struct ietbd *) 0);

	ntbd = es->es_ftbd;
	es->es_ftbd = es->es_ftbd->ietbd_link;
	es->es_ftbds--;

	/*
	 * Move the list end marker for this frame
	 * to the end of its newly extended tbd list.
	 */
	if (tbd)
		tbd->ietbd_eof = 0;
	ntbd->ietbd_eof = 1;

	return (ntbd);
}

/*
 * Start or restart output to wire.  If there are sufficient
 * resources available add a new frame to the transmit queue.
 * Otherwise, wait until later.
 */
iestartout(unit)
	int	unit;
{
 	register struct ie_softc *es = &ie_softc[unit];
	register struct ietfd	*tfd;
	struct ietbd		*sv_ftbd;
	u_short			sv_ftbds;
	int			qlen0;

	/* Gather some statistics. */
	qlen0 = es->es_if.if_snd.ifq_len;
	if (qlen0 > 0) {
		es->es_started++;
		if (qlen0 > 1)
			es->es_started2++;
	}

	/*
	 * Loop until there are no more packets ready to send or we
	 * have insufficient resources left to send another one.
	 */
	while (es->es_if.if_snd.ifq_head && es->es_tfd_free &&
	    es->es_tbuf_free && es->es_ftbds > 0) {
		register struct mbuf	*m, *mp;
		register struct ietbd	*tbd, *tbdlist;
		struct ether_header	*ec;
		int			len;

		IF_DEQUEUE(&es->es_if.if_snd, m);

		/*
		 * Record tbd ring state for later restoration in the
		 * event of inability to complete setting up this frame.
		 */
		sv_ftbd = es->es_ftbd;
		sv_ftbds = es->es_ftbds;

		tfd = es->es_tfd_free;
#ifdef	DEBUGIE
		if (!tfd) {
			identify(&es->es_if);
			panic("tfd free list botch");
		}
#endif	DEBUGIE
		es->es_tfd_free = tfd->ietfd_flink;

		ec = mtod(m, struct ether_header *);
#ifdef	IE_FDADDR
		/*
		 * We've configured the chip so that the ether header lives
		 * in the frame descriptor rather than the first buffer.
		 * The chip will insert the source address.
		 */
		*(struct ether_addr *)tfd->ietfd_dhost = ec->ether_dhost;
		tfd->ietfd_type = ec->ether_type;
		m->m_len -= sizeof (struct ether_header);
		m->m_off += sizeof (struct ether_header);
#else	IE_FDADDR
		/*
		 * Insert source address.  If we end up running configured
		 * this way by default, this assignment should be moved
		 * into ether_output, since both this and the LANCE drivers
		 * would otherwise end up doing it themselves.
		 */
		ec->ether_shost = es->es_enaddr;
#endif	IE_FDADDR

		/*
		 * Record sufficient information in the frame descriptor
		 * to allow the packet to be reconstructed if need be.
		 */
		tfd->ietfd_mbuf = m;
		tfd->ietfd_tail = (union ietbuf *) 0;
		tfd->ietfd_tlen = 0;

		/*
		 * Avoid suspected bus contention problem by pulling
		 * the packet's initial buffer up to be long enough
		 * to give the chip a chance to track down successive
		 * buffers while DMA-ing out the contents of the first
		 * one.  Intel documentation claims that the worst case
		 * requirement is 70 bytes.  We choose to be more
		 * conservative.
		 */
#ifdef	IE_FDADDR
#define	IE_MINTU0	(100 - sizeof (struct ether_header))
#else	IE_FDADDR
#define	IE_MINTU0	100
#endif	IE_FDADDR
		tfd->ietfd_mbuf = m = ether_pullup(m, IE_MINTU0);
		if (!m) {
			identify(&es->es_if);
			printf("out of mbufs: output packet dropped\n");
			goto cleanup;
		}

		/*
		 * Force packet size up to minimum allowed.  Ether_pullup
		 * guarantees that we can adjust the mbuf size to the
		 * required amount (assumes MLEN > ETHERMIN).  If the
		 * ether header lives in the packet body, the required
		 * length goes up accordingly.
		 */
#ifdef	IE_FDADDR
#define	IE_ETHERMIN	ETHERMIN
#else	IE_FDADDR
#define	IE_ETHERMIN	(ETHERMIN + sizeof (struct ether_header))
#endif	IE_FDADDR
		if (m->m_len < IE_ETHERMIN)
			m->m_len = IE_ETHERMIN;

		/*
		 * Construct the frame's tbd chain.  If possible, we avoid
		 * copying by pointing successive tbds at successive mbufs.
		 * This is not always possible, due to resource exhaustion
		 * or to addressing and alignment constraints.  At the first
		 * point in the chain where it's not possible to use an mbuf,
		 * we copy the remainder of the packet's mbuf chain into a
		 * tbuf, on the theory that it's unlikely that subsequent
		 * mbufs will work once one has failed.
		 */
		tbdlist = tbd = (struct ietbd *)0;
		for (mp = (struct mbuf *)0; m; mp = m, m = m->m_next) {
			register int	haveresources;
			register int	bp;

			if (m->m_len <= 0)
				continue;

			/*
			 * To get around another hardware deficiency in the
			 * 82586 chip, we combine mbufs that have only
			 * a "few" bytes in them.  According to Intel's
			 * documentation, the worst case requires a minimum
			 * buffer size of 55 bytes.  Out of deeply ingrained
			 * paranoia we increase this a bit.
			 *
			 * XXX: perhaps we should skip the pullup and
			 *	copy the entire packet into a tbuf instead.
			 */
#define IE_MINTU1	60
			if (m->m_next && m->m_next->m_len < IE_MINTU1) {
				m->m_next = ether_pullup(m->m_next, IE_MINTU1);
				if (!m->m_next) {
					m_freem(tfd->ietfd_mbuf);
					identify(&es->es_if);
					printf("out of mbufs\n");
					goto cleanup;
				}
			}

			tbd = ietbdget(es, tbd);
#ifdef	DEBUGIE
			if (!tbd) {
				identify(&es->es_if);
				panic("iestartout null tbd");
			}
#endif	DEBUGIE
			if (!tbdlist)
				tbdlist = tbd;

			/*
			 * See whether we can point tbd at m.
			 */
			haveresources = es->es_ftbds > 0 || !m->m_next;
			if (haveresources &&
			    (bp = ieaddr(es, mtod(m, caddr_t))) &&
			    !(mtod(m, u_long) & 01)) {
				tbd->ietbd_buf = to_ieaddr_opt(bp);
				tbd->ietbd_cntlo = m->m_len & 0xff;
				tbd->ietbd_cnthi = m->m_len >> 8;
			}
			else {
				/*
				 * Must copy the mbuf and adjust
				 * bookkeeping information accordingly.
				 */
				union ietbuf	*tbuf = es->es_tbuf_free;

#ifdef	DEBUGIE
				if (!tbuf) {
					identify(&es->es_if);
					panic("iestartout null tbuf");
				}
#endif	DEBUGIE

				/* Collect some statistics. */
				es->es_outcpy++;
				if (! haveresources)
					es->es_notbds++;

				if (mp)
					mp->m_next = (struct mbuf *)0;
				else
					tfd->ietfd_mbuf = (struct mbuf *)0;

				es->es_tbuf_free = tbuf->ietbuf_next;

				tfd->ietfd_tail = tbuf;
				tfd->ietfd_tlen = len =
					copy_from_mbufs(tbuf->ietbuf_data, m);

				tbd->ietbd_buf = to_ieaddr(es,
						(caddr_t)tbuf->ietbuf_data);
				tbd->ietbd_cntlo = len & 0xff;
				tbd->ietbd_cnthi = len >> 8;

				/*
				 * Copy_from_mbufs has consumed
				 * the entire packet remainder.
				 */
				break;
			}
		}

		tfd->ietfd_tbd = to_ieoff(es, (caddr_t)tbdlist);
		tfd->ietfd_cmd = IE_TRANSMIT;
		iedocb(es, (struct iecb *)tfd);
	}
	iecustart(es);
	return;

cleanup:
	if (tfd) {
		union ietbuf	*tbuf = tfd->ietfd_tail;

		if (tfd->ietfd_mbuf)
			m_freem(tfd->ietfd_mbuf);
		if (tbuf) {
			tbuf->ietbuf_next = es->es_tbuf_free;
			es->es_tbuf_free = tbuf;
		}
		tfd->ietfd_flink = es->es_tfd_free;
		es->es_tfd_free = tfd;
	}

	/*
	 * Restore the tbd ring to the state recorded at
	 * the start of setting up the aborted packet.
	 */
	es->es_ftbd = sv_ftbd;
	es->es_ftbds = sv_ftbds;

	iecustart(es);
}

/*
 * Update error counters and free up resources after transmitting a packet.
 * Called by iecuclean at splie or hardware level 3.
 *
 * Under certain conditions we're willing to make a second try at sending
 * a packet when the first attempt fails.  The constraints are: the facility
 * is enabled in the first place; no packet has gone out since the failed
 * one (this prevents out of order transmissions); and we haven't already
 * retried the packet (this prevents the driver from eating up the entire
 * system when the net breaks).
 */
iexmitdone(es, tfd)
	register struct ie_softc *es;
	register struct ietfd *tfd;
{
	register struct ietbd *tbd, *ntbd;
	union ietbuf	*tbuf;
	register int	canretransmit = ie_retransmit && tfd->ietfd_el &&
					!es->es_pendreque;

	if (tfd->ietfd_ok) {
		es->es_if.if_collisions += tfd->ietfd_ncoll;
		es->es_if.if_opackets++;
		if (tfd->ietfd_defer)
			es->es_iedefer++;
		if (tfd->ietfd_heart)
			es->es_ieheart++;
	} else {
		es->es_if.if_oerrors++;
		if (tfd->ietfd_xcoll) {
			es->es_trtry++;
			if (!canretransmit) {
				identify(&es->es_if);
				printf("Ethernet jammed\n");
			}
		}
		if (tfd->ietfd_nocarr) {
			es->es_tnocar++;
			if (!canretransmit) {
				identify(&es->es_if);
				printf("no carrier\n");
			}
		}
		if (tfd->ietfd_nocts) {
			es->es_noCTS++;
			if (!canretransmit) {
				identify(&es->es_if);
				printf("no CTS\n");
			}
		}
		if (tfd->ietfd_underrun)
			es->es_xmiturun++;
	}

	/*
	 * Verify that the tbds associated with the just-transmitted
	 * frame appear at the front of the queue of in-use tbds and
	 * transfer them to the free queue, reclaiming their associated
	 * resources.
	 */
	tbd = tfd->ietfd_tbd == IENULLOFF
		? (struct ietbd *) 0
		: (struct ietbd *) from_ieoff(es, (ieoff_t)tfd->ietfd_tbd);
	for ( ; tbd; tbd = ntbd) {
		ntbd = tbd->ietbd_eof
			? (struct ietbd *) 0
			: (struct ietbd *) from_ieoff(es,
						(ieoff_t)tbd->ietbd_next);

		if (tbd != es->es_utbd) {
			/*
			 * Checking here may be overkill.  We may
			 * wish to move this check to immediately
			 * before the loop.
			 */
			identify(&es->es_if);
#ifdef	DEBUGIE
			printf("tbd: %x, es->es_utbd: %x\n", tbd, es->es_utbd);
			printf("\tes->es_tbdring: %x\n", es->es_tbdring);
#endif	DEBUGIE
			panic("iexmitdone: tbds out of sync");
		}

		/* Reclaim descriptor. */
		es->es_utbd = es->es_utbd->ietbd_link;
		if (++es->es_ftbds > es->es_tbds) {
			identify(&es->es_if);
			panic("iexmitdone: too many free tbds");
		}
	}

	/*
	 * Requeue if necessary and possible.  If successful,
	 * ie_requeue will set pendreque.
	 */
	es->es_pendreque = 0;
	if (!tfd->ietfd_ok && canretransmit)
		ie_requeue(es, tfd);

	/*
	 * Reclaim the frame's buffer space.
	 */
	if (tfd->ietfd_mbuf)
		m_freem(tfd->ietfd_mbuf);
	if (tbuf = tfd->ietfd_tail) {
		tbuf->ietbuf_next = es->es_tbuf_free;
		es->es_tbuf_free = tbuf;
	}

	tfd->ietfd_flink = es->es_tfd_free;
	es->es_tfd_free = tfd;
}

/*
 * Put the packet described by tfd back on the output queue.
 * Adjust bookkeeping fields to reflect the altered state.
 * Assumes called with the output queue locked.  Also assumes
 * that caller will reclaim any resources left recorded in tfd.
 */
ie_requeue(es, tfd)
	struct ie_softc		*es;
	register struct ietfd	*tfd;
{
	register struct mbuf	*mtail = (struct mbuf *)0,
				*m;
#ifdef	IE_FDADDR
	struct mbuf		*m0;
	struct ether_header	*header;
#endif	IE_FDADDR

	if (IF_QFULL(&es->es_if.if_snd)) {
		identify(&es->es_if);
		printf("output queue full; can't requeue\n");
		return;
	}

	/*
	 * Convert the tail buffer back into an mbuf chain.
	 */
	if (tfd->ietfd_tlen) {
		mtail = copy_to_mbufs((caddr_t)tfd->ietfd_tail->ietbuf_data,
			(int)tfd->ietfd_tlen, 0);
		if (!mtail) {
			identify(&es->es_if);
			printf("out of mbufs for packet requeue\n");
			return;
		}
	}
	/*
	 * Glue the two mbuf chains together
	 * and set m to point to the result.
	 */
	if (m = tfd->ietfd_mbuf) {
		if (mtail) {
			while (m->m_next)
				m = m->m_next;
			m->m_next = mtail;
			m = tfd->ietfd_mbuf;
		}
	}
	else
		m = mtail;
#ifdef	IE_FDADDR
	/*
	 * If IE_FDADDR is defined, then the ether header lives in *tfd.
	 *
	 * Paste the ether header back at the front of the mbuf chain.
	 * If there's not enough space at the front, allocate another.
	 */
	m0 = m;
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		m = m_get(M_DONTWAIT, MT_DATA);
		if (!m) {
			m_freem(m0);
			identify(&es->es_if);
			printf("out of mbufs for packet requeue\n");
			goto out;
		}
		m->m_next = m0;
		m->m_len = sizeof (struct ether_header);
	}
	else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	header = mtod(m, struct  ether_header *);
	header->ether_dhost = *(struct ether_addr *)tfd->ietfd_dhost;
	header->ether_type = tfd->ietfd_type;
#endif	IE_FDADDR

	/*
	 * Requeue the reconstituted packet.
	 */
	IF_PREPEND(&es->es_if.if_snd, m);
	es->es_requeues++;
	es->es_pendreque = 1;

#ifdef	IE_FDADDR
out:
#endif	IE_FDADDR
	/*
	 * The incoming mbuf is now either back on the output
	 * queue or has been freed, so we don't want our caller
	 * to free it.
	 */
	tfd->ietfd_mbuf = (struct mbuf *)0;
}


/*
 * Calculate an upper bound on the amount of memory required for
 * the resource allocation implied by the arguments, taking into
 * account fixed requirements (single control blocks, configuration
 * pointers, etc.) and allocation ordering requirements.
 *
 * Tightening this upper bound would result in smaller memory
 * requirements for the driver.
 */
/* ARGSUSED */
long
iecalcmem(es, tbds, tfds, tbufs, rbds, rfds, rbufs)	
	struct ie_softc	*es;
	int		tbds, tfds, tbufs, rbds, rfds, rbufs;
{
	register int	hole = 0;
	int		tbdsz, tfdsz, tbufsz, rbdsz, rfdsz, rbufsz;
	register long	mapsize;

	tbdsz = tbds * sizeof (struct ietbd);
	tfdsz = tfds * sizeof (struct ietfd);
	tbufsz = tbufs * sizeof (union ietbuf);
	rbdsz = rbds * sizeof (struct ierbd);
	rfdsz = rfds * sizeof (struct ierfd);
	rbufsz = rbufs * sizeof (struct ierbuf);

#ifndef	sun2
	/*
	 * If we'll end up using a page set up by the PROM
	 * monitor to map the SCP, there are no holes.
	 */
	if (es->es_type == IE_OB) {
		hole = 0;
		goto gapknown;
	}
#endif	sun2

	/*
	 * Calculate the maximum possible distance between the
	 * map start and the start of the SCP (based on fact that
	 * it lives within the first full page of the map) to get
	 * the maximum allocation gap.  Reduce the gap by the size
	 * of things that will be allocated within it.
	 */
	hole = 2 * NBPG - sizeof (struct iescp) - 1;
	hole -= sizeof (struct ieiscp) + sizeof (struct iescb) +
		sizeof (struct ieconf) + sizeof (struct iecb);
	if (hole < tbdsz)
		goto gapknown;
	hole -= tbdsz;
	if (hole < tfdsz)
		goto gapknown;
	hole -= tfdsz;
	if (hole < rbdsz)
		goto gapknown;
	hole -= rbdsz;
	if (hole < rfdsz)
		goto gapknown;
	hole -= rfdsz;
	if (hole < tbufsz)
		goto gapknown;
	hole -= tbufsz;
	if (hole < rbufsz)
		goto gapknown;
	hole -= rbufsz;
gapknown:

	mapsize =
		sizeof (struct iescp) +
		sizeof (struct ieiscp) +
		sizeof (struct iescb) +
		sizeof (struct ieconf) +	/* es_cbsync */
		sizeof (struct iecb) +		/* es_cbnop */
		tbdsz + tfdsz + tbufsz + rbdsz + rfdsz + rbufsz +
		hole;

	/* Round up to a long boundary. */
	mapsize = (long)(((u_long)mapsize + sizeof (long) - 1) &
			~(sizeof (long) - 1));

#ifdef	DEBUGIE
	identify(&es->es_if);
	printf("iecalcmem: using %d bytes of CB and buffer space\n", mapsize);
#endif	DEBUGIE
	return (mapsize);
}

/*
 * Called by ieinit to (allocate and re)initialize rmap.
 * We need to be careful, since the board may be in use
 * (rbufs loaned out).
 */
iegetmem(es)
	register struct ie_softc *es;
{
	struct ifnet *ifp = &es->es_if;
	register int unit = ifp->if_unit;

	bzero((caddr_t)iermap[unit], sizeof iermap[unit]);
	ifp->if_memmap = NULL;

	if (es->es_type == IE_OB) {
		if (!es->es_base) {
			/*
			 * No memory allocated yet; grab a contiguous
			 * chunk of kernel virtual space (and its
			 * associated physical memory.)  The minimum
			 * allowable amount is chosen to force enough
			 * room to let us double map the SCP in the
			 * first full page obtained.
			 */
			if (es->es_memsize < IE_MEMMIN)
				es->es_memsize = IE_MEMMIN;
			es->es_base = kmem_alloc((u_int)es->es_memsize);
			if (!es->es_base) {
				identify(&es->es_if);
				panic("iegetmem: no memory");
			}
		}
		es->es_rmap = &iermap[unit][0];
		rminit(es->es_rmap, (long)es->es_memsize, (long)es->es_base,
			"iecb", IERMAPSIZE);
		es->es_memspace = (caddr_t)KERNELBASE;
#ifdef sun2
		/*
		 * Remap the [preallocated] virtual page containing
		 * the SCP to make it point to the same physical
		 * location as es->es_base, so that we can muck with
		 * the control blocks using the address returned from
		 * kmem_alloc, and the chip can locate the SCP at its
		 * fixed address.
		 */
		{
			/* Round up to page boundary. */
			caddr_t vaddr = (caddr_t) ctob(btoc(es->es_base));
			u_int paddr = getkpgmap(vaddr) & PG_PFNUM;
			struct pte dummypte;	/* for mapin to write on */

			mapin(&dummypte, (u_int)btop(IESCPADDR +
			    es->es_memspace), paddr, 1, PG_V | PG_KW);
			/*
			 * Reserve space for the SCP at its (fixed) spot
			 * in the first page of the rmap.
			 */
			es->es_scp = (struct iescp *) rmget(es->es_rmap,
			    (int)sizeof (struct iescp),
			    (int)vaddr + (IESCPADDR & PGOFSET));
			if (es->es_scp == NULL) {
				identify(&es->es_if);
				panic("no SCP memory");
			}
		}
#else sun2
		/* Use the page already set up by the PROM monitor. */
		es->es_scp = (struct iescp *)(IESCPADDR + es->es_memspace);
#endif sun2
	}
	else { /* IE_MB */
		register struct mie_device *mie = es->es_mie;
		int a, vaddr, paddr;
		int firsttime = es->es_memspace == 0;

		if (firsttime) {
			/*
			 * Grab a chunk of kernel virtual space to use
			 * to map the board.
			 */
			a = rmalloc(kernelmap, (long)btoc(es->es_memsize));
			if (a == 0) {
				identify(&es->es_if);
				printf("no kernelmap for ie memory\n");
				panic("iegetmem");
			}
			es->es_memspace = (caddr_t)kmxtob(a);
		}
		/*
		 * Map the board's memory.  The page starting at
		 * the board's base address is already mapped from
		 * autoconf time, so we can use this mapping to obtain
		 * the pagetype bits to use for the memory mapping.
		 */
		vaddr = (int)es->es_memspace;
		a = btokmx((struct pte *)vaddr);
		/* board's mem boundary to byte addr */
		paddr = mie->mie_mbmhi << 16;
		/* Preserve pagetype bits and which megabyte it's in. */
		es->es_paddr = getkpgmap((caddr_t)mie) & PG_PFNUM;
		es->es_paddr &= ~(0x100000/NBPG - 1);
		es->es_paddr |= btop(paddr);
		mapin(&Usrptmap[a], (u_int)btop(vaddr), (u_int)es->es_paddr,
			(int)btoc(es->es_memsize), PG_V | PG_KW);

		/* Clear the board unless in use. */
		if (firsttime) {
			register int i;
			struct miepg *pg;
			short *ap = (short *)mie->mie_pgmap;

			for (i = 0; i < IEVVSIZ; i++)	/* clears mp_p2mem */
				*ap++ = 0;
			for (i = 0; i < IEPMEMSIZ/IEPAGSIZ; i++) {
				mie->mie_pgmap[0].mp_pfnum = i;
				bzero(es->es_memspace, IEPAGSIZ);
			}
			pg = &mie->mie_pgmap[0];
			for (i = 0; i < es->es_memsize/IEPAGSIZ; i++) {
				pg->mp_swab = 1;
				pg->mp_pfnum = i;
				pg++;
			}

			/*
			 * Use last page on ie board for chip init.
			 * (No need to reclaim, since beyond memsize.)
			 * This code sets up a double mapping for the
			 * page containing the SCP.
			 */
			pg = &mie->mie_pgmap[IEVVSIZ-1];
			pg->mp_swab = 1;
			pg->mp_pfnum = 0;

			/* patch potential powerup parity problem */
			mie->mie_peack = 1;
		}

		es->es_base = es->es_memspace;
		es->es_rmap = &iermap[unit][0];
		rminit(es->es_rmap, (long)es->es_memsize, (long)es->es_base,
			"iecb", IERMAPSIZE);
		/*
		 * Reserve space for the SCP at its (fixed) spot
		 * in the rmap.  We use the same trick as in the
		 * IE_OB case, using double mapping to make the SCP
		 * appear within memory that's under the driver's
		 * control.
		 */
		es->es_scp = (struct iescp *) rmget(es->es_rmap,
			(int)sizeof (struct iescp),
			(int)es->es_base + (IESCPADDR & (IEPAGSIZ-1)));
	}
}

/*
 * Grab chunks of the memory allocated by iegetmem and
 * initialize descriptors, buffers, and CBs in them.
 * "Initialization" here refers to setting up these parts
 * of the driver's data structures that remain unchanged
 * during normal operation, and to setting up the free lists.
 * After this routine completes, there's still more to be
 * done before turning the chip loose; chip-recognized
 * list end markers have to be put in place, and so on.
 *
 * N.B.: The order in which allocation occurs is important.
 * The chip references descriptors and control blocks by
 * 16-bit offsets from es->es_base, whereas it accesses
 * buffers with 24-bit addrresses.  Thus we must be careful
 * to allocate descriptors and CBs first, so that they come
 * from the first part of es->es_rmap.  (We count on rmalloc's
 * first fit strategy.)
 */
ieinitmem(es)
	register struct ie_softc	*es;
{
	register long	size;

	/*
	 * Set up dedicated CBs.  The cbsync size must be large enough
	 * to hold the largest CB associated with a synchronously-executed
	 * command.  Cbsync is cast as required to one of these CB types.
	 */
	size = max(sizeof (struct iecb), sizeof (struct ieconf));
	size = max((u_int)size, sizeof (struct ietdr));
	size = max((u_int)size, sizeof (struct ieiaddr));
	es->es_cbsync = (struct iecb *) rmalloc(es->es_rmap, size);

	size = sizeof (struct iecb);
	es->es_cbnop = (struct iecb *) rmalloc(es->es_rmap, size);

	size = sizeof (struct ieiscp);
	es->es_iscp = (struct ieiscp *) rmalloc(es->es_rmap, size);

	size = sizeof (struct iescb);
	es->es_scb = (struct iescb *) rmalloc(es->es_rmap, size);

	if (!es->es_cbnop || !es->es_cbsync || !es->es_iscp || !es->es_scb) {
		identify(&es->es_if);
		panic("ieinitmem: no rmap space");
	}

#ifdef	DEBUGIE
	/* Make sure that all descriptors are accessible. */
	ie_chkbounds(es->es_cbsync);
	ie_chkbounds(es->es_cbnop);
	ie_chkbounds(es->es_iscp);
	ie_chkbounds(es->es_scb);
#endif	DEBUGIE

	/*
	 * Set up descriptor pools.
	 */
	ie_tbdinit(es, ie_tbds);
	ie_tfdinit(es, ie_tfds);
	ie_rbdinit(es, ie_rbds);
	ie_rfdinit(es, ie_rfds);

	/*
	 * Set up buffer pools.
	 */
	ie_tbufinit(es, ie_tbufs);
	ie_rbufinit(es, ie_rbufs);
}

/*
 * Free storage allocated from the general kernel pool.
 * Applicable only to IE_OB interfaces.
 */
ieobfree(es)
	register struct ie_softc *es;
{
	if (es->es_type == IE_OB) {
		if (es->es_loaned) {
			identify(&es->es_if);
			panic("ieobfree");
		}
		if (es->es_base) {
			kmem_free(es->es_base, (u_int)es->es_memsize);
			es->es_base = (caddr_t)0;
		}
	}
}

/*
 * Basic 82586 initialization
 */
int
iechipinit(es)
	register struct ie_softc *es;
{
	struct ieiscp		*iscp = es->es_iscp;
	struct iescb		*scb = es->es_scb;
	register struct iecb	*cb;
	register struct ieconf	*ic;
	int ok = 0;
	int gotintr;
#ifdef notdef
	struct ietdr	*tdr;
#endif notdef

reset:
	bzero((caddr_t)es->es_scp, sizeof (struct iescp));
	es->es_scp->ies_iscp = to_ieaddr(es, (caddr_t)iscp);

	bzero((caddr_t)iscp, sizeof (struct ieiscp));
	iscp->ieis_busy = 1;
	iscp->ieis_cbbase = to_ieaddr(es, es->es_base);
	iscp->ieis_scb = to_ieoff(es, (caddr_t)scb);

	/*
	 * Set the scb's ie_magic field and never touch it again.
	 * This allows us to check for rogue behavior in the chip's
	 * DMA unit by looking for changes in this field.
	 */
	bzero((caddr_t)scb, sizeof (struct iescb));
	scb->ie_magic = IEMAGIC;

	/*
	 * Hardware reset the chip.  We make the interval from
	 * reset to initial channel attention as small as reasonable
	 * to reduce the risk of scribbling chips getting us.
	 */
	switch (es->es_type) {
	case IE_MB:
		/* Hardware reset already occurred in iechipreset. */
		break;

	case IE_OB:
		es->es_obie->obie_noreset = 1;
		DELAY(IEKLUDGE);		/* REQUIRED */
		break;
	}
	ieca(es);
	CDELAY(!iscp->ieis_busy, IEDELAY);	/* ensure chip eats iscp */
	CDELAY(scb->ie_cnr, IEDELAY);		/* ensure scb updated too */
	gotintr = iewaitintr(es);		/* wait for interrupt */
	if (iscp->ieis_busy || !scb->ie_cnr || !gotintr) {
		identify(&es->es_if);
		printf("init failed:%s%s%s\n",
		    iscp->ieis_busy	? " iscp busy" : "",
		    !scb->ie_cnr	? " no cnr" : "",
		    !gotintr		? " no intr" : "");
		goto exit;
	}
	if (scb->ie_cus != IECUS_IDLE ) {
		identify(&es->es_if);
		printf("cus not idle after reset\n");
		iechipreset(es);
		goto reset;
	}

	cb = synccb_res(es, struct iecb *);
#ifdef	DEBUGIE
	if (!cb) {
		identify(&es->es_if);
		panic("iechipinit: nested synccmd");
	}
#endif	DEBUGIE
	bzero((caddr_t)cb, sizeof (struct iecb));
	cb->iec_cmd = IE_DIAGNOSE;
	iesynccmd(es, cb);
	if (!cb->iec_ok) {
		identify(&es->es_if);
		printf("Intel 82586 failed diagnostics\n");
		synccb_rel(es);
		goto exit;
	}
	synccb_rel(es);

	/*
	 * Perform TDR test.
	 */
#ifdef notdef
	/* Skip, since hardware requires quiet net to work. */
	tdr = synccb_res(es, struct ietdr *);
#ifdef	DEBUGIE
	if (!tdr) {
		identify(&es->es_if);
		panic("iechipinit: nested synccmd 2");
	}
#endif	DEBUGIE
	bzero((caddr_t)tdr, sizeof (struct ietdr));
	tdr->ietdr_cb.ie_cmd = IE_TDR;
	iesynccmd(es, &tdr->ietdr_cb);
	if (!tdr->ietdr_ok) {
#define	TDRCONST	12	/* approx 0.77c/10Mhz */
		int dist = (tdr->ietdr_timhi<<8) + tdr->ietdr_timlo;
		identify(&es->es_if);
		if (dist != 0x7FF)
			printf("link not OK - distance ~ %dm\n",
				TDRCONST*dist);
		else
			printf("link not OK\n");
		synccb_rel(es);
		goto exit;
	}
	if (tdr->ietdr_xcvr) {
		identify(&es->es_if);
		printf("transceiver bad\n");
	}
	if (tdr->ietdr_open) {
		identify(&es->es_if);
		printf("net not terminated\n");
	}
	if (tdr->ietdr_shrt) {
		identify(&es->es_if);
		printf("net shorted\n");
	}
	synccb_rel(es);
#endif notdef

	/* Establish default chip operating characteristics. */
	ic = synccb_res(es, struct ieconf *);
#ifdef	DEBUGIE
	if (!ic) {
		identify(&es->es_if);
		panic("iechipinit: nested synccmd 3");
	}
#endif	DEBUGIE
	iedefaultconf(ic);
	iesynccmd(es, &ic->ieconf_cb);
	synccb_rel(es);
	ok = 1;

exit:
	return (ok);
}

/*
 * Initialize and start the Receive Unit.  Assumes that descriptor
 * and buffer memory is already allocated.
 */
ierustart(es)
	register struct ie_softc *es;
{
	register struct ierbd *rbd;
	register struct ierfd *rfd;
	register struct iescb *scb;
	register struct ierbuf *rbp;

	/* Initialize receive buffers. */
	for (rbp = es->es_rbuf_free; rbp; rbp = rbp->ierbuf_next) {
		/* Set back pointer to softc structure. */
		rbp->ierbuf_es = es;
	}

	/* Initialize rbds. */
	for (rbd = es->es_rbdhd; ; ) {
		/*
		 * If the rbd doesn't yet have an rbuf
		 * attached to it, hook one on.
		 */
		if (!rbd->ierbd_rbuf) {
			if (!(rbp = es->es_rbuf_free)) {
				identify(&es->es_if);
				panic("ierustart: not enough rbufs");
			}
			es->es_rbuf_free = rbp->ierbuf_next;
			rbd->ierbd_rbuf = rbp;
			rbd->ierbd_buf = to_ieaddr(es,
					(caddr_t)rbp->ierbuf_data);
			rbd->ierbd_sizehi = IE_BUFSZ >> 8;
			rbd->ierbd_sizelo = IE_BUFSZ & 0xff;
		}

		rbd->ierbd_status = 0;

		/* Impose chip-recognizable list structure. */
		if (rbd == es->es_rbdtl) {
			rbd->ierbd_el = 1;
			break;
		}
		else {
			rbd->ierbd_el = 0;
			rbd = rbd->ierbd_link;
		}
	}

	/* Initialize rfds. */
	for (rfd = es->es_rfdhd; ; ) {
		rfd->ierfd_status = 0;
		rfd->ierfd_susp = 0;
		rfd->ierfd_rbd = IENULLOFF;

		/* Impose chip-recognizable list structure. */
		if (rfd == es->es_rfdtl) {
			rfd->ierfd_el = 1;
			break;
		}
		else {
			rfd->ierfd_el = 0;
			rfd = rfd->ierfd_link;
		}
	}

	/*
	 * We must tell the chip where the first frame's first
	 * rbd is.  It is responsible for setting this field in
	 * subsequent frames.
	 */
	rfd = es->es_rfdhd;
	rfd->ierfd_rbd = to_ieoff(es, (caddr_t)es->es_rbdhd);

	/* Kick the chip to get the RU going. */
	scb = es->es_scb;
	if (scb->ie_rus != IERUS_IDLE) {
		identify(&es->es_if);
		printf("RU unexpectedly not idle\n");
		iestat(es);
		iechkcca(es);
		scb->ie_cmd = IECMD_RU_ABORT;
		ieca(es);
	}
	iechkcca(es);
	scb->ie_rfa = to_ieoff(es, (caddr_t)rfd);
	scb->ie_cmd = IECMD_RU_START;
	ieca(es);
	CDELAY(scb->ie_rus == IERUS_READY, IEDELAY);
	if (scb->ie_rus != IERUS_READY) {
		identify(&es->es_if);
		printf("RU did not become ready\n");
	}
}

/*
 * Put a CB on the CBL.  The old list-end marker is left
 * undisturbed, so the chip's CU won't start to process
 * the newly-entered cb.  Iecustart worries about moving
 * the list end marker to the (new) end of the list.
 */
iedocb(es, cb)
	register struct ie_softc *es;
	register struct iecb *cb;
{
	register int s = splie();

	cb->iec_status = 0;	/* clear status bits */
	cb->iec_susp = 0;	/* clear suspend bit */
	cb->iec_el = 1;		/* will be reset in iecustart */
	cb->iec_intr = 1;
	cb->iec_next = 0;
	if (es->es_cbhead) {
		es->es_cbtail->iec_next = to_ieoff(es, (caddr_t)cb);
		es->es_cbtail = cb;
	} else {
		es->es_cbhead = es->es_cbtail = cb;
	}
	(void) splx(s);
}

/*
 * Start the CU with the current CBL.
 */
iecustart(es)
	register struct ie_softc *es;
{
	register struct iecb *cb;
	register struct iescb *scb = es->es_scb;
	int s = splie();
		
	iechkcca(es);
	/*
	 * See whether there's anything to do.  The second clause
	 * of this test has the effect of squashing out some potential
	 * parallelism between chip and driver.  Without it, we would
	 * go ahead and add CBs to the list (as the chip sees it) while
	 * the chip is still processing it.  Provided that the rest
	 * of the driver obeys the proper protocol for accessing CBs,
	 * there's no reason for this clause other than paranoia.
	 */
	if (es->es_cbhead == NULL || scb->ie_cus == IECUS_READY) {
		(void) splx(s);
		return;
	}

	/* Trim and reclaim completed CBs from the front of the list. */
	iecuclean(es);

	/* Strip list-end markers from the interior of the list. */
	if ((cb = es->es_cbhead) == NULL) {
		(void) splx(s);
		return;
	}
	while (cb && cb->iec_next) {
		cb->iec_el = 0;
		cb = (struct iecb *)from_ieoff(es, (ieoff_t)cb->iec_next);
	}

	/* Start CU. */
	scb->ie_cbl = to_ieoff(es, (caddr_t)es->es_cbhead);
	scb->ie_cmd = IECMD_CU_START;
	ieca(es);
	(void) splx(s);
}

/*
 * Process completed CBs, reclaiming specified storage.
 * Allocator is responsible for reclaiming other storage.
 * Called by iecustart at splie and by iecbdone at splie or hardware level 3.
 */
iecuclean(es)
	register struct ie_softc *es;
{
	register struct iecb *cb;
		
	while ((cb = es->es_cbhead) && cb->iec_done) {
		es->es_cbhead = cb->iec_next
			? (struct iecb *) from_ieoff(es, (ieoff_t)cb->iec_next)
			: (struct iecb *) 0;

		/*
		 * Unless the command was run synchronously, it should be
		 * one of the two below.  Anything else indicates trouble.
		 */
		switch (cb->iec_cmd) {
		case IE_TRANSMIT:
			iexmitdone(es, (struct ietfd *)cb);
			break;
		case IE_NOP:
			untimeout(iebark, (caddr_t)es);
			break;
		default:
#ifdef	DEBUGIE
			if (es->es_synccmd != 1) {
				identify(&es->es_if);
				printf("unknown cmd %x done\n", cb->iec_cmd);
			}
#endif	DEBUGIE
			break;
		}
	}
}

/*
 * Clean up and restart the CBs on the CBL.
 * Called by ieintr at hardware level 3 and by iesynccmd at splie.
 */
iecbdone(es)
	register struct ie_softc *es;
{

	iecuclean(es);
	/* generate more CBs */
	iestartout(es - ie_softc);
}

/*
 * Do the command contained in cb synchronously, so that we know
 * it's complete upon return.  The control block given as argument
 * should be obtained with synccb_res and released with synccb_rel.
 */
iesynccmd(es, cb)
	register struct ie_softc *es;
	register struct iecb *cb;
{
	register struct iescb *scb = es->es_scb;
	int s, cmd = 0;

	/* Fire it up. */
	iedocb(es, cb);
	iecustart(es);

	/* Give it a chance to complete. */
	CDELAY(cb->iec_done, IEDELAY);
	if (!cb->iec_done) {
		iestat(es);
		panic("iesynccmd");
	}

	/* Acknowledge status information from the chip. */
	s = splie();
	iechkcca(es);
	if (scb->ie_cx)
		cmd |= IECMD_ACK_CX;
	if (scb->ie_cnr)
		cmd |= IECMD_ACK_CNR;
	scb->ie_cmd = cmd;
	ieca(es);

	/*
	 * ??? Is it really appropriate to start the chip up here?
	 */
	if (cmd & (IECMD_ACK_CNR|IECMD_ACK_CX))
		iecbdone(es);

	(void) splx(s);
}

/*
 * Repossess a loaned-out receive buffer.
 *	Called from within MFREE by the loanee when disposing
 *	of the cluster-type mbuf wrapped around the buffer.
 *
 *	Assumes called with lists locked.
 */
ieclfree(rbp)
	register struct ierbuf	*rbp;
{
	register struct ie_softc	*es;

#ifdef	DEBUGIE
	if (!rbp)
		panic("iecfree");
#endif	DEBUGIE

	es = rbp->ierbuf_es;
#ifdef	DEBUGIE
	if (!es) {
		printf("rbp: %x\n", rbp);
		panic("ieclfree 2");
	}
#endif	DEBUGIE

	/*
	 * Put it back on the free list.
	 */
	rbp->ierbuf_next = es->es_rbuf_free;
	es->es_rbuf_free = rbp;

#ifdef	DEBUGIE
	if (es->es_loaned == 0) {
		identify(&es->es_if);
		panic("ieclfree 4");
	}
#endif	DEBUGIE
	es->es_loaned--;
}

/*
 * Delay until the 82586 has accepted the current
 * command word.  Watch for buggy hardware while at it.
 */
iechkcca(es)
	register struct ie_softc	*es;
{
	register struct iescb *scb = es->es_scb;
	register int i;

	for (i = 0; i < IEDELAY; i++) {
		if (scb->ie_magic != IEMAGIC) {
			/* Something's writing where it shouldn't... */
			identify(&es->es_if);
			panic("scb overwritten");
		}
		if (scb->ie_cmd == 0)
			break;
	}
	if (i >= IEDELAY) {
		identify(&es->es_if);
		printf("cmd not accepted\n");
		panic("iechkcca");
	}
}

int iefifolim = 12;
/*
 * Set default configuration parameters.
 */
iedefaultconf(ic)
	register struct ieconf *ic;
{
	bzero((caddr_t)ic, sizeof (struct ieconf));
	ic->ieconf_cb.iec_cmd = IE_CONFIG;
	ic->ieconf_bytes = 12;
	ic->ieconf_fifolim = iefifolim;
	ic->ieconf_pream = 2;		/* 8 byte preamble */
#ifdef	IE_FDADDR
	ic->ieconf_acloc = 0;
#else	IE_FDADDR
	ic->ieconf_acloc = 1;
#endif	IE_FDADDR
	ic->ieconf_alen = 6;
	ic->ieconf_space = 96;
	ic->ieconf_slttmh = 512 >> 8;
	ic->ieconf_minfrm = 64;
	ic->ieconf_retry = 15;
	ic->ieconf_crfilt = 3;
}

/*
 * Activate the channel attention line.
 */
ieca(es)
	register struct ie_softc *es;
{
	if (es->es_type == IE_MB) {
		es->es_mie->mie_ca = 1;
		es->es_mie->mie_ca = 0;
	} else {
		es->es_obie->obie_ca = 1;
		es->es_obie->obie_ca = 0;
	}
}

/*
 * Wait for an interrupt and relay results.
 */
int
iewaitintr(es)
	register struct ie_softc *es;
{
	register struct obie_device *obie = es->es_obie;
	register struct mie_device *mie = es->es_mie;
	int ok;

	switch (es->es_type) {
	case IE_OB:
		CDELAY(obie->obie_intr, IEDELAY);
		ok = obie->obie_intr;
		break;

	case IE_MB:
		CDELAY(mie->mie_intr, IEDELAY);
		ok = mie->mie_intr;
		break;
	}
	return (ok);
}

/*
 * Cut the chip out of the loop and halt it by starting the reset cycle.
 * For IE_MB, we must enable pagemaps, hence we complete the reset cycle.
 */
iechipreset(es)
	register struct ie_softc *es;
{

	switch (es->es_type) {
	case IE_MB:
		es->es_mie->mie_reset = 1;
		DELAY(IEKLUDGE);			/* REQUIRED */
		*(char *)&es->es_mie->mie_status = 0;	/* power on reset */
		break;

	case IE_OB:
		*(char *)es->es_obie = 0;		/* power on reset */
		break;

	default:
		identify(&es->es_if);
		panic("iechipreset");
	}
}

/*
 * Splice the chip into the loop.
 */
iesplice(es)
	register struct ie_softc *es;
{
	switch (es->es_type) {
	case IE_MB:
		es->es_mie->mie_ie = 1;		/* enable chip interrupts */
		es->es_mie->mie_pie = 1;	/* enable parity interrupts */
		es->es_mie->mie_noloop = 1;	/* enable cable */
		break;

	case IE_OB:
		es->es_obie->obie_ie = 1;	/* enable interrupts */
		es->es_obie->obie_noloop = 1;	/* enable cable */
		break;
	}
}


/*
 * Routines for interconverting chip and host addresses.
 */

/*
 * Return chip's idea of given address or 0 if not chip accessible.
 */
ieaddr(es, cp)
	register struct ie_softc *es;
	register caddr_t cp;
{
	register int pte = getkpgmap(cp);

	if (es->es_type == IE_OB) {
		/*
		 * Onboard ie may only reference on board memory.
		 * Unfortunately, this test is necessary.  When
		 * packets pass through a geteway, it's quite possible
		 * that an mbuf loaned from a buffer on an IE_MB ie
		 * board can make its way into an mbuf chain to be
		 * transmitted.
		 */
		if ((pte & PGT_MASK) != PGT_OBMEM)
			cp = (caddr_t)0;
#ifndef sun2
/* #ifdef	DEBUGIE */
		/*
		 * Since memspace == KERNELBASE for the OB case,
		 * this test can't succeed unless the address is
		 * outside of the kernel's address space.
		 */
		else if (cp < es->es_memspace) {
			identify(&es->es_if);
			printf("ieaddr: address %x not in memspace\n", cp);
			cp = (caddr_t)0;
		}
/* #endif	DEBUGIE */
		else
			cp -= (u_long)es->es_memspace;
#endif sun2
		return ((int)cp);
	}

	/* IE_MB */
	pte &= PG_PFNUM;
	if (pte >= es->es_paddr && pte < es->es_paddr + btoc(es->es_memsize))
		return ((pte - es->es_paddr) << CLSHIFT) + ((int)cp & CLOFSET);
	return (0);
}

/* 
 * Change 68000 address to Intel 24-bit address.
 * We take advantage of the fact that all 82586 blocks with 24-bit
 * addresses have an adjacent unused 8-bit field, and store 32 bits.
 */
ieaddr_t
to_ieaddr(es, cp)
	struct ie_softc *es;
	caddr_t cp;
{
	union {
		int	n;
		char	c[4];
	} a, b;

	a.n = ieaddr(es, cp);		/* necessary for double mapping */
	b.c[0] = a.c[3];
	b.c[1] = a.c[2];
	b.c[2] = a.c[1];
	b.c[3] = 0;
	return (b.n);
}

/* 
 * Change 68000 address to Intel 24-bit address -- optimized version.
 * This routine can be used when cp has been obtained from an earlier
 * call to ieaddr.  The idea is to avoid unnecessary calls to ieaddr,
 * whose aggregate cost is large enough to notice.
 */
ieaddr_t
to_ieaddr_opt(cp)
	int	cp;	/* Fast and loose with coercions... */
{
	union {
		int	n;
		char	c[4];
	} a, b;

	a.n = cp;
	b.c[0] = a.c[3];
	b.c[1] = a.c[2];
	b.c[2] = a.c[1];
	b.c[3] = 0;
	return (b.n);
}

caddr_t
from_ieaddr(es, n)
	struct ie_softc *es;
	ieaddr_t n;
{
	union {
		int	n;
		char	c[4];
	} a, b;

	a.n = n;
	b.c[0] = 0;
	b.c[1] = a.c[2];
	b.c[2] = a.c[1];
	b.c[3] = a.c[0];
	return (es->es_memspace + b.n);
}

ieoff_t
to_ieoff(es, addr)
	register struct ie_softc *es;
	caddr_t addr;
{
	union {
		ieoff_t	s;
		char	c[2];
	} a, b;

	a.s = (ieoff_t)(addr - es->es_base);
	b.c[0] = a.c[1];
	b.c[1] = a.c[0];
	return (b.s);
}

caddr_t
from_ieoff(es, off)
	register struct ie_softc *es;
	ieoff_t off;
{
	union {
		ieoff_t	s;
		char	c[2];
	} a, b;

	a.s = off;
	b.c[0] = a.c[1];
	b.c[1] = a.c[0];
	return (es->es_base + b.s);
}

ieint_t
to_ieint(n)
	ieint_t n;
{
	union {
		ieint_t	s;
		char	c[2];
	} a, b;

	a.s = n;
	b.c[0] = a.c[1];
	b.c[1] = a.c[0];
	return (b.s);
}


/*
 * Error handling and reporting routines.
 */

/*
 * Parity error!  Scan entire memory for errors.
 * Applicable only to IE_MB interfaces.
 */
ieparity(es)
	register struct ie_softc *es;
{
	register struct mie_device *mie = es->es_mie;
	register u_short *s, *e, x;

	identify(&es->es_if);
	printf("parity error src=%d byte=%d addr=%x\n",
		mie->mie_pesrc, mie->mie_pebyte, mie->mie_erraddr);
	mie->mie_peack = 1;
	s = (u_short *)es->es_memspace;
	e = (u_short *)(es->es_memspace + es->es_memsize);
	printf("scanning...\n");
	while (s < e) {
		x = *s;
#ifdef lint
		x = x;
#endif
		if (mie->mie_pe) {
			printf("off=%x src=%d byte=%d addr=%x\n", 
				(int)s - (int)es->es_memspace,
				mie->mie_pesrc, mie->mie_pebyte,
				mie->mie_erraddr);
			mie->mie_peack = 1;
		}
		s++;
	}
	printf("done\n");
}

iestat(es)
	struct ie_softc *es;
{
	register struct iescb *scb = es->es_scb;
	static char *cus[] = { "idle", "suspended", "ready", "<3>",
				"<4>", "<5>", "<6>", "<7>" };
	static char *rus[] = { "idle", "suspended", "no resources",
				"<3>", "ready", "<5>", "<6>", "<7>" };

	identify(&es->es_if);
	printf("scb: ");
	if (scb->ie_cx)
		printf("cx ");
	if (scb->ie_fr)
		printf("fr ");
	if (scb->ie_cnr)
		printf("cnr ");
	if (scb->ie_rnr)
		printf("rnr ");
	printf("cus=%s ", cus[scb->ie_cus]);
	printf("rus=%s\n", rus[scb->ie_rus]);
	printf("cbl=0x%x rfa=0x%x crc=0x%x aln=0x%x rsc=0x%x ovrn=0x%x\n",
		scb->ie_cbl, scb->ie_rfa,
		scb->ie_crcerrs, scb->ie_alnerrs, scb->ie_rscerrs,
		scb->ie_ovrnerrs);
	if (scb->ie_cmd)
		printf("cmd=0x%x\n", scb->ie_cmd & 0xFFFF);
}


#ifdef	DEBUGIE

/*
 * Debugging routines
 */

#ifdef lint
fake()
{
	fake();
	TraceBack();
	ieaddrs();
	debuglog(1, 2, 3, 4);
}
#endif lint

#ifdef notdef
#define	rprintf	(*romp->v_printf)
#else
#define rprintf printf
#endif

/* do a short traceback */
/* VARARGS0 */
TraceBack(place_holder)
	int place_holder;
{
	struct frame {
		struct frame *old;
		caddr_t from;
	};
	register struct frame *fp = (struct frame *)(&place_holder - 2);
	int stack = btop(fp);

	rprintf(" TraceBack:");
	while (btop(fp) == stack) {
		rprintf(" %x", fp->from);
		fp = fp->old;
	}
	rprintf("\n");
}

ieprt()
{
	ieprt_softc();
	ieprt_scb();
	ieprt_cbl();
}

ieprt_softc()
{
	struct ie_softc *es = &ie_softc[0];

	rprintf("\nsoftc: %x\n", es);
	rprintf("mie %x: %x\n", &es->es_mie, es->es_mie);
	rprintf("obie %x: %x\n", &es->es_obie, es->es_obie);
	rprintf("base %x: %x\n", &es->es_base, es->es_base);
	rprintf("scb %x: %x\n", &es->es_scb, es->es_scb);
}

ieprt_cbl()
{
	struct ie_softc *es = &ie_softc[0];
	struct iecb *cbp;

	rprintf("\ncb list: head %x tail %x\n", es->es_cbhead, es->es_cbtail);
	cbp = es->es_cbhead;
	while (cbp) {
		rprintf("cb %x\n", cbp);
		rprintf("done %x, busy %x, ok %x, aborted %x\n",
		    cbp->iec_done, cbp->iec_busy, cbp->iec_ok,
		    cbp->iec_aborted); 
		rprintf("el %x, susp %x, intr %x, cmd %x\n",
		    cbp->iec_el, cbp->iec_susp, cbp->iec_intr, cbp->iec_cmd); 
		if (cbp->iec_next) {
			cbp = (struct iecb *)from_ieoff(es,
			    (ieoff_t)cbp->iec_next);
		}
		else
			cbp = NULL;
	}
}

ieprt_scb()
{
	register struct iescb *scb = ie_softc[0].es_scb;
	static char *cus[] = { "idle", "suspended", "ready" };
	static char *rus[] = { "idle", "suspended", "no resources",
		"", "ready" };

	rprintf("\nscb %x: ", scb);
	if (scb->ie_cx) rprintf("cx ");
	if (scb->ie_fr) rprintf("fr ");
	if (scb->ie_cnr) rprintf("cnr ");
	if (scb->ie_rnr) rprintf("rnr ");
	rprintf("cus=%s ", cus[scb->ie_cus]);
	rprintf("rus=%s ", rus[scb->ie_rus]);
	rprintf("cbl %x\n", scb->ie_cbl);
	rprintf("errors: crc=%d, aln=%d, rsc=%d, ovrn=%d\n",
		scb->ie_crcerrs, scb->ie_alnerrs, scb->ie_rscerrs,
		scb->ie_ovrnerrs);
	if (scb->ie_cmd) rprintf("cmd=%x\n", scb->ie_cmd & 0xFFFF);
}

#define DBLMAX	128

struct debuglog {
	int	w;
	int	x;
	int	y;
	int	z;
} Debug[DBLMAX];
int	dblindex = DBLMAX - 1;

debuglog(w, x, y, z)
	int	w, x, y, z;
{
	struct debuglog *db = &Debug[dblindex--];

	if (dblindex == -1) {
		dblindex = DBLMAX - 1;
	}
	db->w = w;
	db->x = x;
	db->y = y;
	db->z = z;
}

prtlog()
{
	struct debuglog *db;
	int	index;

	for (index = dblindex + 1; index < dblindex + DBLMAX; index++) {
		db = &Debug[index % DBLMAX];
		rprintf("%x %x %x %x\n", db->w, db->x, db->y, db->z);
	}
}


ieaddrs()
{
	rprintf("ieprt = %x\n", ieprt);
	rprintf("ieprt_softc = %x\n", ieprt_softc);
	rprintf("ieprt_scb = %x\n", ieprt_scb);
	rprintf("ieprt_cbl = %x\n", ieprt_cbl);
	rprintf("prtlog = %x\n", prtlog);
}

iechkmbuf(m)
	register struct mbuf *m;
{
	while (m) {
		if ((m->m_type != 1 && m->m_type != 2) || m != dtom(m))
			panic("iechkmbuf");
		m = m->m_next;
	}
}

/*
 * Print out the contents of the transmit buffer descriptor
 * chain rooted at tfd->ietfd_tbd.
 */
iedumptbds(es, tfd)
	struct ie_softc	*es;
	struct ietfd	*tfd;
{
	register struct ietbd	*tbd,
				*ntbd;
	register caddr_t	bufp;

	printf("\nietbd chain starting from tfd at 0x%x\n", tfd);

	tbd = (struct ietbd *) from_ieoff(es, tfd->ietfd_tbd);
	for ( ; tbd; tbd = ntbd) {
		if (tbd->ietbd_next)
			ntbd = (struct ietbd *) from_ieoff(es,
				(ieoff_t) tbd->ietbd_next);
		else
			ntbd = (struct ietbd *) 0;
		bufp = from_ieaddr(es, tbd->ietbd_buf);

		printf("\tat: %x, cntlo: 0x%x, cnthi: 0x%x, eof: %d\n",
			tbd, tbd->ietbd_cntlo, tbd->ietbd_cnthi, tbd->ietbd_eof);
		printf("\t  next: 0x%x (0x%x), buf: 0x%x link: %d\n",
			ntbd, tbd->ietbd_next, bufp, tbd->ietbd_link);
	}
}

#endif	DEBUGIE
#endif	NIE > 0
