|
|	%W%	(%G% %U%)
|
|init bootstrap

	.text
	.globl	_main, _end, _edata

|
|	Configuration information
|
PROMSIZE =	0x8000		| PROM size, in bytes, for 2 PROMs
				| 2732 = 0x2000, 2764 = 0x4000, 27128 = 0x8000
LONGSIZE =	0x2000		| PROM size in longwords
				|   == PROMSIZE/4
|
|	The following instruction must be the first in the boot PROM and
|	must always load "sp" with the value 0x20000-2.  This is because
|	the diagnostic or monitor PROMs look for this instruction to see
|	if the boot PROMs exist.
|
start:	movl	#0x20000-2,sp	| initialize stack pointer
	bsr	getpc		| put next pc onto the stack
getpc:	movl	sp@+,d0		| put pc into d0
	subl	#getpc-start,d0	| subtract offset
	movl	d0,a0
	movl	#start,a1	| destination address
	movl	#LONGSIZE-1,d0  | copy all of both EPROMs
1$:	movl	a0@+,a1@+
	dbra	d0,1$

| The following transfers control from the PROM to the copy in RAM
| by "pushing" the RAM addr of cont onto stack, and returning!
	movl	#cont,a7@-	| push cont on stack
	rts                     | long jump

| Now executing out of RAM
cont:
	movl	#start+PROMSIZE+PROMSIZE-2,sp	| initialize stack pointer
	movl	#_end,d0	| clear bss
	movl	#_edata,a0	| clear bss
1$:	movl	#0,a0@+		| clear bss
	cmpl	d0,a0		| clear bss
	jcs	1$		| clear bss
	jsr	_machdep	| initialize segment map
	jsr	_main
	bra	cont
