/*
 * Boot from a fast boot floppy.  The format of a fast boot floppy is
 * as follows:
 *	blocks 0 to 98:			unused
 *
 *	block 99:			first four bytes are size of UNIX
 *					in blocks
 *
 *	blocks 100 to whatever:		UNIX
 */
ffboot()
{
	char * uaddr;
	int count;
	int size;
	int c,h,s;

	printf( "Fast floppy boot..." );
	cfccmd( 0, 0x400, 0, 0, 1, 1);
	btochs( 99, &c, &h, &s );
	cfccmd( 0, 0x400, c, h, s, 1);
	size = *(int *)0x400;
	printf( "UNIX is %d tracks long\n", ( 7 + size ) / 8 );
	uaddr = (char *)0x400;
	count = 0;
	while( count <= size )
	{
		btochs( count+100, &c, &h, &s );
		cfccmd( 0, uaddr, c, h, s, 9-s );
		putchar( '.' );
		uaddr += ( 9 - s ) * 512;
		count += 9 - s;
	}
	putchar( '\n' );
	(*((void (*)())0x400))();
}

btochs( block, cp, hp, sp )
	int block;
	int *cp, *hp, *sp;
{
	*cp = block / 16;
	block -= 16 * *cp;
	*hp = block / 8;
	block -= 8 * *hp;
	*sp = block + 1;
}
