/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 *  Kernel trap handler for process-invoked traps.
 *  Changes to this file need to be coordinated with
 *  the C kernel trap definitions for programs.
 *
 * Also note that C functions do not save registers r0-r5, even if they use
 * them.
 *
 * $Revision: 1.18.1.8 $
 * $Locker:  $
 * $State: Exp $
 */
#include "asmdefines.h"  /* Defines offsets for assembly language. */
#include "asmdefs.h"
#include "externals.h"
#include "process.h"

#include "processor.h"

#include "ipc.h"        /* KForward, KReceiveSpecific, KSend,
                           KReply, KGetReply*/

/* Message-register traps.
 * The kernellib routines in each process save r2-r11.
 * The VAX C convention does not require r0-r1 to be saved across func. calls.
 */
asm("   .globl  Asm_Invoke_trap");


void
PrintMessage( pd )
    register Process *pd;
  {
    register int *i = (int *)&pd->msg;

    printx("Invoke(%x) -> %x: %x %x %x %x %x %x %x %x",
	pd->pid, pd->blocked_on, i[0], i[1], i[2], i[3],
	i[4], i[5], i[6], i[7]);

    printx(":%x.%x %x.%x\n", pd->srcSegment.ptr, pd->srcSegment.size,
	   pd->dstSegment.ptr, pd->dstSegment.size);
  }
void
PrintInvoke( pd )
    register Process *pd;
  {
    printx("Invoke: src %x, dest %x destsize %x maxtime %d\n",
           pd->srcSegment.ptr, pd->dstSegment.ptr, pd->dstSegment.size,
           pd->maxTimeout );
    PrintMessage( pd );
    Addready( pd );
  }
/*****************************************************/
void
Invoke_trap()
  {
    asm("Asm_Invoke_trap:");

    asm("       mfpr    $esp,r2");    /* Get ptr to per-processor record */
    asm("       movl    _PR_ACTIVE(r2),r2");    /* r2 = active */
    asm("       movl    (sp)+, _PC(r2)");
    asm("       movl    (sp)+, _STATUS(r2)");
    asm("       mfpr    $usp, _USER_STACK_PTR(r2)");
    /* save segment pointers, etc. to free up registers. */
    asm("       movl    r10, _SRC_SEG_SIZE(r2)");
    asm("       movl    r11, _SRC_SEG_PTR(r2)");
    asm("       movl    ap, _DST_SEG_PTR(r2)");
    asm("       movl    r0, _DST_SEG_SIZE(r2)");
    asm("       movl    fp, _MAX_TIMEOUT(r2)" );
    enable;
    asm("       movl    r1, _SERVER_PID(r2)");
    asm("       moval   _MSG(r2), r0");
    asm("       movq    r3, (r0)+");
    asm("       movq    r5, (r0)+");
    asm("       movq    r7, (r0)+");
    asm("       movq    r9, (r0)+");
    asm("       bisl2	$_MSG_FLAG, _PD_FLAGS(r2)");
#if 0
    asm("       pushl   r2");
    asm("     calls   $1, _PrintMessage");
#endif 0

    asm("       pushl   r2");
    asm("     calls   $1, _KSend");
    
    disable;
    asm("       jmp     ActivateReadyqHead");
    /* NOTREACHED */
  }


