
/*
 * V Kernel - Copyright (c) 1981 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * The initialization routine, that eventually calls the Machine Independent
 * startup routine.  We initialize stacks and such here.
 *
 * $Revision: 1.16.1.4 $
 * $Locker:  $
 * $State: Exp $
 */

#include <Vexceptionprotocol.h>
#include <Vquerykernel.h>
#include <bootparam.h>
#include "asmdefs.h"
#include "config.h"
#include "memory.h"
#include "processor.h"
#include "process.h"
#ifdef FIREFLY
#include "firefly.h"
#endif FIREFLY

/* SCB  has to be page-aligned */
int	(*SysControlBlock[NumExceptions])() = { 0 };
int 	ProcessorNo = 0;

ProcessorRec ProcessorArray[MAX_PROCESSORS] = { 0 };


/*
 * Stacks for the primary processor. These  MUST be declared, not 
 * allocated dynamically, because the rawio routines  switch off virtual 
 * memory mapping and relay on the mapping 
 * physical(x) = virtual(80000000+x) 
 * being true for the stack on the primary processor.
 * We can allocate the stacks on other processors dynamically however because
 * only the primary processor calls the raw io routines directly.
 */
 
char 	PrimaryIStack[STACK_SIZE] = { 0 };	/* Interrupt Stack */
char 	PrimaryKStack[STACK_SIZE] = { 0 };	/* Kernel Stack */

extern ProcessorBooted;
extern void AllocateKernelStacks();

#define INIT_STACK_SIZE		128
char TempStack[INIT_STACK_SIZE];

asm("	.globl	InitStacks");

#ifdef MICROVAX
    /*
     * We rely on the compiler to put RPB, SBA, SBI sequentially in the data
     * segment, so the movc3's below do the right thing.
     */
RestartParamBlock RPB = {(char *)-1};
SecondBootArgs    SBA = {(long)  -1};
SecondBootInfo	  SBI = {(RestartParamBlock *) -1};
#endif MICROVAX

asm("	.text");
asm("	.align	1");
asm("	.globl	start");
asm("start:");
asm("	jmp	*$0f");

/* Leave space for Firefly interprocessor interrupt vectors at 0x14 and 0x50 */
asm("	.org	0x54"); 

asm("	.text");
asm("	.align	1");
asm("0:");
asm("	movl	r11, _SBI");
asm("	movl	ap, _SBI+4");
asm("	movl	sp, _SBI+8");
asm("	mfpr	$scbb, _SBI+12");
asm("	movc3	$(_SBA-_RPB), (r11), _RPB"); /* Copy these since we'll walk */
asm("	movc3	$(_SBI-_SBA), (ap) , _SBA"); /*   all over where they are.  */


asm("	jmp	*$InitStacks");

void
DummyInitStacks()
{
  register char *r11;
  register int *r10;
  register ProcessorRec *r9;
  register VAXProcessControlBlock *r8;
  register unsigned i;
  
  asm("InitStacks:");
  /*
   * Both SCBB and PCBB expect physical addresses, but we're giving them virtual
   *   addresses.  We get away with it because, the way the kernel memory map is
   *   set up, physical = virtual & 0x7fffffff, and the SCBB and PCBB ignore the
   *   the most significant bits of the address.
   */
  ;asm("	mtpr	$_SysControlBlock, $scbb");  /* to Sys Control Block*/

  r9 = &ProcessorArray[ProcessorNo];
  r8 = &r9->md.pcb;
  asm("	  mtpr r8,$pcbb");

#ifdef FIREFLY
  r9->md.pnumber = ProcessorNo;
  r9->md.ticks = 0;
#endif FIREFLY

  asm("	  mtpr	r9,$esp");
  r8->ExecSP = (Unspec) r9;

  if (ProcessorNo == 0)
    {
      r9->md.kstack = PrimaryKStack;
      r9->md.istack = PrimaryIStack;
    }
  else
    {
#ifdef FIREFLY
       r11 = &TempStack[INIT_STACK_SIZE];
       asm("movl	r11,sp");
       EnableMemMap();
       ProcessorBooted = 1;
#endif FIREFLY
    }
  

  r11 = &r9->md.kstack[STACK_SIZE];
  r8->KernelSP = r11;
  asm("	 mtpr	r11, $ksp");		     /* Set Kernel Stack pointer */

  /* Write initial fill pattern into kernel stack */
  for ( r10 = (int *) r9->md.kstack; r10 < (int *) r11; r10++)
    *r10 = (int)KERNEL_STACK_INIT_VALUE;

  r11 = &r9->md.istack[STACK_SIZE];

  /* Write initial fill pattern into interrupt stack */
  for ( r10 = (int *) r9->md.istack; r10 < (int *) r11; r10++)
    *r10 = (int)KERNEL_STACK_INIT_VALUE;

  ;asm("  movl	r11, sp");     	     	     /* Interrupt stack is the one   */
  asm("	  mtpr	sp, $isp");		     /* we're using at present	     */
  asm("	  movl	sp, fp");
  asm("	  movpsl	-(sp)");
  asm("	  bicl2	$0x04000000, (sp)");	/* clear the Interrupt stack flag */
  asm("	  pushal	onkernelstack");
  asm("	  rei");
  asm("onkernelstack:");

  if ( ProcessorNo == 0 )
    {

     /*
      * It is simpler to execute these functions before virtual memory is
      * enabled.
      */
#ifdef FIREFLY
      CopyJmpInitSecondary();
      InitInterprocessorInts();
#endif FIREFLY

      Init_memory(); 
      Init_debugger();
#ifdef FIREFLY
      if (Multiprocessor)
        AllocateKernelStacks();
#endif FIREFLY
      Init_kernel();
    }
  else
    {
#ifdef FIREFLY
      WaitForPrimaryProcessor();
      InitSecondary();
#endif FIREFLY
    }

 ; asm("	halt");
}
