/*
 * V Kernel - Copyright (c) 1985 by Stanford University
 *
 * Kernel Qvss Mouse support routines
 *
 * Note that the Mouse device supposedly is able to interrupt on mouse
 * move, but it doesn't seem to like to do that.  Also, it can interrupt
 * on mouse down, but not mouse up events.  We just poll it every Vsync
 * interrupt (~60Hz?) and eliminate all the problems.
 *
 * $Revision: 1.8.1.3 $
 * $Locker:  $
 * $State: Exp $
 */

#include <Venviron.h>
#include "interrupt.h"
#include "qvss.h"
#include "mouse.h"


/* Private */
static unsigned short	oldMouseX = 0, oldMouseY = 0;

/* Forward */


Call_inthandler(IntQvssMousePoll);

void
StartMouse() {;}

void
StopMouse() {;}

void
QvssMousePowerup()
  {
    MousePowerup();
  }

void
IntQvssMousePoll()
  {
    unsigned short mouseButtons;
    short mousePos;
    register qvss_reg_t *qvss = (qvss_reg_t *)QVSS_REGS_V;
    register unsigned short newX;
    register unsigned short newY;
    register unsigned short delta;

    /* lower our IPL to something reasonable */
    asm("	mtpr	$0x14, $ipl");
    
    mouseButtons = 7&(qvss->regs[QV_CSR]>>8);
    mousePos = qvss->regs[QV_MOUSE];
    newX = mousePos&0x0ff;
    newY = (mousePos>>8)&0x0ff;
    if (mouseButtons != MouseButtons || newX != oldMouseX || newY != oldMouseY)
      {
	if (oldMouseX > newX)
	    MouseX -= (0x80 <= (delta = oldMouseX-newX)) ? 0x100-delta : delta;
	else
	    MouseX += (0x80 <= (delta = newX-oldMouseX)) ? 0x100-delta : delta;
	if (oldMouseY > newY)
	    MouseY += (0x80 <= (delta = oldMouseY-newY)) ? 0x100-delta : delta;
	else
	    MouseY -= (0x80 <= (delta = newY-oldMouseY)) ? 0x100-delta : delta;
	oldMouseX = newX;
	oldMouseY = newY;
	MouseButtons = mouseButtons;
	MouseEvent = 1;
	CheckMouseReader();
      }

#ifdef STAR_TREK
      {	/* Play with the four LEDs on the keyboard */
	extern LK201_StarTrek();
	LK201_StarTrek();
      }
#endif STAR_TREK
  }
    
