/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * Header file describing VAX memory mapping.  Information which is peculiar
 *   to specific VAX implementations should live elsewhere.
 * Some of the magic numbers below are defined by the VAX architecture; others
 *   just reflect the way we've chosen to place the V kernel in memory.
 *
 * $Revision: 1.22.1.5 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef MEMORY_H
#define MEMORY_H

#ifndef PROCESSOR_H
# include "processor.h"
#endif

/* "Segment" isn't exactly VAX terminology, but what we mean is the P0, P1 */
/*    and system address-spaces:					   */
#define	MD_SEGMENTBITS	30
#define	MD_SEGMENTSIZE	(1<<MD_SEGMENTBITS)
#define MD_SEGMENTMASK	(MD_SEGMENTSIZE-1)

#define	MD_SegOffs(addr)	((unsigned)(addr) & (MD_SEGMENTSIZE-1))

#define	P0_SEG_NUM	0
#define	P0_SEG_START	(P0_SEG_NUM << MD_SEGMENTBITS)
#define	P1_SEG_NUM	1
#define	P1_SEG_START	(P1_SEG_NUM << MD_SEGMENTBITS)
#define	SYS_SEG_NUM	2
#define	SYS_SEG_START	(SYS_SEG_NUM<< MD_SEGMENTBITS)

/* A virtual address */
typedef struct
  {
    unsigned	offset:9,
		page:21,
		segment:2;
  } vaddr_t;

/* a physical page */
typedef union pageu
  {
    union pageu	*nextpage;
    char	byte[MD_PAGESIZE];
    short	word[MD_PAGESIZE/sizeof(short)];
    long	longword[MD_PAGESIZE/sizeof(long)];
  } Page;

/* a Page table Entry */
typedef union
  {
    unsigned	word;
    struct
      {
        unsigned pfn:21,	/* the physical page frame number */
		 unused:3,
		 mapped:1,	/* See comment by VM_MAPPED below */
		 mbz:1,
		 modified:1,	/* page modified ? */
		 protection:4,	/* protection code */
		 valid:1;	/* valid entry ? */
      } fields;
  } PageTableEntry;

/* A Qbus page map entry */
typedef union
  {
    unsigned	word;
    struct
      {
	unsigned pfn:15,	/* local pf to be used for this qbus addr */
		 unused:16,
		 valid:1;	/* valid entry ? */
      } fields;
  } QBusMapEntry;

/* Usable Protection Codes */
#define	VM_____		(0<<27)
#define	VM_RW__		(2<<27)
#define	VM_R___		(3<<27)
#define	VM_RWRW		(4<<27)
#define	VM_RWR_		(12<<27)
#define	VM_R_R_		(15<<27)
#define VM_PROTECTION_MASK	(15<<27)

/*
 * Other Page Table Entry bits.  We implement an accessed bit a la BSD UNIX.
 * When something is mapped in for the first time, or when the accessed bit
 * is to be cleared, the VM_VALID bit is cleared, and the VM_MAPPED bit
 * is set.  When the process faults on accessing the page, we set the
 * VM_VALID bit.  So accessed <==> VM_VALID && VM_MAPPED.  The other states
 * are mapped with no access <==> VM_MAPPED && !VM_VALID, and unmapped
 * which is !VM_MAPPED.  This is only relevant for user processes.
 */
#define	VM_VALID	(1<<31)	/* Defined by VAX architecture	*/
#define	VM_MAPPED	(1<<24) /* Spare bit, used by us.	*/

#ifdef	VM_DO_ACCESSED_BIT
#define	VALID_USER_PAGE VM_MAPPED
#else
#define	VALID_USER_PAGE (VM_VALID | VM_MAPPED)
#endif	VM_DO_ACCESSED_BIT

/* Probably don't need the VM_MAPPED bit for system pages, but set it anyway */
#define VALID_SYS_PAGE	(VM_VALID | VM_MAPPED)
/* The top level of a team page-table is probably just like any other system */
/*   page, but let's defer the decision by having this separate constant.    */
#define VALID_USER_PT_PAGE	VALID_SYS_PAGE

/* Probe values, for probing memory */
#define	PROBE_INIT	0
#define	PROBE_READ	1
#define	PROBE_PRESERVE	2

/* a nil page-table entry */
#define	NOPAGE		0

#define	PTES_PER_MD_PAGE	(MD_PAGESIZE / sizeof(PageTableEntry))
/* Number of bytes in a max-size P0 page-table for one team. Note that we */
/*   don't bother to round up to the next page, since it's OK to have one */
/*   team's PT start on the same page that another's ends.		  */
#define TEAM_P0PT_BYTES	 (MD_NumPages(TEAM_LIMIT     )*sizeof(PageTableEntry))

/* Number of bytes in the system page-table needed to map the P0 page-    */
/*   table for one team.  Note that if P0 page-tables for different teams */
/*   lie on the same page then the total space needed to map N teams may  */
/*   be less than N * TEAM_SYSPT_BYTES.					  */
#define TEAM_SYSPT_BYTES (MD_NumPages(TEAM_P0PT_BYTES)*sizeof(PageTableEntry))

/*
 * A crude map of the physical and system virtual address-spaces.
 *   The VAX memory manager (memory.c) initializes this structure (in
 *   Init_memory_mapping); it should be treated as read-only.
 * The VAX memory manager only knows about objects that occur in any
 *   configuration; it relies on other routines to do memory-mapping for
 *   objects that may occur only on some types of VAXen, for peripherals, and
 *   for objects whose size may vary in different configurations (e.g. team-
 *   or process-descriptors allocated during kernel initialization.  As far
 *   as the VAX memory manager is concerned, these are all lumped together in
 *   the 'config' part of the memory map.
 */

#define	BOGUS_ADDR	(char *)0xC0000000

struct memLoc
  {
    char     *phys;	/* Physical address (or BOGUS_ADDR) */
    char     *virt;	/* Virtual address		    */
    unsigned bytes;
    PageTableEntry *pte;/* First PTE (can be recalculated from virt and the */
			/*   base virtual address of the system page-table, */
			/*   but using this is quicker).		    */
  };

extern struct vaxMemoryMap
  {
    struct memLoc
	kernel,		/* Kernel code/data/bss */
	team1,		/* Team 1 code/data/bss */
	teamPTs,	/* Team page-tables (top level) */
	misc,		/* Miscellaneous page frames used by mem. manager */
	space,		/* Space for allocating kernel data structures. */
        ipcr_space,	/* Memory space for Firefly interprocessor 
                           communication registers. */
	sysPT,		/* System Page-Table */
	end;		/* Dummy to hold final values */
  }
vaxMap;

extern char *BuildSysMap_MapPhysPages _TAKES((char *, long));
extern char *BuildSysMap_LeaveSpace _TAKES((long));
extern char *BuildSysMap_Contiguous _TAKES((long));
extern char *BuildSysMap_AllocPages _TAKES((unsigned long));

	/* memory.c */
extern unsigned long	KFlags;		/* Kernel flags passed by Vload */
void Init_memory_mapping _TAKES(());
void ChangeSysPagesProtection _TAKES((unsigned,  unsigned, unsigned));
BooleanInt KernelCanRead _TAKES((unsigned, unsigned));
void EnableMemMap _TAKES(());
BooleanInt KernelCanReadByte _TAKES(( char *));
extern PageTableEntry *SysPageTable;

extern struct bhdr	KernelBheader;
extern struct bhdr	TeamBheader;
#if 0
extern Process		*AddressableProcess;	/* curr addressable process */
extern unsigned	AddressableTemp;	/* temp for SetAddressableProcess */
extern unsigned long KFlags;		/* Kernel flags passed by Vload */

extern PageTableEntry	*SysPageTable;

extern struct vaxMemoryMap vaxMap;

extern unsigned num_sysPT_entries; 		
#endif 0

#endif MEMORY_H
