/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * VAX specific (?) memory access
 *
 * $Revision: 1.3.1.3 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef MEMACCESS_H
#define MEMACCESS_H

#define MEMACCESS_PHYS 1 /* physical memory access */
#define MEMACCESS_VIRT 2 /* virtual memory access */

#define MEMACCESS_READ 10  /* read access to memory */
#define MEMACCESS_WRITE 20 /* write access to memory */


/* values returned */

/* no error in request */
#define MEMACCESS_OK 0 /* memory access request is good */

/* error in request values */
#define MEMACCESS_INVAL_MODE 1 /* an invalid access mode was requested */
#define MEMACCESS_INVAL_TYPE 2 /* an invalid access type was requested */
#define MEMACCESS_INVAL_ADDR 3 /* an invalid address was requested */
#define MEMACCESS_DENIED 4 /* access is not allowed */
#define MEMACCESS_UNKNOWN 99 /* the "impossible" error condition code */

int memaccess _TAKES(( long *, long *, int, int)); 
int KernelCanWrite _TAKES(( unsigned, unsigned));
#endif MEMACCESS_H
