/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * V kernel level debugger
 *
 * $Revision: 1.6.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

/*
	Tony Mason
	Distributed Systems Group
	Stanford University

	Creation Date: June 25, 1987

 */
#include "externals.h"
#include "debugger.h"
#include "memaccess.h"


/* Forward */
static unsigned long cvtul _TAKES(( char *));
static  int command _TAKES(());

char vkd_buf[20] = {0};
int	vkd_psl = 0; /* used by vkd to store the psl - must be extern */
int (*vkd_func[10]) _TAKES(()); /* ten external functions */
int vkd_func_cur = 0; /* current "high water" in vkd_func */
int vkd_func_limit = 10; /* maximum number allowed */

void
Init_debugger() /* initial, test phase of debugger */
{
	/* nothing for right now */
}

void
use_debugger()
{
	do printx("\nvkd>");
	while(command() != -1);
}



static  int
command() /* command interpreter */
{
	scanx(vkd_buf);
	printx("\n");
	/* q or ex == quit or exit */
	if((vkd_buf[0] == 'e' && vkd_buf[1] == 'x') || vkd_buf[0] == 'q')
	{	
		printnl("exit");
		return -1; /* this tells the debugger to quit */
	}
	/* bp == breakpoint */
	else if(vkd_buf[0] == 'b' && vkd_buf[1] == 'p')
	{
static	unsigned long vkd_address = 0;

		vkd_address = cvtul(&vkd_buf[3]);
		bp_set(vkd_address);
		printnl("breakpoint set");
		return 0;
	}
	/* bc == breakpoint clear */
	else if(vkd_buf[0] == 'b' && vkd_buf[1] == 'c')
	{
		bp_clear();
		printnl("breakpoint cleared");
		return 0;
	}
	/* di == display */
	else if(vkd_buf[0] == 'D' && vkd_buf[1] == 'i')
	{
static	unsigned long vkd_address = 0;
static	long vkd_work = 0;
		int result;

		vkd_address = cvtul(&vkd_buf[3]);
		result =
		memaccess((long *)vkd_address,&vkd_work,MEMACCESS_VIRT,MEMACCESS_READ);
		if(result == MEMACCESS_OK)
		{
			printx("%x.\n",vkd_work);
		}
		else 
		{
			printx("invalid address\n");
			printx("result = %d\n",result);
		}
		return 0;
	}
	else if(vkd_buf[0] == 'd')
	{
		unsigned long vkd_address = 0L;

		vkd_address = cvtul(&vkd_buf[3]);

		switch(vkd_buf[1])
		{
			case 'b': /* string (as in [b]uffer) */
				display(vkd_address,"s");
				break;
			case 'c': /* signed char */	
				display(vkd_address,"c");
				break;
			case 'C': /* unsigned char */
				display(vkd_address,"uc");
				break;
			case 'i': /* signed int */
				display(vkd_address,"i");
				break;
			case 'I': /* unsigned int */
				display(vkd_address,"ui");
				break;
			case 'l': /* signed long */
				display(vkd_address,"l");
				break;
			case 'L': /* unsigned long */
				display(vkd_address,"ul");
				break;
			case 's': /* signed short */
				display(vkd_address,"h");
				break;
			case 'S': /* unsigned short */
				display(vkd_address,"uh");
				break;
			default: /* choke */
				printx("Invalid command\n");
		}
	}
	else if(vkd_buf[0] == 's' && vkd_buf[1] == 'd')
	{
		StackDump();
	}
	else if(vkd_buf[0] == 'S' && vkd_buf[1] == 'd')
	{
		db_stack_dump(1);
	}
	else if(vkd_buf[0] =='p' && vkd_buf[1] == 'd')
	{
		db_proc_dump();

	}
	else if(vkd_buf[0] == 'x' && vkd_buf[1] == 'r') /* xternal routine */
	{
		int		(*vkd_func_to_use)();
		int		func_offset;

		func_offset = (int)cvtul(&vkd_buf[3]);
		vkd_func_to_use = vkd_func[func_offset];
		(*vkd_func_to_use)(); /* call the routine */
		/* if it bombs, it ain't my problem.... */
	}
	/* none of the above */
	else printx("Invalid command\n");
	return 0;
}

static unsigned long 
cvtul(string)
/* convert hex string to an unsigned long */
char *string;
{
	unsigned long work = 0;

	while(*string != '\0')
	{
		work *= 16;
		if((*string >= '0' && *string <= '9') ||
		   (*string >= 'a' && *string <= 'f') ||
		   (*string >= 'A' && *string <= 'F'))
		switch(*string)
		{
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
				work += ((*string - 'a') + 10);
				break;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
				work += ((*string - 'A') + 10);
				break;
			default:
				work += *string - '0';
				break;
		}
		string++;
	}
	return work;
}

