/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Configuration Parameters for the Kernel: sun2+ec
 *
 * $Revision: 1.19.1.4 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef CONFIG_H
#define CONFIG_H

#ifndef PROCESSOR_H
#include "processor.h"
#endif

#define MAX_PROCESSORS  5	/* Number of processors */

#define KERNEL_START	0x0	/* Kernel is loaded at this physaddress */

#define HOST_CACHE_SIZE 64	/* Number of logical host to net address
				 *  mappings kept in our cache */

/*
 * On the Firefly, cache initialization code must reside at 0x40000, so the
 * first team is loaded at the VPage following 0x40000 FOR ALL VAXEN.
 * Vload must load the first team at the correct address.
 * memory.c assumes that FIREFLY_CACHE lies between the end of the kernel
 * and the start of the first team.
 */
# define FIREFLY_CACHE 0x40000
# define PHYS_TEAM_START	(FIREFLY_CACHE + VPAGESIZE)

#define MAX_TEAMS 16		/* Maximum number of teams */
#define MAX_LOGICAL_ID	40	/* Maximum logical id for GetPid and SetPid */
#define ROOT_PRIORITY 4		/* Priority of first created process */
#define INIT_STACK 0x2000	/* Size of initial stack for root team */

/*
 * Kernel device configuration declarations.
 */

#define MAX_DEVICES	16		/* Size of device instance table.
					 *  Must be a power of 2 */
#define DEV_DIR_SIZE	13		/* Size of device directory */

/* NonLocal Operations may be "macroed" out in local kernel configuration */

#ifdef LOCAL
#define NonLocalSend(msg, pid) 0
#define NonLocalReceive( msg ) 0
#define NonLocalReply( msg, pid ) 0
#define NonLocalReceiveSpecific( msg, pid ) 0
#define NonLocalReply( msg, pid ) 0
#define NonLocalForward1( msg, from_pid, to_pid ) 0
#define NonLocalForward2( msg, from_pid, to_pid ) 0
#define NonLocalAwaitingReply( pid1, pid2 ) 0
#define NonLocalRewriteMsg( msg, pid ) 0
#define NonLocalRereadMsg( msg, pid ) 0
#define NonLocalMoveto( dest_pid, dest, src, bytes ) 0
#define NonLocalMovefrom( src__pid, src, dest, bytes ) 0
#endif LOCAL

extern BooleanInt AddPeripheral _TAKES((unsigned char));
extern int  (*FramebufferEnableVideo) _TAKES(());
void BuildSysMap_Config _TAKES(());
#endif CONFIG_H
