/*	pbuf.c	1.1	84/11/11	*/

#include "gw.h"
#include "pbuf.h"

p_init()
{
	register struct pbuf *p;
	register i;

	p = (struct pbuf *) &pbufs[0];
	for (i = 0 ; i < NBUF ; i++,p++) {
		p->p_type = 1;
		p_free(p);
	}
	pbntypes[1] = 0;
}

/*
 * Space allocation routines.
 * These are also available as macros
 * for critical paths.
 */
struct pbuf *
p_get(type)
	int type;
{
	register struct pbuf *p;

	PGET(p, type);
	return (p);
}

struct pbuf *
p_free(p)
	struct pbuf *p;
{
	register struct pbuf *q;

	PFREE(p, q);
	return (q);
}

p_freem(m)
	register struct pbuf *m;
{
	register struct pbuf *n;
	register int s;

	if (m == NULL)
		return;
	s = splimp();
	do {
		PFREE(m, n);
	} while (m = n);
	splx(s);
}

p_enq(q,p)
	register struct pqueue *q;
	register struct pbuf *p;
{
	p->p_next = 0;
	if (q->pq_tail == 0)
		q->pq_head = p;
	else
		q->pq_tail->p_next = p;
	q->pq_tail = p;
	q->pq_len++;
}

struct pbuf *
p_deq(q)
	register struct pqueue *q;
{
	register struct pbuf *p;

	if ((p = q->pq_head) == 0)
		return (0);
	if ((q->pq_head = p->p_next) == 0)
		q->pq_tail = 0;
	p->p_next = 0;
	q->pq_len--;
	return (p);
}

#ifdef debug
char	tohex[]	= "0123456789ABCDEF";

p_print(s, p)
	char *s;
	register struct pbuf *p;
{
	register u_char *cp = p->p_off;
	register i,j;

	printf("(%s) p_type %d, p_len %d, p_off %x\n",
		s, p->p_type, p->p_len, p->p_off);
	if ((dbsw & (DB_PPALL|DB_PPHEAD)) == 0)
		return;
	if (dbsw & DB_PPALL)
		i = p->p_len;
	else
		i = p->p_len > 64 ? 64 : p->p_len;
	for (j = 0 ; j < i ; j++) {
		putchar(tohex[(*cp>>4)&0xF]);
		putchar(tohex[*cp++ & 0xF]);
		putchar(' ');
		if ((j&0xF) == 0xF)
			putchar('\n');
	}
	if ((j&0xF) != 0)
		putchar('\n');
}
#endif
