refresh	=	1		| enable refresh hooks
	.if	nz,refresh
	.insrt	"gwasm.h"

|
| SUN board memory refresh hooks (hacks!)
|
| Unfortunately, our processor board uses a timer interrupt at level 7
| (non-maskable) to perform RAM refresh.  256 bytes must be read every 2 msec
| to prevent memory decay.  During critical sections of the applebus code,
| these refresh interrupts are "disabled" and the refreshing is performed
| inside the inner loops.  If this was not done, the normal refresh interrupt
| would consume about 100 usec every 2 msec, causing applebus 
| underruns/overruns.  (As you know, the applebus IO rate is 230.4 kbaud
| or 35 usec per byte;  since packets can be up to 603 bytes, a long
| transmission might take up to 21 msec.)
|

	.macro	_ref_off	| turn off refresh
	movl	#refshort,refvec
	.endm
	.macro	_ref_on		| turn on refresh
	jsr	refon
	.endm
	.macro	_ref_some	| refresh the next n bytes
	tstl	a1@+
	tstl	a1@+
	tstl	a1@+
	tstl	a1@+
	.endm
	.macro	_ref_one	| refresh a little bit
	tstw	a1@+
	.endm
	.macro	_ref_all	| refresh all memory rows (256 bytes)
	jsr	nop256
	.endm
	.macro	_ref_seta1	| clear a1 to initial value
	movl	#nop256,a1
	.endm

	.data
refints:
	.byte	0,0		| (1 byte) # of deferred refresh interrupts
refvecsave:
	.long	0		| save area for default refresh vector
	.text

|
| refon - called by macro _ref_on to turn default refresh back on.
|

refon:	movl	refvecsave,refvec
	movl	d1,sp@-
	clrl	d1
	movb	refints,d1	| were any refreshes "defered"?
	beqs	10$		| if none came in
	addl	d1,d1		| double to get milliseconds
	addl	d1,msclock	| bump global counter
	clrb	refints
	cmpl	#globptr,a1
	bges	20$		| if we've already done enough
	jsr	nop256		| brush those teeth!
20$:
	_ref_seta1
10$:
	movl	sp@+,d1
	rts

|
| refshort - "short" refresh routine run during critical sections.
|

refshort:
	movw	#0xff41,0x800002	| load src into counter 'watchdog' (1)
	movw	#0xffe3,0x800002	| clear counter 'refresh' output (3)
	addqb	#1,refints
	rte				| about 18 usec total

	.iff			| else no refresh needed

	.macro	_ref_off	| turn off refresh
	.endm
	.macro	_ref_on		| turn on refresh
	.endm
	.macro	_ref_some	| refresh the next n bytes
	.endm
	.macro	_ref_one
	.endm
	.macro	_ref_all	| refresh all memory rows (256 bytes)
	.endm
	.macro	_ref_seta1	| clear a1 to zero
	.endm

	.endc			| refresh
