| (this file was pieced together from mpp, mppmacros, mppdefs, lapdefs)

stats       =       1                   | gather statistics if 1

|
| _AssumeEq  Arg1, Arg2 -- macro to generate a compile-time error if two
|                          arguments are unequal.
|
|         To optimize code size, we will be making various assumptions,
|         mainly as to offset values. This macro is a way of formalizing
|         those assumptions within the code.
|
	.macro	_assumeeq,a,b
	.if	ne,[[a]-[b]]
	assumeeq error a b
	.endc
	.endm

|
| _StatCount Arg1 -- increment a statistics count if stat keeping is enabled
|
|         Assumes A2 points to the driver variables
|
	.macro	_statcount,var
	.if	df,stats
	addql	#1,a2@(var)
	.endc
	.endm

|	.insrt	"mppdefs.h"

|__________________________________________________
|
| definitions for applebus link access protocol (ablap)
|__________________________________________________

|
| lap header:
|
|                   +------------------+
|                   |  dest node addr  |
|                   +------------------+
|                   | source node addr |
|                   +------------------+
|                   |   level 1 type   |
|                   +------------------+
|
| symbolic offsets are defined relative to the start of the header:
|
lapdstadr       =       0               | destination node address
lapsrcadr       =       1               | source node address
laptype         =       2               | lap type field

laphdsz         =       3               | size of lap header


|____________________
|
| local definitions
|____________________

rhasize   =         32			| size of read header area
whasize   =         rhasize             | size of write header area
wdsentrysz =        6                   | size of a write data structure entry

|	.insrt	"lapdefs.h"

|_________________________________________________________________
|
| lapdefs - equates for ablap part of mpp
|       (.include after mppdefs)
|
| march-april, 1984
| larry kenyon and alan oppenheimer
| version 1.0a  as listed for developer's conference
| version 0.2a  back from lk 4/30/84
| version 0.1a
|
| copyright (c) 1984 apple computer
|_________________________________________________________________

|   lap error codes (we're using system numbers so we can use moveq's)

overrunerr  =       -1
crcerr      =       -2
underrunerr =       -3
atterr      =       -4                  | error in attach call
deterr      =       -5                  | error in detach call
excessdefers =      -6
excesscollsns =     -7

|   (1) data link protocol values
|   (2) scc write register equates
|   (3) scc read register status codes

|_______________________________________|
|                                       |
| (1) data link protocol values         |
|_______________________________________|

dstadros    =       0                   | offset in segment
srcadros    =       1
laptypeos   =       2                   | type field

lapenq      =       /81                 | enquire whether station address in use
lapack      =       /82                 | say it is
laprts      =       /84                 | request to send
lapcts      =       /85                 | clear to send

qlapenq     =       -127                | equates for moveq
qlapack     =       -126
qlaprts     =       -124
qlapcts     =       -123
            .page
|_______________________________________|
|                                       |
| (2) scc write register equates        |
|_______________________________________|

|___________________|
|                   |
| wr0 commands      |
|___________________|

restxcrc    =       /80                 | reset transmit crc generator
resetund    =       /c0                 | reset underrun latch
reseterr    =       /30                 | reset errors
resetius    =       /38                 | reset highest outstanding interrupt
reenbint    =       /20                 | re-enable first character interrupts
resetext    =       /10                 | reset external interrupts

|___________________|
|                   |
| wr1 commands      |
|___________________|
                                        | wr1 commands - receive interrupt control
extie       =       /01                 | external (mouse) interrupt enable
rxie        =       /08                 | first character interrupt enable

|___________________|
|                   |
| wr3 commands      |
|___________________|
                                        | wr3 commands - receiver control
enbrxslv    =       /dd                 | enable receiver in search mode
disrx       =       /d0                 | disable receiver

|___________________|
|                   |
| wr4 commands      |
|___________________|

sdlcmode    =       /20                 | sdlc mode

|___________________|
|                   |
| wr5 commands      |
|___________________|
                                        | wr5 commands - transmitter control
distxrts    =       /60                 | disable transmitter and drivers
enbtxrts    =       /6b                 | enable transmitter and drivers
enbrts      =       /62                 | just enable drivers

|___________________|
|                   |
| wr6 is addr reg   |
|___________________|

addrreg     =       6

|___________________|
|                   |
| wr7 is sdlc flag  |
|___________________|

sdlc        =       /7e                 | 01111110

|___________________|
|                   |
| wr9 commands      |
|___________________|
                                        | wr9 commands - master resets
reseta      =       /80                 | reset channel a
mie         =       /0a                 | master interrupt enable

|___________________|
|                   |
| wr10 commands     |
|___________________|

setfm0      =       /e0                 | use fm0 transmission
setnrz      =       /00                 | use nrz (reset state)

|___________________|
|                   |
| wr11 commands     |
|___________________|

clocks      =       /70                 | dpll receive, baud rate gen. xmit

|___________________|
|                   |
| wr12, wr13 = brg  |
|___________________|

bdratelo    =       12                  | wr12 has low order part
bdratehi    =       13                  | wr13 has high order part
baudrate    =       6                   | constant for 230.4 kbaud

|___________________|
|                   |
| wr14 commands     |
|___________________|
                                        | wr14 commands - phase locked loop control
fmmode      =       /c0                 | fm mode
srchmode    =       /23                 | enter ppl search mode, enable brg
resetclks   =       /43                 | reset missing clocks, enable brg

|___________________|
|                   |
| wr15 commands     |
|___________________|
                                        | wr15 commands - external interrupt enables
dcdie       =       /08                 | dcd (mouse) interrupt enable


|_______________________________________|
|                                       |
| (3) scc read register status codes    |
|_______________________________________|

|___________________|
|                   |
| rr0 status codes  |
|___________________|

rcabit      =       0                   | receive character available bit
txemptybit  =       2                   | transmitter empty bit
hunt        =       4                   |
undrunbit   =       6                   | transmitter underrun bit

|___________________|
|                   |
| rr1 status codes  |
|___________________|

ovrrunbit   =       5                   | receiver overrun bit
crcbit      =       6                   | receiver crc error bit
eoframebit  =       7                   | end-of-frame bit
checkbits   =       /a0                 | eofr or overrun (for quick check)
ovrorcrc    =       /60                 | overrun or crc (for check at end)



|           lap variables

torha       =       0                   | top of rha
afterrha    =       torha+rhasize       | first location after the rha

packetout   =       afterrha            | (4) used for cts, rts, ack, enq 

fgoodcts    =       packetout+4         | (1) set by recvpkt if a valid cts is received
fadrinuse   =       fgoodcts+1          | (1) set if a valid packet is received when flapadrvalid=0
fsendenq    =       fadrinuse+1         | (1) flag to abuswrite that we are address hunting
destnode    =       fsendenq+1          | (1) prime flag to cdsend

backoff     =       destnode+1          | (2) global backoff mask
lbackoff    =       backoff+2           | (2) local backoff mask for one send
collsnhistory =     lbackoff+2          | (1) bit history of collisions last 8 sends
deferhistory =      collsnhistory+1     | (1) bit history of defers last 8 sends
defertries  =       deferhistory+1      | (2) local count of defers in one send
collsntries =       defertries+2        | (2) local count of collisions in one send
aqtries     =       collsntries+2       | (2) loop counter for acquireaddr

wdsptr      =       aqtries+2           | write data structure pointer
savea45     =       wdsptr+4            | a4 and a5 saved here on interrupt
abvarsend   =       savea45+8           | end of local variables

|           if we are gathering statistics, the following variables are also needed

statsstart  =       abvarsend
intcount    =       statsstart          | receive interrupt count
rcvcount    =       intcount+4          | good data packets received
xmitcount   =       rcvcount+4          | data packets transmitted
crccount    =       xmitcount+4         | bad crc (all packets)
ovrcount    =       crccount+4          | receive overruns (all packets)
rundcount   =       ovrcount+4          | recv underruns (all packets)
cnt1extra   =       rundcount+4
cnt2extra   =       cnt1extra+4
badcount    =       cnt2extra+4         | bad packets seen
collsncount =       badcount+4          | number of assumed collisions
defercount  =       collsncount+4       | times deferred to other packets
idletocount =       defercount+4        | timed out waiting for end of packet
cnt4extra   =       idletocount+4
nodtacount  =       cnt4extra+4         | no packet seen after rts in
xundcount   =       nodtacount+4	| xmit underrun count
badddp      =       xundcount+4		| bad ddp packet . . .
spurcount   =       badddp+4		| spurrious interrupts
statsend    =       spurcount+4         | <statslgcnt must be a multiple of 4!!>
statslen    =       statsend-statsstart
statslgcnt  =       statslen/4
