/*	gw.h	1.1	84/11/11	*/

/*
 * Applebus gateway definitions.
 */


typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef	unsigned short	ushort;		/* sys III compat */
typedef unsigned short	n_short;
typedef unsigned long	n_time;

#define	ntohs(a) (a)
#define	ntohl(a) (a)
#define	htons(a) (a)
#define	htonl(a) (a)

typedef	char *	caddr_t;		/* 'core' address type */
typedef long iaddr_t;			/* internet address type */

#define	NULL	0

/*
 * Network interface structure.
 */
struct ifnet {
	char	if_name[8];
	short	if_unit;
	iaddr_t	if_addr;		/* IP address */
	short	if_addrform;		/* ARP address format for IP */
	short	if_haddrlen;		/* hardware address length */
	short	if_haddrform;		/* ARP hardware addr format */
	int	(*if_output)();		/* packet output routine */
	int	(*if_matchus)();	/* match us routine */
	char	if_haddr[8];		/* big enough to hold any haddr */
	iaddr_t	if_addrnet;		/* IP address, net part */
	short	if_dnet;		/* ddp net # */
	short	if_dnode;		/* ddp node # */
};


/*
 * Stuff dealing with IP/DDP address conversion.
 * WKS = well known socket (DDP term).
 */

#define	ipsub(ia)	((ia>>ipsubshift) & ipsubmask)
#define	ipbroadcast(ia)	((ia & 0xFF) == 0xFF)	/* Jeff would complain */
#define	ipnetpart(ia)	IN_CLASSA(ia) ? (ia & IN_CLASSA_NET) : \
		(IN_CLASSB(ia) ? (ia & IN_CLASSB_NET) : (ia & IN_CLASSC_NET))
#define	iphostpart(ia)	IN_CLASSA(ia) ? (ia & IN_CLASSA_HOST) : \
		(IN_CLASSB(ia) ? (ia & IN_CLASSB_HOST) : (ia & IN_CLASSC_HOST))


/*
 * Address families understood by interface output encapsulation 
 * routine (*if_output)();
 */
#define	AF_IP		0		/* address family IP */
#define	AF_DDP		1		/* .. .. DDP */
#define	AF_LINK		2		/* link level (ether or abus) */
#define	AF_ARP		3		/* address resolution proto */
#define	AF_SDDP		4		/* short DDP */


/*
 * Statistics.
 */
struct stats {
	int	dropabin;		/* dropped ab in pkts */
	int	dropilin;
	int	droprouteip;		/* pkts dropped by routeip */
	int	droprouteddp;
} stats;


/*
 * Low memory globals.
 */
#define	msclock	(*(long *)0x278)	/* ms clock */


/* Private field(s) used in packet buffer header */

#define	p_if(p)	(*(struct ifnet **)&((p)->p_head[0])) /* interface ptr */

/* Debug */

#define	debug

extern int dbsw;			/* debug switch */

#define	DB_ILR		1
#define	DB_ILO		2
#define	DB_ABR		4
#define	DB_ABO		8
#define	DB_PPHEAD	0x10
#define	DB_PPALL	0x20
#define	DB_DROPS	0x40


/*
 * Dartmouth implemented the 1st IP package for the Mac (by porting the
 * MIT IBM PC version).  Dartmouth originally placed the ARP protocol
 * on top of DDP, instead of LAP (all other IP ARPs are directly on top
 * of the hardware link level).  Until Dartmouth changes their package,
 * this define should be used. 
 */
#define	dartarp	1
