/*	fs.h	x.x	03/30/85	*/

/*
 * file system definitions
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/85	jks	created
 * 04/20/85	croft	added a few defines
 */


/* some of the mac error codes */
#define	noErr		0
#define	ioErr		-36
#define	fnOpnErr	-38
#define	eofErr		-39
#define	posErr		-40
#define	memFulErr	-41
#define	tmfoErr		-42
#define	fnfErr		-43
#define	wrPermErr	-44
#define	dupFnErr	-48
#define	paramErr	-50
#define	extFSErr	-58

/* file system OS trap calls */
#define	Open		0x00
#define	Close		0x01
#define	Read		0x02
#define	Write		0x03
#define	Create		0x08
#define	Delete		0x09
#define	OpenRF		0x0a
#define	Rename		0x0b
#define	GetFileInfo	0x0c
#define	SetFileInfo	0x0d
#define	UnmountVol	0x0e
#define	MountVol	0x0f
#define	Allocate	0x10
#define	GetEOF		0x11
#define	SetEOF		0x12
#define	FlushVol	0x13
#define	Eject		0x17
#define	GetFPos		0x18
#define	OffLine		0x35
#define	SetFPos		0x44
#define	FlushFile	0x45
#define	GetFileInfoByID	0xff			/* used only by efs */

#define	vblDrive	(*(int*) 0xfc)		/* drive # for post event */
#define	toExtFS		(*(int*) 0x3f2)		/* pointer to external FS */
#define	reqstVol	(*(int*) 0x3ee)		/* pointer to vcb of req */

/* queue structures */
struct qEntry {
	struct	qEntry *qLink;
	short	qType;
#define	QE_VBLQ		1		/* VBL queue */
#define	QE_IOQ		2		/* I/O queue */
#define	QE_DRIVEQ	3		/* drive queue */
#define	QE_EVENTQ	4		/* event queue */
	char	qData[1];
};

typedef	struct qEntry qEntry;

struct qHdr {
	short	qFlags;
#define	QH_INUSE	0x80
	qEntry	*qHead;
	qEntry	*qTail;
};

typedef struct qHdr qHdr;

/* per-drive information */
struct driveQ {
	struct	driveQ *dqLink;
	short	dqType;
	short	dqDrive;		/* drive number */
	short	dqRefNum;		/* driver reference number */
	short	dqFSID;			/* != 0 => external file system */
	short	dqDrvSize;		/* # of 512B blocks on drive */
};

typedef struct driveQ driveQ;

#define	drvQHdr		((struct qHdr*) 0x308)

/* per-volume information (disk copy in master directory block) */
struct volInfo {
	short	viSigWord;		/* always 0xd2d7 */
	long	viCrDate;		/* date/time of initialization */
	long	viLsBkUp;		/* date/time of last backup */
	short	viAtrb;			/* volume attributes */
#define	VI_INCONSISTENT	0x0007
#define	VI_BUSY		0x0040
#define	VI_HARDLOCK	0x0080
#define	VI_SOFTLOCK	0x8000
	short	viNmFls;		/* # of files in directory */
	short	viDirSt;		/* first logical blk of directory */
	short	viBlLen;		/* # of blocks in directory */
	short	viNmAlBlks;		/* # of allocation blks on volume */
	long	viAlBlkSiz;		/* size of allocation blocks */
	long	viClpSiz;		/* # of bytes to allocate */
	short	viAlBlSt;		/* first logical blk of alloc blk */
	long	viNxtFNum;		/* next unused file number */
	short	viFreeBlks;		/* # of unused alloc blocks */
	char	viVN;			/* length of volume name */
	char	viVName[27];		/* volume name */
};

typedef struct volInfo volInfo;

/* file buffer used in fcbBufAdr and vcbBufAdr */

#define	fileBufSize	512		/* 512 bytes data + 10 header */

struct fileBuf {
	short	fbFD;			/* file descriptor/path */
	long	fbPos;			/* file position */
	short	fbCount;		/* count of valid bytes */
	short	fbFlags;
	char	fbBuf[fileBufSize];
};

/* per-volume information (incore) */
struct volCtlBlk {
	struct	volCtlBlk *vcbLink;
	short	vcbType;
	short	vcbFlags;
#define	VCB_DIRTY	0x8000
	volInfo	vcbVI;			/* volume info from master dir blk */
	short	vcbDrvNum;		/* drive num of mounted volume */
	short	vcbDRefNum;		/* driver ref num of mounted vol */
	short	vcbFSID;		/* != 0 => external file system */
	short	vcbVRefNum;		/* volume reference number */
	long	*vcbMAdr;		/* ptr to volume block map */
	struct fileBuf *vcbBuf;		/* ptr to volume buffer */
	short	vcbMLen;		/* length of volume block map */
	short	vcbDirIndex;
	short	vcbDirBlk;
};

typedef struct volCtlBlk volCtlBlk;

#define	vcbQHdr		((struct qHdr*) 0x356)
#define	defVCBPtr	(*(volCtlBlk**) 0x352)	/* default volume */

/* file control block */
struct fileCtlBlk {
	long	fcbFlNum;		/* file number */
	char	fcbMdRByt;		/* flags */
#define	FCB_DATAWRITE	0x01		/* data can be written */
#define	FCB_RESFORK	0x02		/* resource fork */
#define	FCB_DIRTY	0x80
	char	fcbTypByt;		/* version number */
	short	fcbSBlk;		/* first alloc block of file */
	long	fcbEOF;			/* logical EOF */
	long	fcbPLen;		/* physical EOF */
	long	fcbCrPs;		/* mark */
	volCtlBlk *fcbVPtr;		/* ptr to volume control block */
	struct fileBuf *fcbBuf;		/* ptr to access path buffer */
	short	fcbFlPos;
};

typedef struct fileCtlBlk fileCtlBlk;

/* file control block buffer */
struct fileCtlBlkBuf {
	short	fcbLength;
	fileCtlBlk fcbFCB[1];
};

typedef struct fileCtlBlkBuf fileCtlBlkBuf;

#define	fcbSPtr		(*(fileCtlBlkBuf**) 0x34e)

/* I/O parameters */
struct ioParam {
	short	ioRefNum;		/* path reference number */
	char	ioVersNum;		/* version number */
	char	ioPermssn;		/* r/w permission */
#define IO_CURRENT	0		/* whatever is currently allowed */
#define	IO_READONLY	1
#define	IO_WRITEONLY	2
#define	IO_RW		3
	char	*ioMisc;
	char	*ioBuffer;		/* ptr to data buffer */
	long	ioReqCount;		/* requested number of bytes */
	long	ioActCount;		/* actual number of bytes */
	short	ioPosMode;		/* type of pos op and newline char */
#define	IO_MARK		0		/* current position of mark */
#define	IO_RELBOF	1		/* relative to BOF */
#define	IO_RELEOF	2		/* relative to EOF */
#define	IO_RELMARK	3		/* relative to mark */
#define	IO_NLMODE	0x0080		/* newline mode */
#define	IO_VERIFY	0x0040		/* verify mode */
#define	IO_NLCHAR	0xff00		/* newline character */
	long	ioPosOffset;		/* positioning offset */
};

typedef struct ioParam ioParam;

/* finder information */
struct finderInfo {
	long	fiType;			/* type of file */
	long	fiCreator;		/* creator of file */
	short	fiFlags;
#define	FI_BUNDLE	0x2000
#define	FI_INVISIBLE	0x4000
	short	fiLocation[2];
	short	fiFldr;			/* folder location */
#define	FI_TRASH	-3
#define	FI_DESKTOP	-2
#define	FI_EMPTYFOLDER	-1		/* undocumented */
#define	FI_DISK		0
};

typedef struct finderInfo finderInfo;

/* file directory entry */
struct fileDirectory {
	char	fdFlags;
#define	FD_INUSE	0x80
#define	FD_LOCKED	0x02
	char	fdTyp;			/* version number */
	char	fdUsrWds[16];
	short	fdFlNum[2];		/* file number */
	short	fdStBlk;		/* first alloc blk of data fork */
	short	fdLgLen[2];		/* logical EOF of data fork */
	short	fdPyLen[2];		/* physical EOF of data fork */
	short	fdRStBlk;		/* first alloc blk of resource fork */
	short	fdRLgLen[2];		/* logical EOF of resource fork */
	short	fdRPyLen[2];		/* physical EOF of resource fork */
	short	fdCrDat[2];
	short	fdMdDat[2];
};

typedef struct fileDirectory fileDirectory;

/* parameter block */
struct paramBlk {
	struct	paramBlk *pbLink;
	short	pbType;
#define	FSQTYPE		5
	short	pbTrap;
	ProcPtr	pbCmdAddr;
	ProcPtr	pbCompletion;		/* I/O completion routine */
	short	pbResult;		/* result error code */
	char	*pbNamePtr;		/* volume and/or file name */
	short	pbVRefNum;		/* vol ref # -, drive # + or def 0 */
	union {
		struct	ioParam pbIOP;
		struct {
			short	fdFRefNum;	/* path ref number */
			char	fdFversNum;	/* version number */
			char	fdFiller1;
			short	fdFDirIndex;	/* file directory index */
			/* expanded due to alignment problems */
			char	fdFlags;
			char	fdTyp;		/* version number */
			finderInfo fdUsrWds;
			long	fdFlNum;	/* file number */
			short	fdStBlk;	/* first alloc blk of data */
			long	fdLgLen;	/* logical EOF of data */
			long	fdPyLen;	/* physical EOF of data */
			short	fdRStBlk;	/* first alloc blk of rsrc */
			long	fdRLgLen;	/* logical EOF of rsrc */
			long	fdRPyLen;	/* physical EOF of rsrc */
			long	fdCrDat;
			long	fdMdDat;
		} pbFD;
		struct {
			long	viFiller2;
#define	viVolIndex	viVI.viSigWord;		/* volume index */
			volInfo	viVI;
		} pbVI;
		/* ctlParam pbCP; */
	} pb_un;
};

typedef struct paramBlk paramBlk;

#define	fsQHdr		((struct qHdr*) 0x360)

/* vertical retrace control block */
struct VBLCtlBlk {
	struct	VBLCtlBlk *vblLink;
	short	vblType;
	ProcPtr	vblAddr;
	short	vblCount;
	short	vblPhase;
};

typedef struct VBLCtlBlk VBLCtlBlk;

#define	vblQueue	((struct qHdr*) 0x160)
