/*	efs.c	x.x	03/30/85	*/

/*
 * External file system driver.
 */

/*
 *  Copyright (c) 1984 by John Seamons, Lucasfilm Ltd.
 *  All rights reserved.
 *
 * history
 * 07/XX/84	jks	created
 * 03/30/85	croft	added appletalk stuff
 * 04/20/85	croft/schuster	call efsScan with proper args
 */


#include <mac/quickdraw.h>
#include <mac/toolintf.h>
#include "fs.h"
#include "efs.h"

/*
 *  When the efs driver is first called the SUMACC C startup routine (crtmac)
 *  performs relocation before calling main().  We don't want to do
 *  this more than once so main() changes toExtFS to point to efs()
 *  which will invoke efsScan() without going through the crtmac routine.
 *  Note that a5 must be saved and restored.  Main() returns a pointer
 *  to the routine that posts the "disk inserted" event.  The crtmac
 *  routine normally calls ExitToShell() when main() returns.  We want
 *  to return to efsinit directly so the return link to crtmac is
 *  discarded.
 */
	asm (".text");
	asm (".globl _efs");
	asm ("_efs:");
	asm ("movl a5,_savea5");
	asm ("movl a0,sp@-");
	asm ("jbsr efsScan");
	asm ("addql #4,sp");
	asm ("movl _savea5,a5");
	asm ("rts");

/*
 * This is the VBL task that posts the disk inserted event.  Also
 * here is a 4 byte holding area for an AddrBlock.  After efsinit
 * determines the nodename/username/password and causes a remote
 * daemon to fork, efsinit stores the AddrBlock here for use by
 * the main efs driver code.
 */
	asm ("_event:");
	asm ("bras ev2");		/* skip over AddrBlock */
	asm (".globl atAddr");
	asm ("atAddr:");
	asm (".long 0");
	asm ("ev2:");
	asm ("movl #7,a0");		/* event = disk inserted */
	asm ("movl /fc,d0");		/* arg = drive number */
	asm (".word /a02f");		/* PostEvent */
	asm ("rts");

main() {
	extern int (*_efs)();

	toExtFS = (int) &_efs;
	asm ("movl _savea5,a5");
	asm ("unlk a6");
	asm ("addql #4,sp");		/* don't return to crtmac */
	asm ("movl #_event,d0");
	asm ("rts");
}

#ifdef DEBUG
#define	X	"?"

char *svc[] = {
	"Open", "Close", "Read", "Write", "Control", "Status", "KillIO",
	"GetVolInfo", "Create", "Delete", "OpenRF", "Rename", "GetFileInfo",
	"SetFileInfo", "UnmountVol", "MountVol", "Allocate", "GetEOF",
	"SetEOF", "FlushVol", "GetVol", "SetVol", "InitQueue", "Eject",
	"GetFPos", X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
	X, X, X, X, X, X, X, X, X, X, "OffLine", X, X, X, X, X, X, X, X,
	X, X, X, "SetFilLock", "RstFileLock", "SetFilType", "SetFPos",
	"FlushFile"
};
#endif

efsScan(pb)
	register paramBlk *pb;
{
	register volCtlBlk *vp = (volCtlBlk *)reqstVol;
	register driveQ *dp;
	register vRefNum, cmd;

	/* service this request */
	vRefNum = pb->pbVRefNum;
	cmd = pb->pbTrap & 0xff;
	efscmd = cmd;
#ifdef DEBUG
	if (cmd <= 0x45) {
		dprintf ("%s ", svc[cmd]);
	} else {
		printf ("? trap 0x%x pb 0x%x", cmd, pb);
		while (1);
	}
#endif
	/*
	 *  Some requests require a pointer to the
	 *  associated drive or volume queue entry.
	 */
	if (cmd == Open || cmd == OpenRF ||
	    cmd == MountVol || cmd == UnmountVol ||
	    cmd == Create || cmd == Delete) {
		if (vRefNum > 0) {	/* drive number */
			dp = (driveQ*) &drvQHdr->qHead;
			do {
				dp = dp->dqLink;
				if (vRefNum != dp->dqDrive)
					continue;
				if (dp->dqFSID != OUR_FSID)
					break;
				efsService (pb, dp);
				goto out;
			} while (dp != (driveQ*) drvQHdr->qTail);
			goto err;
		}
		efsService (pb, vp);
	} else {	/* not an Open, MountVol, etc. */
		efsService (pb, 0);
	}
	goto out;
err:
	pb->pbResult = extFSErr;
out:
/*	if (pb->pbCompletion)
		(*pb->pbCompletion)(); */
	return (pb->pbResult);
	SYM(EFSSCAN);
}

efsService (pb, ip)
register paramBlk *pb;
char *ip;
{
	driveQ *dp = (driveQ*) ip;
	volCtlBlk *vp = (volCtlBlk*) ip;
	volCtlBlk *nvp;
	register fileCtlBlk *fp;
	register struct fileBuf *fb;
	register int off, resid, reqCount;
	char *bp;
	fileCtlBlk *efsLocate();
	int actCount, eof, flNum, fd;

	efserr = 0;

	switch (efscmd) {

	case MountVol:
		/*
		 *  Construct a new volume control block and insert it
		 *  into the queue.  Scan the existing queue to assign
		 *  an unused volume reference number.  The drive number
		 *  is taken from the drive queue entry.  The remote host
		 *  supplies the volume name and a count of the number of
		 *  files on the remote machine.
		 */
	        if ((nvp = (volCtlBlk*) NewMemPtr (sizeof (volCtlBlk),
			SystemZone())) == 0)
			break;
		bzero (nvp, sizeof (volCtlBlk));
		if ((nvp->vcbBuf = (struct fileBuf *) NewMemPtr (
		    sizeof *nvp->vcbBuf, SystemZone())) == 0) {
			DisposPtr (nvp);
			break;
		}
		nvp->vcbBuf->fbFD = 0;	/* invalidate cache */
		vp = (volCtlBlk*) &vcbQHdr->qHead;
	        do {
        	        vp = vp->vcbLink;
	                nvp->vcbVRefNum = min (nvp->vcbVRefNum,
				vp->vcbVRefNum - 1);
	        } while (vp != (volCtlBlk*) vcbQHdr->qTail);
	        nvp->vcbVI.viSigWord = 0xd2d7;
		nvp->vcbVI.viDirSt = 4;
		nvp->vcbVI.viBlLen = 4;
		nvp->vcbVI.viNmAlBlks = DRIVE_SIZE/4;
		nvp->vcbVI.viAlBlkSiz = 2048;
		nvp->vcbVI.viClpSiz = 16384;
		nvp->vcbVI.viAlBlSt = 8;
		nvp->vcbVI.viNxtFNum = 0x7f;
		nvp->vcbVI.viFreeBlks = DRIVE_SIZE/4;
		nvp->vcbDrvNum = dp->dqDrive;
		nvp->vcbDRefNum = dp->dqRefNum;
	        nvp->vcbFSID = OUR_FSID;
		netIO (P1(NIL), P2(S,STR), &nvp->vcbVI.viNmFls,
			&nvp->vcbVI.viVN);
	        ((volCtlBlk*)vcbQHdr->qTail)->vcbLink = nvp;
		vcbQHdr->qTail = (qEntry*) nvp;
		break;

	case UnmountVol:
	case Eject:
#ifdef never
		/* unlink the entry from the volume queue */
		pvp->vcbLink = vp->vcbLink;
		if ((volCtlBlk*) vcbQHdr->qTail == vp)
			(volCtlBlk*) vcbQHdr->qTail = pvp;
		DisposPtr (vp);
#endif never
		break;

	case Create:
		netIO (P1(STR), pb->pbNamePtr, P1(NIL));
		if (efserr == 0)
			vp->vcbVI.viNmFls++;
		break;

	case Delete:
		netIO (P1(STR), pb->pbNamePtr, P1(NIL));
		if (efserr == 0)
			vp->vcbVI.viNmFls--;
		break;

	case Rename:
		netIO (P2(STR,STR), pb->pbNamePtr, pb->pb_un.pbIOP.ioMisc,
			P1(NIL));
		break;

	case GetFileInfo:
		if (pb->pb_un.pbFD.fdFDirIndex <= 0) {
			netIO (P1(STR), pb->pbNamePtr, P1(ARB),
				&pb->pb_un.pbFD.fdFlags,
				sizeof (fileDirectory));
		} else {
			efscmd = GetFileInfoByID;
			if (pb->pbNamePtr) {
				netIO (P1(S), pb->pb_un.pbFD.fdFDirIndex,
					P2(ARB,STR), &pb->pb_un.pbFD.fdFlags,
					sizeof (fileDirectory),
					pb->pbNamePtr);
			} else				
				netIO (P1(S), pb->pb_un.pbFD.fdFDirIndex,
					P1(ARB), &pb->pb_un.pbFD.fdFlags,
					sizeof (fileDirectory));
		}

		/* return the file reference number if the file is open */
		pb->pb_un.pbIOP.ioRefNum = 0;
		for (off=2; off<fcbSPtr->fcbLength; off+=sizeof(fileCtlBlk)) {
			fp = (fileCtlBlk*)((int)fcbSPtr + off);
			/* ONLY RETURNS 1ST FCB (per I.M.) */
			if (fp->fcbVPtr->vcbFSID == OUR_FSID &&
			    fp->fcbFlNum == pb->pb_un.pbFD.fdFlNum) {
				pb->pb_un.pbIOP.ioRefNum = off;
				break;
			}
		}
#ifdef DEBUG
		dprintf ("flg 0x%x ver %d flnum %d dst %d dlEOF %d dpEOF %d rst %d rlEOF %d rpEOF %d cr %d md %d ",
			pb->pb_un.pbFD.fdFlags,
			pb->pb_un.pbFD.fdTyp,
			pb->pb_un.pbFD.fdFlNum,
			pb->pb_un.pbFD.fdStBlk,
			pb->pb_un.pbFD.fdLgLen,
			pb->pb_un.pbFD.fdPyLen,
			pb->pb_un.pbFD.fdRStBlk,
			pb->pb_un.pbFD.fdRLgLen,
			pb->pb_un.pbFD.fdRPyLen,
			pb->pb_un.pbFD.fdCrDat,
			pb->pb_un.pbFD.fdMdDat);
#endif
		break;

	case SetFileInfo:
		netIO (P2(STR,ARB), pb->pbNamePtr, &pb->pb_un.pbFD.fdUsrWds,
			sizeof (finderInfo), P1(NIL));
		break;

	case Open:
	case OpenRF:
		if (netIO (P2(B,STR), pb->pb_un.pbIOP.ioPermssn,
		    pb->pbNamePtr, P3(L,L,L), &eof, &flNum, &fd))
			break;

		for (off=2; off<fcbSPtr->fcbLength; off+=sizeof(fileCtlBlk)) {
			fp = (fileCtlBlk*)((int)fcbSPtr + off);
			if (fp->fcbFlNum == 0)
				break;
		}
		if (off == fcbSPtr->fcbLength) {
			efserr = tmfoErr;
			break;
		}
#ifdef DEBUG
		dprintf ("new at %d ", off);
#endif

		bzero (fp, sizeof (fileCtlBlk));
		fp->fcbEOF = eof;
		fp->fcbFlNum = flNum;
		fp->fcbSBlk = fd;	/* we're hiding the UNIX fd here */
		if (pb->pb_un.pbIOP.ioPermssn & IO_WRITEONLY)
			fp->fcbMdRByt |= FCB_DATAWRITE;
		if (efscmd == OpenRF)
			fp->fcbMdRByt |= FCB_RESFORK;
		fp->fcbTypByt = pb->pb_un.pbIOP.ioVersNum;
		fp->fcbPLen = fp->fcbEOF;
		fp->fcbVPtr = vp;
		if (fp->fcbBuf = (struct fileBuf *) pb->pb_un.pbIOP.ioMisc)
			fp->fcbBuf->fbFD = 0;	/* invalidate cache */
		pb->pb_un.pbIOP.ioRefNum = off;
		break;

	case Close:
		if ((fp = efsLocate (pb)) < 0)
			break;
		if (netIO (P1(S), fp->fcbSBlk, P1(NIL)))
			break;
		fp->fcbFlNum = 0;
		break;

	case Read:
		if ((fp = efsLocate (pb)) < 0)
			break;
		if (efsMark (fp, pb))
			break;
		bp = pb->pb_un.pbIOP.ioBuffer;
		reqCount = resid = pb->pb_un.pbIOP.ioReqCount;
		pb->pb_un.pbIOP.ioActCount = 0;
		if (reqCount <= 0)
			break;
		/*
		 * If request count is small, use cache.
		 */
		if (reqCount < fileBufSize) {
			fb = fp->fcbBuf ? fp->fcbBuf : fp->fcbVPtr->vcbBuf;
			if (fb->fbFD == fp->fcbSBlk && 
			    fp->fcbCrPs >= fb->fbPos &&
			    fp->fcbCrPs + reqCount <= fb->fbPos+fb->fbCount) {
				bcopy(fb->fbBuf + (fp->fcbCrPs-fb->fbPos),
					bp, reqCount);
				fp->fcbCrPs += reqCount;
				pb->pb_un.pbIOP.ioPosOffset = fp->fcbCrPs;
				pb->pb_un.pbIOP.ioActCount += reqCount;
				break;
			}
			if (netIO (P4(L,L,S,S), fileBufSize, fp->fcbCrPs,
			    fp->fcbSBlk, pb->pb_un.pbIOP.ioPosMode,
			    P2(L,ARB), &actCount, fb->fbBuf, fileBufSize))
				break;
			fb->fbFD = fp->fcbSBlk;
			fb->fbPos = fp->fcbCrPs;
			fb->fbCount = actCount;
			reqCount = min(reqCount, actCount);
			bcopy(fb->fbBuf, bp, reqCount);
			fp->fcbCrPs += reqCount;
			pb->pb_un.pbIOP.ioPosOffset = fp->fcbCrPs;
			pb->pb_un.pbIOP.ioActCount += reqCount;
			break;
		}
		while (resid) {
			reqCount = resid;
			if (reqCount > FRAGSIZE)
				reqCount = FRAGSIZE;
			if (netIO (P4(L,L,S,S), reqCount, fp->fcbCrPs,
			    fp->fcbSBlk, pb->pb_un.pbIOP.ioPosMode,
			    P2(L,ARB), &actCount, bp, reqCount))
				break;
			fp->fcbCrPs += actCount;
			pb->pb_un.pbIOP.ioPosOffset = fp->fcbCrPs;
			if (actCount == 0) {
				efserr = eofErr;
				break;
			}
			resid -= actCount;
			bp += actCount;
			pb->pb_un.pbIOP.ioActCount += actCount;
		}
		break;

	case Write:
		fb = fp->fcbBuf ? fp->fcbBuf : fp->fcbVPtr->vcbBuf;
		/* XXX Kludge!  Just invalidate cache for now... */
		if (fp->fcbSBlk == fb->fbFD)
			fb->fbFD = 0;
		if ((fp = efsLocate (pb)) < 0)
			break;
		if (!(fp->fcbMdRByt | FCB_DATAWRITE)) {
			efserr = wrPermErr;
			break;
		}
		if (efsMark (fp, pb))
			break;
		bp = pb->pb_un.pbIOP.ioBuffer;
		resid = pb->pb_un.pbIOP.ioReqCount;
		pb->pb_un.pbIOP.ioActCount = 0;
		while (resid) {
			reqCount = resid;
			if (reqCount > FRAGSIZE)
				reqCount = FRAGSIZE;
			if (netIO (P4(L,L,S,ARB), reqCount, fp->fcbCrPs,
			    fp->fcbSBlk, bp, reqCount, P1(L), &actCount))
				break;
			fp->fcbCrPs += actCount;
			pb->pb_un.pbIOP.ioPosOffset = fp->fcbCrPs;
			if (fp->fcbCrPs > fp->fcbEOF)
				fp->fcbEOF = fp->fcbPLen = fp->fcbCrPs;
			resid -= actCount;
			bp += actCount;
			pb->pb_un.pbIOP.ioActCount += actCount;
		}
		break;

	case GetFPos:
		if ((fp = efsLocate (pb)) < 0)
			break;
		pb->pb_un.pbIOP.ioPosOffset = fp->fcbCrPs;
		pb->pb_un.pbIOP.ioReqCount = pb->pb_un.pbIOP.ioActCount =
		pb->pb_un.pbIOP.ioPosMode = 0;
		break;

	case SetFPos:
		if ((fp = efsLocate (pb)) < 0)
			break;
		efsMark (fp, pb);
		break;

	case GetEOF:
		if ((fp = efsLocate (pb)) < 0)
			break;
		*(long*)&pb->pb_un.pbIOP.ioMisc = fp->fcbEOF;
		break;

	case SetEOF:
		if ((fp = efsLocate (pb)) < 0)
			break;
		if (!(fp->fcbMdRByt | FCB_DATAWRITE)) {
			efserr = wrPermErr;
			break;
		}
		fp->fcbEOF = fp->fcbPLen = *(long*)&pb->pb_un.pbIOP.ioMisc;
		break;

	case Allocate:
		if ((fp = efsLocate (pb)) < 0)
			break;
		if (!(fp->fcbMdRByt | FCB_DATAWRITE)) {
			efserr = wrPermErr;
			break;
		}
		fp->fcbEOF += pb->pb_un.pbIOP.ioReqCount;
		fp->fcbPLen = fp->fcbEOF;
		pb->pb_un.pbIOP.ioActCount = pb->pb_un.pbIOP.ioReqCount;
		break;

	default:
		/* we don't implement everything yet.. */
		break;
	}
#ifdef DEBUG
	dprintf ("err %d ", efserr);
	dprintf ("\n\r");
#endif
	pb->pbResult = efserr;
	return;
	SYM(EFSSERV);
}

/* find the slot in the file table from a file reference number */
fileCtlBlk *efsLocate (pb)
register paramBlk *pb;
{
	register fileCtlBlk *fp;

	if ((fp = (fileCtlBlk*) ((int)fcbSPtr + pb->pb_un.pbIOP.ioRefNum))->
	    fcbFlNum == 0)
		return ((fileCtlBlk*)(efserr = fnOpnErr));
	else
		return (fp);
	SYM(EFSLOC);
}

/* validate the seek pointer (mark) */
efsMark (fp, pb)
register fileCtlBlk *fp;
register paramBlk *pb;
{
	register int mark = fp->fcbCrPs;

	switch (pb->pb_un.pbIOP.ioPosMode&3) {
	case IO_MARK:
		return (noErr);
	case IO_RELBOF:
		mark = pb->pb_un.pbIOP.ioPosOffset;
		break;
	case IO_RELEOF:
		mark = fp->fcbEOF + pb->pb_un.pbIOP.ioPosOffset;
		break;
	case IO_RELMARK:
		mark += pb->pb_un.pbIOP.ioPosOffset;
		break;
	}
	if (mark > fp->fcbEOF) {
		if ((pb->pbTrap&0xff) != Write) {
			mark = fp->fcbEOF;
			return (efserr = eofErr);
		}
	} else
	if (mark < 0) {
		mark = 0;
		return (efserr = posErr);
	}
	fp->fcbCrPs = mark;
	return (0);
	SYM(EFSMARK);
}
